/*

Copyright (C) since 2009 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorCalcMethodMstUtil;

/**
 * 計算ロジックマスタ情報操作クラス
 * 
 * @version 1.2.0
 * @since 1.2.0
 * @author uchiyama
 *
 */
public class OperateCollectCalcMaster {

	/**
	 * 計算ロジックマスタ情報を追加します。
	 * 
	 * @param data 計算ロジック情報
	 * @return 成功した場合、true
	 * @throws NamingException
	 * @throws CreateException
	 * 
	 */
	public boolean add(CollectorCalcMethodMstData data) throws CreateException, NamingException {

		// 計算ロジック情報の追加
		CollectorCalcMethodMstUtil.getLocalHome().create(
				data.getCalcMethod(),
				data.getClassName(),
				data.getExpression()
		);

		return true;
	}

	/**
	 * 計算ロジックマスタ情報を削除します。
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws EJBException
	 */
	public boolean delete(String calcMethod) throws FinderException, NamingException, EJBException, RemoveException {

		CollectorCalcMethodMstLocal local = CollectorCalcMethodMstUtil.getLocalHome().findByPrimaryKey(calcMethod);
		// pkが同じデータが登録されている場合は、削除する
		local.remove();

		return true;
	}

	/**
	 * 計算ロジックマスタ情報を全て削除します。
	 * @throws NamingException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws EJBException
	 */
	public boolean deleteAll() throws FinderException, NamingException, EJBException, RemoveException {

		Collection<CollectorCalcMethodMstLocal> col = CollectorCalcMethodMstUtil.getLocalHome().findAll();

		Iterator<CollectorCalcMethodMstLocal> itr = col.iterator();
		while(itr.hasNext()){
			itr.next().remove();
		}

		return true;
	}

}
