/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.jmx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.factory.ModifySchedule;
import com.clustercontrol.performance.jmx.PerformanceRestartManager;

/**
 * Hinemosの遅延起動サービスの制御クラス<BR>
 *
 * @version 4.0.0
 * @since 3.2.0
 */
public class HinemosDelayServiceStarter implements Runnable {

	private static Log m_log = LogFactory.getLog( HinemosDelayServiceStarter.class );

	private HinemosService service = null;

	protected HinemosDelayServiceStarter(HinemosService service) {
		this.service = service;
	}

	@Override
	public void run() {
		try {
			// 性能管理機能の全ての収集を再開する
			new PerformanceRestartManager().restartAll();

			// 監視をリスケジューリングする。
			new ModifySchedule().updateScheduleAll();
		} catch (Exception e) {
			m_log.warn("failed to start schedulers.", e);
		}
	}

}
