/*

Copyright (C) 2012 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.util;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.ejb.session.CollectiveRunControllerUtil;
import com.clustercontrol.commons.scheduler.TriggerConstant;
import com.clustercontrol.commons.scheduler.TriggerSchedulerException;
import com.clustercontrol.commons.scheduler.TriggerSchedulerFactory;
import com.clustercontrol.jobmanagement.ejb.session.JobRunManagementUtil;
import com.clustercontrol.monitor.ejb.session.MonitorControllerUtil;

/*
 * 個別の設定によらずHinemosマネージャ起動直後から定期実行する必要のあるQuartzジョブを設定します。
 */
public class QuartzCommonJobSetupUtil {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( QuartzCommonJobSetupUtil.class );

	public static void setup(){
		// 期限切れのステータス情報を削除/更新するQuartzジョブを登録します。
		// MonitorController.manageStatus() の定期呼び出しを設定します。
		m_log.info("setup MonitorController");
		try {
			TriggerSchedulerFactory.getScheduler(TriggerConstant.COMMON_INSTANCE_NAME).scheduleEjbLocalInvokerJobWithCronTrigger(
					"MonitorController",
					"MON",
					MonitorControllerUtil.getLocalHome(),
					"manageStatus",
					new Object[0],
					new Class[0],
					null,
					true,
					true,
			"0 */5 * * * ? *");
		} catch (TriggerSchedulerException e) {
			m_log.warn("setup() MonitorController " + e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("setup() MonitorController " + e.getMessage(), e);
		}

		// ジョブセッションをチェックし、実行可能なジョブを開始するQuartzジョブを設定します。
		// JobRunManagement.run() の定期呼び出しを設定します。
		m_log.info("setup JobRunManagement");
		try {
			TriggerSchedulerFactory.getScheduler(TriggerConstant.COMMON_INSTANCE_NAME).scheduleEjbLocalInvokerJobWithCronTrigger(
					"JobRunManagement",
					"JOB_MANAGEMENT",
					JobRunManagementUtil.getLocalHome(),
					"run",
					new Object[0],
					new Class[0],
					null,
					true,
					true,
			"0 */1 * * * ? *");
		} catch (TriggerSchedulerException e) {
			m_log.warn("setup() JobRunManagement " + e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("setup() JobRunManagement " + e.getMessage(), e);
		}

		// 一括制御セッションの終了状態をチェックします。
		// CollectiveRunController.checkEndSession() の定期呼び出しを設定します。
		m_log.info("setup CollectiveRunController");
		try {
			TriggerSchedulerFactory.getScheduler(TriggerConstant.COMMON_INSTANCE_NAME).scheduleEjbLocalInvokerJobWithCronTrigger(
					"CollectiveRunController",
					"CRUN_MANAGEMENT",
					CollectiveRunControllerUtil.getLocalHome(),
					"checkEndSession",
					new Object[0],
					new Class[0],
					null,
					true,
					true,
			"*/30 * * * * ? *");
		} catch (TriggerSchedulerException e) {
			m_log.warn("setup() JobRunManagement " + e.getMessage(), e);
		} catch (NamingException e) {
			m_log.warn("setup() JobRunManagement " + e.getMessage(), e);
		}
	}
}
