/*

Copyright (C) 2011 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.custom.ejb.session;

import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.CustomInvalid;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.custom.bean.CommandExecuteDTO;
import com.clustercontrol.custom.bean.CommandResultDTO;
import com.clustercontrol.custom.factory.RunCustom;
import com.clustercontrol.custom.factory.SelectCustom;

/**
 * @ejb.bean
 *     name="MonitorCustomController"
 *     jndi-name="MonitorCustomController"
 *     type="Stateless"
 *     transaction-type="Container"
 *     view-type="local"
 * 
 * @ejb.transaction type="Required"
 * 
 * @jboss.depends
 *     name="jboss.j2ee:service=EJB,jndiName=MonitorCustomInfoLocal"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 * 
 * @since 4.0
 * @author Tomoya Takahata
 */
@SuppressWarnings("serial")
public abstract class MonitorCustomControllerBean implements SessionBean {

	private static Log log = LogFactory.getLog( MonitorCustomControllerBean.class );

	private SessionContext ctx;

	@Override
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		this.ctx = ctx;
	}

	/**
	 * 要求してきたエージェントに対して、コマンド監視として実行すべきコマンド実行情報を返す
	 * @param requestedFacilityId エージェントが対応するノードのfacilityId
	 * @return コマンド実行情報の一覧
	 * @throws CustomInvalid コマンド実行情報に不整合が見つかった場合
	 * @throws HinemosUnknown 予期せぬエラーが発生した場合
	 * 
	 * @ejb.interface-method
	 */
	public ArrayList<CommandExecuteDTO> getCommandExecuteDTO(String requestedFacilityId) throws CustomInvalid, HinemosUnknown {
		SelectCustom selector = new SelectCustom();

		return selector.getCommandExecuteDTO(requestedFacilityId);
	}


	/**
	 * エージェントから送信されてきたコマンド実行結果に対して、閾値判定および結果生成を行う
	 * @param CommandResultDTO エージェントから送信されたコマンド実行結果
	 * @throws MonitorNotFound 送信されたコマンド監視設定がすでに存在しない場合
	 * @throws HinemosUnknown 予期せぬエラーが発生した場合
	 * @throws CustomInvalid 監視設定に不整合が存在する場合
	 * 
	 * @ejb.interface-method
	 */
	public void CustomResultDTO(CommandResultDTO dto) throws HinemosUnknown, MonitorNotFound, CustomInvalid {
		RunCustom runner = null;

		try {
			runner = new RunCustom(dto);
			runner.monitor();
		} catch (HinemosUnknown e) {
			log.warn(e);
			throw e;
		} catch (MonitorNotFound e) {
			log.warn(e);
			throw e;
		} catch (CustomInvalid e) {
			log.warn(e);
			throw e;
		}
	}

}
