/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.http.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.http.util.ControlHttpInfo;
import com.clustercontrol.monitor.run.factory.DeleteMonitor;

/**
 * HTTP監視 数値監視情報をマネージャから削除するクラス<BR>
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteMonitorHttp extends DeleteMonitor{

	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.DeleteMonitor#deleteCheckInfo()
	 */
	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException, NamingException {

		// HTTP監視情報を削除
		ControlHttpInfo http = new ControlHttpInfo(m_monitorId, m_monitorTypeId);
		return http.delete();
	}
}
