/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlType;

/**
 * ジョブの終了状態に関する情報を保持するクラス<BR>
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
@XmlType(namespace = "http://jobmanagement.ws.clustercontrol.com")
public class JobEndStatusInfo implements Serializable, Cloneable {
	/** シリアライズ可能クラスに定義するUID */
	private static final long serialVersionUID = 5256607875379422805L;

	/** 終了状態の種別 */
	private Integer m_type = new Integer(0);

	/** 終了状態の終了値 */
	private Integer m_value = new Integer(0);

	/** 終了値範囲(開始) */
	private Integer m_startRangeValue = new Integer(0);

	/** 終了値範囲(終了) */
	private Integer m_endRangeValue = new Integer(0);

	/**
	 * 終了値範囲(終了)を返す
	 * @return 終了値範囲(終了)
	 */
	public Integer getEndRangeValue() {
		return m_endRangeValue;
	}

	/**
	 * 終了値範囲(終了)を設定する。<BR>
	 * @param endRangeValue 終了値範囲(終了)
	 */
	public void setEndRangeValue(Integer endRangeValue) {
		this.m_endRangeValue = endRangeValue;
	}

	/**
	 * 終了値範囲(開始)を返す。<BR>
	 * @return 終了値範囲(開始)
	 */
	public Integer getStartRangeValue() {
		return m_startRangeValue;
	}

	/**
	 * 終了値範囲(開始)を設定する。<BR>
	 * @param startRangeValue 終了値範囲(開始)
	 */
	public void setStartRangeValue(Integer startRangeValue) {
		this.m_startRangeValue = startRangeValue;
	}

	/**
	 * 終了状態の種別を返す。<BR>
	 * @return 終了状態の種別
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public Integer getType() {
		return m_type;
	}

	/**
	 * 終了状態の種別を設定する。<BR>
	 * @param type 終了状態の種別
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setType(Integer type) {
		this.m_type = type;
	}

	/**
	 * 終了状態の終了値を返す。<BR>
	 * @return 終了状態の終了値
	 */
	public Integer getValue() {
		return m_value;
	}

	/**
	 * 終了状態の終了値を設定する。<BR>
	 * @param value 終了状態の終了値
	 */
	public void setValue(Integer value) {
		this.m_value = value;
	}

	/**
	 * ジョブ終了状態情報のクローンを作成する。<BR>
	 * @return ジョブ終了状態情報のクローン
	 * @see java.lang.Object#clone()
	 */
	@Override
	protected Object clone() {
		try {
			JobEndStatusInfo clone = (JobEndStatusInfo)super.clone();

			clone.setEndRangeValue(this.getEndRangeValue());
			clone.setStartRangeValue(this.getStartRangeValue());
			clone.setType(this.getType());
			clone.setValue(this.getValue());

			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}