/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * ジョブ通知マスタのBMP Entity Bean クラス<BR>
 * 
 * @ejb.bean name="JobNoticeMaster"
 *    jndi-name="JobNoticeMaster"
 *    type="BMP"
 *    view-type="local"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config BMP EntityBean"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @ejb.dao
 *    class="com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAO"
 *    impl-class="com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAO
 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl
 */
public abstract class JobNoticeMasterBean implements javax.ejb.EntityBean {
	/** 所属ジョブユニットのジョブID **/
	protected String jobunit_id;
	/** ジョブID */
	protected String job_id;
	/** 終了状態 */
	protected Integer notice_type;
	/** 重要度 */
	protected Integer priority;
	/** 通知グループID */
	protected String notifyGroupId;

	/**
	 * ジョブ通知マスタを生成します。
	 * 
	 * @ejb.create-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 * @param job_id ジョブID
	 * @param notice_type 終了状態
	 * @param priority 重要度
	 * @param notify_id 通知ID
	 * @return プライマリーキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public JobNoticeMasterPK ejbCreate(
			String jobunit_id,
			String job_id,
			Integer notice_type,
			Integer priority,
			String notifyGroupId
	) throws javax.ejb.CreateException {
		this.jobunit_id = jobunit_id;
		this.job_id = job_id;
		this.notice_type = notice_type;
		this.priority = priority;
		this.notifyGroupId = notifyGroupId;
		return null;
	}

	/**
	 * 全てのジョブ通知マスタを検索します。
	 * 
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl#findAll()
	 */
	public Collection ejbFindAll() throws FinderException {
		return null;
	}

	/**
	 * プライマリキーに一致するジョブ通知マスタを検索します。
	 * 
	 * @param pk プライマリキー
	 * @return プライマリキー
	 * @throws FinderException
	 * 
	 * @see com.clustercontrol.jobmanagement.dao.JobNoticeMasterDAOImpl#findByPrimaryKey(JobNoticeMasterPK)
	 */
	public JobNoticeMasterPK ejbFindByPrimaryKey(JobNoticeMasterPK pk) throws FinderException {
		return null;
	}

	/**
	 * ジョブIDに一致するジョブ通知マスタを検索します。
	 * 
	 * @param job_id ジョブID
	 * @return プライマリキーのコレクション
	 * @throws FinderException
	 * 
	 */
	public Collection ejbFindByJobunitJob(String jobunit_id, String job_id) throws FinderException {
		return null;
	}


	/**
	 * 所属ジョブユニットのジョブIDを返す。<BR>
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return 所属ジョブユニットのジョブID
	 */
	public java.lang.String getJobunit_id() {
		return jobunit_id;
	}

	/**
	 * 所属ジョブユニットのジョブIDを設定する。<BR>
	 * 
	 * @ejb.interface-method
	 * 
	 * @param jobunit_id 所属ジョブユニットのジョブID
	 */
	public void setJobunit_id(java.lang.String jobunit_id) {
		this.jobunit_id = jobunit_id;
	}

	/**
	 * ジョブIDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return ジョブID
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}

	/**
	 * ジョブIDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param job_id ジョブID
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}

	/**
	 * 終了状態を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.pk-field
	 * @ejb.interface-method
	 * 
	 * @return 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public java.lang.Integer getNotice_type() {
		return notice_type;
	}

	/**
	 * 終了状態を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notice_type 終了状態
	 * 
	 * @see com.clustercontrol.bean.EndStatusConstant
	 */
	public void setNotice_type(java.lang.Integer notice_type) {
		this.notice_type = notice_type;
	}

	/**
	 * 重要度を返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public java.lang.Integer getPriority() {
		return priority;
	}

	/**
	 * 重要度を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public void setPriority(java.lang.Integer priority) {
		this.priority = priority;
	}

	/**
	 * 通知IDを返す。
	 * 
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 * 
	 * @return 通知グループID
	 */
	public java.lang.String getNotifyGroupId() {
		return notifyGroupId;
	}

	/**
	 * 通知IDを設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notify_id 通知グループID
	 */
	public void setNotifyGroupId(java.lang.String notifyGroupId) {
		this.notifyGroupId = notifyGroupId;
	}

	/**
	 * ジョブマスタを取得する。
	 * 
	 * @ejb.interface-method view-type="local"
	 * 
	 * @return ジョブマスタ
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK
	 * @see com.clustercontrol.jobmanagement.ejb.entity.JobMasterBean#ejbFindByPrimaryKey(JobMasterPK)
	 */
	public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJobunit_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}



}
