package com.clustercontrol.jobmanagement.factory;

import javax.management.ObjectName;
import javax.naming.InitialContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

/**
 * ジョブマスターのキャッシュをリフレッシュするクラスです。
 * CASCADEで削除するため、キャッシュに存在するけど、DBに存在しないという状態になってしまいます。
 * これを防ぐために、削除後に実行する必要があります。
 *
 */
public class JobMstCache {
	private static Log m_log = LogFactory.getLog( JobMstCache.class );
	/**
	 * RMIAdaptorのルックアップ名。<BR>
	 * イベント情報のキャッシュをフラッシュするために使用します。
	 */
	private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	/**
	 * 操作名。<BR>
	 * キャッシュをフラッシュする操作名を指定します。
	 */
	private static final String OPERATION_NAME = "flushCache";

	/**
	 * ジョブ履歴のオブジェクト名。<BR>
	 * キャッシュをフラッシュするオブジェクト名を指定します。
	 */
	private static final String[] objectName =
	{"jboss.j2ee:jndiName=JobRelationMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobCommandMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobFileMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobStartMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobStartJobMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobEndMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobParamMasterLocal,service=EJB",
		"jboss.j2ee:jndiName=JobUserRelationMasterLocal,service=EJB"
	};

	public static void clear () {
		m_log.debug("clear() objectName[] size : " + objectName.length);

		//Flush Entity Cache
		try{
			InitialContext ic = new InitialContext();

			//RMIAdaptorを取得
			RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

			for (int i = 0; i < objectName.length; i++) {
				m_log.debug("cacheReflesh() objectName : " + objectName[i]);
				//ObjectNameを設定
				ObjectName name = new ObjectName(objectName[i]);

				//ObjectNameのOperationNameのメソッドを実行
				server.invoke(name, OPERATION_NAME, null, null);
			}
		} catch (Exception e) {
			m_log.warn("clear() Unknown Error ", e);
		}
	}
}
