/*

Copyright (C) 2007 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.ejb.entity;

import java.rmi.RemoteException;
import java.sql.Timestamp;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

/**
 * 
 * メンテナンス情報を保持するEntity Beanです。
 * 
 * @ejb.bean name="MaintenanceInfo"
 *    display-name="MaintenanceInfo"
 *    description="MaintenanceInfo"
 *    jndi-name="MaintenanceInfo"
 *    type="CMP"
 *    view-type="local"
 *    cmp-version="2.x"
 *    schema="MaintenanceInfo"
 *    data-source="java:/DefaultDS"
 *    primkey-field="maintenance_id"
 * 
 * @ejb.persistence
 *    table-name="public.cc_maintenance_info"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MaintenanceInfo as a"
 *    signature="java.util.Collection findAll()"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MaintenanceInfo as a WHERE a.maintenance_id = ?1"
 *    signature="java.util.Collection findAll(java.lang.String maintenance_id)"
 * 
 * @ejb.finder
 *    query="SELECT OBJECT(a) FROM MaintenanceInfo as a ORDER BY a.maintenance_id"
 *    signature="java.util.Collection findAllOrderByMaintenanceId()"
 * 
 * @ejb.pk class="java.lang.String"
 * 
 * @ejb.permission
 *    unchecked="true"
 * 
 * @jboss.depends
 *    name="jboss.jca:service=DataSourceBinding,name=DefaultDS"
 * 
 * @jboss.container-configuration
 *    name="Hinemos Config CMP 2.x EntityBean"
 * 
 * @jboss.read-ahead
 *    strategy="on-load"
 * 
 * @jboss.method-attributes
 *    pattern="get*"
 *    read-only="true"
 * 
 * @jboss.persistence
 *    datasource="java:/DefaultDS"
 *    datasource-mapping="PostgreSQL 8.0"
 *    table-name="public.cc_maintenance_info"
 *    create-table="false"
 *    remove-table="false"
 *    alter-table="false"
 */
public abstract class MaintenanceInfoBean implements EntityBean {


	public MaintenanceInfoBean() {
		super();
		// TODO 自動生成されたコンストラクター・スタブ
	}

	@Override
	public void setEntityContext(EntityContext ctx)
	throws EJBException,
	RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	@Override
	public void unsetEntityContext() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}



	/**
	 * 
	 * @ejb.create-method
	 * 
	 * @param maintenance_id
	 * @param description
	 * @param type_id
	 * @param dataRetentionPeriod
	 * @param calendar_id
	 * @param schedule_date
	 * @param notifyGroupId
	 * @param application
	 * @param valid_flg
	 * @param notifyId
	 * @param reg_user
	 * @param reg_date
	 * @param update_user
	 * @param update_date
	 * @return
	 * @throws CreateException
	 */
	public String ejbCreate(
			String maintenance_id,
			String description,
			String type_id,
			Integer dataRetentionPeriod,
			String calendar_id,
			Integer schedule_type,
			Integer month,
			Integer day,
			Integer week,
			Integer hour,
			Integer minute,
			String notifyGroupId,
			String application,
			Integer valid_flg,
			String reg_user,
			Timestamp reg_date,
			String update_user,
			Timestamp update_date
	) throws CreateException {

		this.setMaintenance_id(maintenance_id);
		this.setDescription(description);
		this.setType_id(type_id);
		this.setDataRetentionPeriod(dataRetentionPeriod);
		this.setCalendar_id(calendar_id);
		this.setSchedule_type(schedule_type);
		this.setMonth(month);
		this.setDay(day);
		this.setWeek(week);
		this.setHour(hour);
		this.setMinute(minute);
		this.setNotifyGroupId(notifyGroupId);
		this.setApplication(application);
		this.setValid_flg(valid_flg);
		this.setRegUser(reg_user);
		this.setRegDate(reg_date);
		this.setUpdateUser(update_user);
		this.setUpdateDate(update_date);

		return null;
	}

	public void ejbPostCreate() throws CreateException {}

	@Override
	public void ejbRemove()
	throws RemoveException,
	EJBException,
	RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	@Override
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	@Override
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	@Override
	public void ejbLoad() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	@Override
	public void ejbStore() throws EJBException, RemoteException {
		// TODO 自動生成されたメソッド・スタブ

	}

	/**
	 * 
	 * メンテナンスIDを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="maintenance_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * 
	 * @ejb.pk-field
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract String getMaintenance_id();

	/**
	 * 
	 * メンテナンスIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param maintenance_id
	 */
	public abstract void setMaintenance_id(String maintenance_id);


	/**
	 * 説明を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();

	/**
	 * 
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param maintenance_id
	 */
	public abstract void setDescription(String description);


	/**
	 * 
	 * 種別IDを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract String getType_id();

	/**
	 * 
	 * 種別IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param type_id
	 */
	public abstract void setType_id(String type_id);

	/**
	 * 
	 * 削除対象外の日数を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="data_retention_period"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getDataRetentionPeriod();

	/**
	 * 
	 * 削除対象外の日数を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param dataRetentionPeriod
	 */
	public abstract void setDataRetentionPeriod(Integer dataRetentionPeriod);


	/**
	 * カレンダIDを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="calendar_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return カレンダID
	 */
	public abstract String getCalendar_id();


	/**
	 * 
	 * カレンダIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param calendarId カレンダID
	 */
	public abstract void setCalendar_id(String calendar_id);


	/**
	 * スケジュール種別を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="schedule_type"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return スケジュール種別
	 */
	public abstract Integer getSchedule_type();

	/**
	 * スケジュール種別を設定する。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param schedule_type スケジュール種別
	 */
	public abstract void setSchedule_type(Integer schedule_type);


	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="month"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getMonth();

	/**
	 * @ejb.interface-method
	 * 
	 * @param month
	 */
	public abstract void setMonth(Integer month);

	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="day"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getDay();

	/**
	 * @ejb.interface-method
	 * 
	 * @param day
	 */
	public abstract void setDay(Integer day);

	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="week"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getWeek();

	/**
	 * @ejb.interface-method
	 * 
	 * @param week
	 */
	public abstract void setWeek(Integer week);

	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="hour"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getHour();

	/**
	 * @ejb.interface-method
	 * 
	 * @param month
	 */
	public abstract void setHour(Integer hour);

	/**
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="minute"
	 *     jdbc-type="INTEGER"
	 *     sql-type="integer"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getMinute();

	/**
	 * @ejb.interface-method
	 * 
	 * @param month
	 */
	public abstract void setMinute(Integer minute);



	/**
	 * 通知グループIDを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="notify_group_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyGroupId();


	/**
	 * 
	 * 通知グループIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notify_id
	 */
	public abstract void setNotifyGroupId(String notifyGroupId);


	/**
	 * アプリケーションを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="application"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return アプリケーション
	 */
	public abstract String getApplication();

	/**
	 * 
	 * アプリケーションを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param application
	 */
	public abstract void setApplication(String application);

	/**
	 * 
	 * 有効(1)/無効(0)フラグを取得します。
	 * 
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return
	 */
	public abstract Integer getValid_flg();

	/**
	 * 
	 * アプリケーションを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param valid_flg
	 */
	public abstract void setValid_flg(Integer valid_flg);


	/**
	 * 新規作成ユーザを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="reg_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 新規作成ユーザ
	 */
	public abstract java.lang.String getRegUser();

	/**
	 * 新規作成ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regUser 新規作成ユーザ
	 */
	public abstract void setRegUser(java.lang.String regUser);


	/**
	 * 
	 * 作成日時を取得します
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="reg_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract Timestamp getRegDate();

	/**
	 * 
	 * 作成日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param regDate The regDate to set.
	 */
	public abstract void setRegDate(Timestamp regDate);


	/**
	 * 最終変更ユーザを取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="update_user"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終変更ユーザ
	 */
	public abstract java.lang.String getUpdateUser();

	/**
	 * 最終変更ユーザを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateUser 最終変更ユーザ
	 */
	public abstract void setUpdateUser(java.lang.String updateUser);


	/**
	 * 
	 * 更新日時を取得します。
	 * 
	 * @ejb.persistent-field
	 * @ejb.persistence
	 *    column-name="update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract Timestamp getUpdateDate();

	/**
	 * 
	 * 更新日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param updateDate The updateDate to set.
	 */
	public abstract void setUpdateDate(Timestamp updateDate);


}
