/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.maintenance.factory;

import java.rmi.RemoteException;
import java.text.ParseException;

import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.commons.scheduler.QuartzUtil;
import com.clustercontrol.commons.scheduler.TriggerConstant;
import com.clustercontrol.commons.scheduler.TriggerSchedulerException;
import com.clustercontrol.commons.scheduler.TriggerSchedulerFactory;
import com.clustercontrol.maintenance.bean.QuartzConstant;
import com.clustercontrol.maintenance.bean.MaintenanceInfo;
import com.clustercontrol.maintenance.ejb.session.MaintenanceControllerUtil;

/**
 * スケジュール情報を操作するクラスです。
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class ModifySchedule {
	/** ログ出力のインスタンス */
	private static Log m_log = LogFactory.getLog( ModifySchedule.class );

	/**
	 * スケジュール情報を基にQuartzにジョブを登録します。<BR>
	 * Quartzからは、{@link com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#scheduleRunJob(String, String)} が呼び出されます。
	 * 
	 * @param info スケジュール情報
	 * @param user ユーザID
	 * @throws ParseException
	 * @throws NamingException
	 * @throws SchedulerException
	 * @throws RemoteException
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.QuartzConstant
	 * @see com.clustercontrol.jobmanagement.util.QuartzUtil#getQuartzManager()
	 */
	public void addSchedule(MaintenanceInfo info, String user) throws TriggerSchedulerException, NamingException, RemoteException {
		m_log.debug("addSchedule() : id=" + info.getMaintenanceId());

		//JobDetailに呼び出すメソッドの引数を設定
		//ジョブIDを設定
		Object[] jdArgs = new Object[2];
		Class[] jdArgsType = new Class[2];
		jdArgs[0] = info.getMaintenanceId();
		jdArgsType[0] = String.class;
		//カレンダIDを設定
		jdArgs[1] = info.getCalendarId();
		jdArgsType[1] = String.class;

		try {
			TriggerSchedulerFactory.getScheduler(TriggerConstant.MAINTENANCE_INSTANCE_NAME).scheduleEjbLocalInvokerJobWithCronTrigger(
					info.getMaintenanceId(),
					QuartzConstant.GROUP_NAME,
					MaintenanceControllerUtil.getLocalHome(),
					QuartzConstant.METHOD_NAME,
					jdArgs,
					jdArgsType,
					null,
					true,
					ValidConstant.typeToBoolean(info.getValidFlg()),
					QuartzUtil.getCronString(info.getSchedule()));
		} catch (TriggerSchedulerException e) {
			m_log.warn("addSchedule() addSchedule : id=" + info.getMaintenanceId() + ", " + e.getMessage(), e);
			throw e;
		} catch (NamingException e) {
			String msg = "addSchedule() addSchedule : id=" + info.getMaintenanceId() + ", " + e.getMessage();
			m_log.warn(msg, e);
			throw new TriggerSchedulerException(msg, e);
		}
	}

	/**
	 * スケジュール情報を基にQuartzに登録したジョブを削除します。
	 * 
	 * @param scheduleId スケジュールID
	 * @throws NamingException
	 * @throws SchedulerException
	 * @throws RemoteException
	 * 
	 * @see com.clustercontrol.jobmanagement.bean.QuartzConstant
	 * @see com.clustercontrol.jobmanagement.util.QuartzUtil#getQuartzManager()
	 * @see com.clustercontrol.quartzmanager.ejb.session.QuartzManager#deleteSchedule(java.lang.String, java.lang.String)
	 */
	public void deleteSchedule(String scheduleId) throws NamingException, TriggerSchedulerException {
		m_log.debug("deleteSchedule() : id=" + scheduleId);

		try {
			//ジョブ削除
			TriggerSchedulerFactory.getScheduler(TriggerConstant.MAINTENANCE_INSTANCE_NAME).deleteJob(scheduleId, QuartzConstant.GROUP_NAME);
		} catch (TriggerSchedulerException e) {
			m_log.warn("deleteQuartz() deleteJob : " + e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
	}
}
