package com.clustercontrol.monitor.run.factory;

import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorTrapValueInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTrapValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorTrapValueInfoUtil;

/**
 * SNMPTRAP監視の判定情報を作成する抽象クラス<BR>
 * <p>
 * SNMPTRAP監視を行う各監視管理クラスで継承してください。
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public abstract class AddMonitorTrapValueType extends AddMonitor {

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( AddMonitorTrapValueType.class );

	@Override
	protected boolean addJudgementInfo() throws CreateException, NamingException,
	HinemosUnknown {
		m_log.debug("addJudgementInfo() : start");

		ArrayList<MonitorTrapValueInfo> valueList = m_monitorInfo.getTrapValueInfo();
		ArrayList<MonitorTrapValueInfoLocal> valueLocalList = new ArrayList<MonitorTrapValueInfoLocal>();

		// SNMPTRAP監視判定情報を設定
		if(valueList == null){
			m_log.debug("addJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() + ", MonitorTrapValueInfo List is null");
			return true;
		}

		MonitorTrapValueInfo value = null;
		for(int index=0; index<valueList.size(); index++){
			value = valueList.get(index);

			if(value != null){
				MonitorTrapValueInfoLocal local = MonitorTrapValueInfoUtil.getLocalHome().create(
						m_monitorInfo.getMonitorId(),
						value.getMib(),
						value.getTrapOid(),
						value.getGenericId(),
						value.getSpecificId(),
						value.getUei(),
						ValidConstant.booleanToType(value.isValidFlg()),
						value.getPriority(),
						value.getLogmsg(),
						value.getDescr());
				valueLocalList.add(local);

				// for debug
				m_log.debug("addJudgementInfo() : MonitorId = " + m_monitorInfo.getMonitorId() +
						",Mib = " + value.getMib() +
						",TrapOid = " + value.getTrapOid() +
						",GenericId = " + value.getGenericId() +
						",SpecificId = " + value.getSpecificId() +
						",Uei = " + value.getUei() +
						",ValidFlg = " + value.isValidFlg() +
						",Priority = " + value.getPriority() +
						",Logmsg = " + value.getLogmsg() +
						",Descr = " + value.getDescr());

			}
		}

		m_log.debug("addJudgementInfo() : end");
		return true;
	}
}
