/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.notify.ejb.mdb;

import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.bean.NotifyRequestMessage;
import com.clustercontrol.notify.util.RunJob;

/**
 * ジョブ実行を行う Message-Driven Bean <BR>
 * <p>ジョブ管理機能のジョブを呼出します。<BR>
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="NotifyJobBean"
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 * 
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrolNotifyJob"
 * 
 * @jboss.depends name="user:service=HinemosService,name=HinemosService"
 * 
 * @jboss.container-configuration
 *  name="Hinemos Notification Message Driven Bean"
 * 
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrolNotifyJob"
 * @jboss.destination-jndi-name name="queue/clustercontrolNotifyJob"
 *
 *--
 * <!-- end-xdoclet-definition -->
 **/
public class NotifyJobBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {

	private static final long serialVersionUID = 3845354934692690830L;

	/** ログ出力のインスタンス。 */
	private static Log m_log = LogFactory.getLog( NotifyJobBean.class );

	/** ジョブ実行 */
	private static RunJob m_run = new RunJob();

	/** コンテキスト情報 */
	private javax.ejb.MessageDrivenContext messageContext = null;

	/**
	 * コンテキスト情報を設定します。<BR>
	 * Message-Driven Bean がインスタンスプールに格納される際に行う処理を実装します。
	 * @see javax.ejb.MessageDrivenBean#setMessageDrivenContext(javax.ejb.MessageDrivenContext)
	 */
	@Override
	public void setMessageDrivenContext(
			javax.ejb.MessageDrivenContext messageContext)
	throws javax.ejb.EJBException {
		this.messageContext = messageContext;
	}

	/**
	 * Message-Driven Bean が生成される際に行う処理を実装します。
	 * @ejb.create-method
	 */
	public void ejbCreate() {
		//no specific action required for message-driven beans
	}

	/**
	 * Message-Driven Bean が削除される際に行う処理を実装します。
	 * @see javax.ejb.MessageDrivenBean#ejbRemove()
	 */
	@Override
	public void ejbRemove() {
		messageContext = null;
	}

	/**
	 * 引数で指定された受信メッセージを元に、ジョブ実行をおこないます。<BR>
	 * Message-Driven Bean で行うビジネスロジックを実装します。
	 * 特定のメッセージを受信した場合のみ処理を行います。受信メッセージは下記の通りです。
	 * 
	 * <p><li>{@link com.clustercontrol.notify.message.OutputNotifyGroupInfo} :
	 * 含まれている出力情報を基にジョブを呼出します。
	 * ジョブの呼出に失敗した場合は、出力情報の呼出失敗時の重要度で監視管理機能のイベントへ通知します。
	 *
	 * @see javax.jms.MessageListener#onMessage(javax.jms.Message)
	 * 
	 * @see com.clustercontrol.notify.util.RunJob#runJob(OutputNotifyGroupInfo)
	 * @see com.clustercontrol.notify.message.OutputNotifyGroupInfo
	 */
	@Override
	@SuppressWarnings("unchecked")
	public void onMessage(javax.jms.Message message) {
		m_log.debug("Message Driven Bean got message " + message);

		if(message instanceof ObjectMessage) {
			ObjectMessage msg = (ObjectMessage)message;

			try {
				Object objMsg = msg.getObject();
				if(objMsg instanceof NotifyRequestMessage) {
					NotifyRequestMessage requestMessage = (NotifyRequestMessage)objMsg;
					m_run.notify(requestMessage);
				}
				else {
					m_log.debug("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString());
				}
			}
			catch(JMSException e) {
				m_log.error("onMessage():" + e.getMessage(), e);
			}
			catch(EJBException e) {
				m_log.error("onMessage():" + e.getMessage(), e);
			}
			catch (Exception e) {
				m_log.error("onMessage():" + e.getMessage(), e);
			}

		}
	}
}