/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

 */

package com.clustercontrol.performance.bean;

import java.util.Date;

import javax.xml.bind.annotation.XmlType;

/**
 * ポーラーにより収集されたデータを保持するクラス
 * 
 * SNMPのOIDと収集日時により一意に特定される性能値を保持します。
 * 
 * @version 1.0
 * @since 1.0
 */
@XmlType(namespace = "http://collector.ws.clustercontrol.com")
public class RawValue {
private String m_OID;
private Date m_date;
private long m_value;


/**
 * コンストラクター
 * @param date
 * @param value
 */
public RawValue(String OID, Date date, long value) {
this.m_OID = OID;
this.m_date = date;
this.m_value = value;
}
/**
 * コンストラクター
 * @param date
 * @param value
 */
public RawValue(Date date, long value) {

	this.m_date = date;
	this.m_value = value;
}

/**
 * 収集日時を取得します。
 * @return date 収集日時
 */
public Date getDate() {
	return m_date;
}

/**
 * 収集日時を設定します。
 * @param date 収集日時
 */
public void setDate(Date date) {
	this.m_date = date;
}

/**
 * 性能値を取得します。
 * @return value 性能値
 */
public long getValue() {
	return m_value;
}

/**
 * 性能値を設定します。
 * @param value 性能値
 */
public void setValue(int value) {
	this.m_value = value;
}

/**
 * OIDを取得します。
 * @return OID SNMPのOID
 */
public String getOID() {
	return m_OID;
}

/**
 * OIDを設定します。
 * @param OID SNMPのOID
 */
public void setM_OID(String OID) {
	m_OID = OID;
}
}
