/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.port.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.clustercontrol.commons.scheduler.TriggerScheduler;
import com.clustercontrol.monitor.run.factory.AddMonitor;
import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;
import com.clustercontrol.port.bean.PortCheckInfo;
import com.clustercontrol.port.ejb.entity.MonitorPortInfoUtil;

/**
 * port監視情報登録クラス
 *
 * @version 4.0.0
 * @since 2.4.0
 */
public class AddMonitorPort extends AddMonitorNumericValueType{

	/* (非 Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	protected boolean addCheckInfo() throws CreateException, NamingException{

		// port監視情報を設定
		PortCheckInfo port = m_monitorInfo.getPortCheckInfo();

		MonitorPortInfoUtil.getLocalHome().create(
				m_monitorInfo.getMonitorId(),
				port.getPortNo(),
				port.getRunCount(),
				port.getRunInterval(),
				port.getTimeout(),
				port.getServiceId());
		return true;
	}

	/**
	 * スケジュール実行の遅延時間を返します。
	 */
	@Override
	protected int getDelayTime() {
		return AddMonitor.getDelayTimeBasic(m_monitorInfo);
	}

	/**
	 * スケジュール実行種別を返します。
	 */
	@Override
	protected String getTriggerType() {
		return TriggerScheduler.TRIGGER_TYPE_SIMPLE;
	}
}
