package com.clustercontrol.process.factory;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstData;
import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstLocal;
import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstPK;
import com.clustercontrol.process.ejb.entity.MonitorProcessPollingMstUtil;

/**
 * プロセス監視のキャッシュ
 *
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class ProcessMasterCache {
	private static Log m_log = LogFactory.getLog( ProcessMasterCache.class );

	private static ConcurrentHashMap<MonitorProcessPollingMstPK, MonitorProcessPollingMstData> monitorProcessPollingMstCache =
		new ConcurrentHashMap<MonitorProcessPollingMstPK, MonitorProcessPollingMstData>();

	static {
		try {
			Collection<MonitorProcessPollingMstLocal> c =
				MonitorProcessPollingMstUtil.getLocalHome().findAll();
			for (MonitorProcessPollingMstLocal local : c) {
				MonitorProcessPollingMstData data =
					new MonitorProcessPollingMstData(
							local.getCollectMethod(),
							local.getPlatformId(),
							local.getSubPlatformId(),
							local.getVariableId(),
							local.getEntryKey(),
							local.getPollingTarget());
				monitorProcessPollingMstCache.put((MonitorProcessPollingMstPK)local.getPrimaryKey(), data);
			}

		} catch (Exception e) {
			m_log.error("ProcessMasterCache : " + e.getMessage(), e);
		}
	}
	public static MonitorProcessPollingMstData getMonitorProcessPollingMst (MonitorProcessPollingMstPK pk) {
		return monitorProcessPollingMstCache.get(pk);
	}
}
