/*

 Copyright (C) 2012 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.bean;

import java.net.InetAddress;
import java.util.Collections;
import java.util.List;

import org.opennms.protocols.snmp.SnmpSyntax;

public class SnmpTrapV1 {

	public final long receivedTime;
	public final String community;

	public final InetAddress agentAddr;
	public final String enterpriseId;
	public final int genericId;
	public final int specificId;
	public final long sysUptime;

	private final List<SnmpSyntax> varbinds;

	public SnmpTrapV1(long receivedTime, String community, InetAddress agentAddr,
			String enterpriseId, int genericId, int specificId,
			long sysUptime, List<SnmpSyntax> varbinds) {
		this.receivedTime = receivedTime;
		this.community = community;
		this.agentAddr = agentAddr;
		this.enterpriseId = enterpriseId;
		this.genericId = genericId;
		this.specificId = specificId;
		this.sysUptime = sysUptime;
		this.varbinds = varbinds;
	}

	public List<SnmpSyntax> getVarBinds() {
		return Collections.unmodifiableList(varbinds);
	}

	@Override
	public String toString() {
		return this.getClass().getSimpleName() + " [receivedTime = " + receivedTime
		+ ", community = " + community
		+ ", agentAddr = " + agentAddr
		+ ", enterpriseId = " + enterpriseId
		+ ", genericId = " + genericId
		+ ", specificId = " + specificId
		+ ", sysUptime = " + sysUptime + "]";
	}

}
