/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.snmptrap.ejb.entity.MonitorTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.MonitorTrapInfoUtil;

/**
 * SNMPTRAP監視情報を削除するクラス<BR>
 *
 * @version 4.0.0
 * @since 4.0.0
 */
public class DeleteMonitorTrap extends DeleteMonitor {

	protected static Log m_log = LogFactory.getLog( DeleteMonitorTrap.class );

	@Override
	protected boolean deleteCheckInfo() throws FinderException, RemoveException,
	NamingException, HinemosUnknown, NotifyNotFound {

		m_log.debug("deleteCheckInfo() : start");

		MonitorTrapInfoLocal trapLocal = MonitorTrapInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		trapLocal.remove();

		m_log.debug("deleteCheckInfo() : end");
		return true;
	}
}
