/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.sql.util;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.sql.bean.SqlCheckInfo;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoLocal;
import com.clustercontrol.sql.ejb.entity.MonitorSqlInfoUtil;

/**
 * SQL監視 判定情報管理クラス
 *
 * @version 4.0.0
 * @since 2.1.0
 */
public class ControlSqlInfo {

	/** 監視対象ID */
	private String m_monitorTypeId;

	/** 監視ID */
	private String m_monitorId;

	/**
	 * コンストラクタ
	 * 
	 * @param monitorId 監視項目ID
	 * @param monitorTypeId 監視対象ID
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public ControlSqlInfo(String monitorId, String monitorTypeId) {
		m_monitorId = monitorId;
		m_monitorTypeId = monitorTypeId;
	}

	/**
	 * SQL監視情報を取得
	 * 
	 * @return SQL監視情報
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public SqlCheckInfo get() throws FinderException, NamingException{

		// SQL監視情報を取得
		MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		SqlCheckInfo sql = new SqlCheckInfo();
		sql.setMonitorTypeId(m_monitorTypeId);
		sql.setMonitorId(m_monitorId);
		sql.setConnectionUrl(sqlLocal.getConnection_url());
		sql.setUser(sqlLocal.getConnection_user());
		sql.setPassword(sqlLocal.getConnection_password());
		sql.setQuery(sqlLocal.getQuery());
		sql.setJdbcDriver(sqlLocal.getJdbc_driver());

		return sql;
	}

	/**
	 * SQL監視情報を追加
	 * 
	 * @param sql SQL監視情報
	 * @return 成功した場合、true
	 * @throws CreateException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean add(SqlCheckInfo sql) throws CreateException, NamingException {

		// SQL監視情報を追加
		MonitorSqlInfoUtil.getLocalHome().create(
				m_monitorId,
				sql.getConnectionUrl(),
				sql.getUser(),
				sql.getPassword(),
				sql.getQuery(),
				sql.getJdbcDriver());

		return true;
	}

	/**
	 * SQL監視情報を変更
	 * 
	 * @param sql SQL監視情報
	 * @return 成功した場合、true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean modify(SqlCheckInfo sql) throws CreateException, FinderException, NamingException {

		// SQL監視情報を取得
		MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// SQL監視情報を設定
		sqlLocal.setConnection_url(sql.getConnectionUrl());
		sqlLocal.setConnection_user(sql.getUser());
		sqlLocal.setConnection_password(sql.getPassword());
		sqlLocal.setQuery(sql.getQuery());
		sqlLocal.setJdbc_driver(sql.getJdbcDriver());

		return true;
	}

	/**
	 * SQL監視情報を削除
	 * 
	 * @return 成功した場合、true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean delete() throws FinderException, RemoveException, NamingException {

		// SQL監視情報を取得
		MonitorSqlInfoLocal sqlLocal = MonitorSqlInfoUtil.getLocalHome().findByPrimaryKey(m_monitorId);

		// SQL監視情報を削除
		sqlLocal.remove();

		return true;
	}
}
