/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.clustercontrol.cloud.ejb.entity.BillingAlarmData;
import com.clustercontrol.cloud.validation.annotation.DoubleRange;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.NotNullContainer;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;
import com.clustercontrol.cloud.validation.annotation.Size;
import com.clustercontrol.cloud.validation.annotation.ValidateNotifyRelationInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public class BillingAlarm
implements Serializable {
    private static final long serialVersionUID = 2534914899189990001L;
    private BillingAlarmData tableData;
    private List<NotifyRelationInfo> nris = new ArrayList<NotifyRelationInfo>();

    public BillingAlarm() {
        this.tableData = new BillingAlarmData();
    }

    public BillingAlarm(BillingAlarmData tableData) {
        this.tableData = new BillingAlarmData(tableData);
    }

    public BillingAlarm(BillingAlarmData tableData, List<NotifyRelationInfo> nris) {
        assert (nris != null);
        this.tableData = new BillingAlarmData(tableData);
        this.nris = nris;
    }

    @Identity
    public String getAlarmId() {
        return this.tableData.getAlarmId();
    }

    public void setAlarmId(String alarmId) {
        this.tableData.setAlarmId(alarmId);
    }

    @Size(max=128)
    @NotNull(groups={"creation"})
    public String getAlarmName() {
        return this.tableData.getAlarmName();
    }

    public void setAlarmName(String alarmName) {
        this.tableData.setAlarmName(alarmName);
    }

    @ReadOnly
    public String getCloudId() {
        return this.tableData.getCloudId();
    }

    public void setCloudId(String cloudId) {
        this.tableData.setCloudId(cloudId);
    }

    @ReadOnly
    public String getCloudUserId() {
        return this.tableData.getCloudUserId();
    }

    public void setCloudUserId(String cloudUserId) {
        this.tableData.setCloudUserId(cloudUserId);
    }

    @Size(max=256)
    @NotNull(groups={"creation"})
    public String getDescription() {
        return this.tableData.getDescription();
    }

    public void setDescription(String description) {
        this.tableData.setDescription(description);
    }

    @NotNull(groups={"creation"})
    public String getTarget() {
        return this.tableData.getTarget();
    }

    public void setTarget(String target) {
        this.tableData.setTarget(target);
    }

    @DoubleRange(min=0.0)
    @NotNull(groups={"creation"})
    public Double getThresholdInfoLimit() {
        return this.tableData.getThresholdInfoLimit();
    }

    public void setThresholdInfoLimit(Double thresholdInfoLimit) {
        this.tableData.setThresholdInfoLimit(thresholdInfoLimit);
    }

    @DoubleRange(min=0.0)
    @NotNull(groups={"creation"})
    public Double getThresholdWarnLimit() {
        return this.tableData.getThresholdWarnLimit();
    }

    public void setThresholdWarnLimit(Double thresholdWarnLimit) {
        this.tableData.setThresholdWarnLimit(thresholdWarnLimit);
    }

    @Identity(max=1024, groups={"creation"})
    public String getNotifyGroupId() {
        return this.tableData.getNotifyGroupId();
    }

    public void setNotifyGroupId(String notifyGroupId) {
        this.tableData.setNotifyGroupId(notifyGroupId);
    }

    @ReadOnly
    public String getRegUser() {
        return this.tableData.getRegUser();
    }

    public void setRegUser(String regUser) {
        this.tableData.setRegUser(regUser);
    }

    @ReadOnly
    public String getUpdateUser() {
        return this.tableData.getUpdateUser();
    }

    public void setUpdateUser(String updateUser) {
        this.tableData.setUpdateUser(updateUser);
    }

    @NotNull(groups={"creation"})
    public Boolean getValidFlg() {
        if (Short.valueOf((short)1).equals(this.tableData.getValidFlg())) {
            return Boolean.TRUE;
        }
        if (Short.valueOf((short)0).equals(this.tableData.getValidFlg())) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void setValidFlg(Boolean validFlg) {
        if (Boolean.TRUE.equals(validFlg)) {
            this.tableData.setValidFlg((short)1);
        } else if (Boolean.FALSE.equals(validFlg)) {
            this.tableData.setValidFlg((short)0);
        } else {
            this.tableData.setValidFlg(null);
        }
    }

    public String getApplication() {
        return this.tableData.getApplication();
    }

    public void setApplication(String application) {
        this.tableData.setApplication(application);
    }

    @ValidateNotifyRelationInfo
    @NotNullContainer
    public List<NotifyRelationInfo> getNotifyRelationInfos() {
        return this.nris;
    }

    public void setNotifyRelationInfos(List<NotifyRelationInfo> nris) {
        this.nris = nris;
    }

    @ReadOnly
    public Long getRegDate() {
        return this.tableData.getRegDate() != null ? Long.valueOf(this.tableData.getRegDate().getTime()) : null;
    }

    public void setRegDate(Long regDate) {
        if (regDate == null) {
            this.tableData.setRegDate(null);
        } else {
            this.tableData.setRegDate(new Date(regDate));
        }
    }

    @ReadOnly
    public Long getUpdateDate() {
        return this.tableData.getUpdateDate() != null ? Long.valueOf(this.tableData.getUpdateDate().getTime()) : null;
    }

    public void setUpdateDate(Long updateDate) {
        if (updateDate == null) {
            this.tableData.setUpdateDate(null);
        } else {
            this.tableData.setUpdateDate(new Date(updateDate));
        }
    }

    @XmlTransient
    public BillingAlarmData getTableData() {
        return this.tableData;
    }
}

