/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.VolumeAttachment;
import com.clustercontrol.cloud.bean.StorageAttachment;
import com.clustercontrol.cloud.bean.StorageRegistStateType;
import com.clustercontrol.cloud.bean.Tag;
import com.clustercontrol.cloud.ejb.entity.CloudStorageData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;

public class CloudStorage
implements Serializable {
    private static final long serialVersionUID = 5047727801682788230L;
    private CloudStorageData tableData;
    private String state;
    private Long createTime;
    private String attachedInstance;
    private String facilityName;
    private Integer size;
    private Integer iops;
    private String snapshotId;
    private String storageKind;
    private List<Tag> tags = new ArrayList<Tag>();
    private StorageAttachment storageAttachment;

    public CloudStorage() {
        this.tableData = new CloudStorageData();
        this.tableData.setRegistStatus((short)-1);
    }

    public CloudStorage(CloudStorageData tableData, String facilityName) {
        this.tableData = new CloudStorageData(tableData);
        this.facilityName = facilityName;
    }

    public CloudStorage(CloudStorageData tableData, Volume volume, String facilityName) {
        this(tableData, facilityName);
        this.createTime = volume.getCreateTime().getTime();
        Iterator i$ = volume.getAttachments().iterator();
        if (i$.hasNext()) {
            VolumeAttachment awsVa = (VolumeAttachment)i$.next();
            StorageAttachment va = new StorageAttachment();
            va.setInstanceId(awsVa.getInstanceId());
            va.setDevice(awsVa.getDevice());
            va.setState(awsVa.getState());
            va.setAttachTime(awsVa.getAttachTime().getTime());
            va.setDeleteOnTerminate(awsVa.getDeleteOnTermination());
            this.setStorageAttachment(va);
        }
        this.storageKind = volume.getVolumeType();
        this.facilityName = facilityName;
        this.state = volume.getState();
        this.size = volume.getSize();
        this.iops = volume.getIops();
        this.snapshotId = volume.getSnapshotId();
        for (com.amazonaws.services.ec2.model.Tag t : volume.getTags()) {
            Tag tag = new Tag(t.getKey(), t.getValue());
            this.tags.add(tag);
        }
    }

    public String getStorageId() {
        return this.tableData.getStorageId();
    }

    public void setStorageId(String storageId) {
        this.tableData.setStorageId(storageId);
    }

    public String getState() {
        return this.state;
    }

    public void setState(String status) {
        this.state = status;
    }

    public String getStorageName() {
        return this.tableData.getStorageName();
    }

    public void setStorageName(String storageName) {
        this.tableData.setStorageName(storageName);
    }

    public String getStorageType() {
        return this.tableData.getStorageType();
    }

    public void setStorageType(String storageType) {
        this.tableData.setStorageType(storageType);
    }

    public String getCloudId() {
        return this.tableData.getCloudId();
    }

    public void setCloudId(String cloudId) {
        this.tableData.setCloudId(cloudId);
    }

    public String getCloudUserId() {
        return this.tableData.getCloudUserId();
    }

    public void setCloudUserId(String cloudUserId) {
        this.tableData.setCloudUserId(cloudUserId);
    }

    public String getFacilityId() {
        return this.tableData.getFacilityId();
    }

    public void setFacilityId(String facilityId) {
        this.tableData.setFacilityId(facilityId);
    }

    public Integer getDeviceIndex() {
        return this.tableData.getDeviceIndex();
    }

    public void setDeviceIndex(Integer deviceIndex) {
        this.tableData.setDeviceIndex(deviceIndex);
    }

    public String getDeviceType() {
        return this.tableData.getDeviceType();
    }

    public void setDeviceType(String deviceType) {
        this.tableData.setDeviceType(deviceType);
    }

    public String getDeviceName() {
        return this.tableData.getDeviceName();
    }

    public void setDeviceName(String deviceName) {
        this.tableData.setDeviceName(deviceName);
    }

    public String getRegion() {
        return this.tableData.getRegion();
    }

    public void setRegion(String region) {
        this.tableData.setRegion(region);
    }

    public String getAvailabilityZone() {
        return this.tableData.getAvailabilityZone();
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.tableData.setAvailabilityZone(availabilityZone);
    }

    public StorageRegistStateType getRegistState() {
        return StorageRegistStateType.byNumber(this.tableData.getRegistStatus());
    }

    public void setRegistState(StorageRegistStateType registState) {
        this.tableData.setRegistStatus(registState.number());
    }

    public Long getRegDate() {
        return this.tableData.getRegDate() != null ? Long.valueOf(this.tableData.getRegDate().getTime()) : null;
    }

    public void setRegDate(Long regDate) {
        if (regDate == null) {
            this.tableData.setRegDate(null);
        } else {
            this.tableData.setRegDate(new Date(regDate));
        }
    }

    public Long getUpdateDate() {
        return this.tableData.getUpdateDate() != null ? Long.valueOf(this.tableData.getUpdateDate().getTime()) : null;
    }

    public void setUpdateDate(Long updateDate) {
        if (updateDate == null) {
            this.tableData.setUpdateDate(null);
        } else {
            this.tableData.setUpdateDate(new Date(updateDate));
        }
    }

    public String getRegUser() {
        return this.tableData.getRegUser();
    }

    public void setRegUser(String regUser) {
        this.tableData.setRegUser(regUser);
    }

    public String getUpdateUser() {
        return this.tableData.getUpdateUser();
    }

    public void setUpdateUser(String updateUser) {
        this.tableData.setUpdateUser(updateUser);
    }

    public String toString() {
        return this.tableData.toString();
    }

    @XmlTransient
    public CloudStorageData getTableData() {
        return this.tableData;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getAttachedInstance() {
        return this.attachedInstance;
    }

    public void setAttachedInstance(String attachedInstance) {
        this.attachedInstance = attachedInstance;
    }

    public String getStorageKind() {
        return this.storageKind;
    }

    public void setStorageKind(String storageKind) {
        this.storageKind = storageKind;
    }

    public String getFacilityName() {
        return this.facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public StorageAttachment getStorageAttachment() {
        return this.storageAttachment;
    }

    public void setStorageAttachment(StorageAttachment storageAttachment) {
        this.storageAttachment = storageAttachment;
    }
}

