/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.bean;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.identitymanagement.model.User;
import com.clustercontrol.cloud.bean.CloudUserType;
import com.clustercontrol.cloud.ejb.entity.CloudUserData;
import com.clustercontrol.cloud.ejb.entity.CloudUserLocal;
import com.clustercontrol.cloud.ejb.entity.CloudUserLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudUserPK;
import com.clustercontrol.cloud.ejb.entity.CloudUserUtil;
import com.clustercontrol.cloud.util.aws.AWSUtil;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationMessages;
import com.clustercontrol.cloud.validation.annotation.CustomEntityValidation;
import com.clustercontrol.cloud.validation.annotation.Identity;
import com.clustercontrol.cloud.validation.annotation.IdentityNullAllow;
import com.clustercontrol.cloud.validation.annotation.NotNull;
import com.clustercontrol.cloud.validation.annotation.ReadOnly;
import com.clustercontrol.cloud.validation.annotation.Size;
import java.io.Serializable;
import java.util.Date;
import javax.xml.bind.annotation.XmlTransient;

@CustomEntityValidation(value=CloudUserValidator.class)
public class CloudUser
implements Serializable {
    private static final long serialVersionUID = -9161813048730684001L;
    private CloudUserData tableData;

    public CloudUser() {
        this.tableData = new CloudUserData();
        this.tableData.setCloudUserType((short)-1);
    }

    public CloudUser(CloudUserData tableData) {
        this.tableData = new CloudUserData(tableData);
    }

    @Identity
    public String getCloudUserId() {
        return this.tableData.getCloudUserId();
    }

    public void setCloudUserId(String cloudUserId) {
        this.tableData.setCloudUserId(cloudUserId);
    }

    @Size(max=128)
    @NotNull(groups={"createion"})
    public String getCloudUserName() {
        return this.tableData.getCloudUserName();
    }

    public void setCloudUserName(String cloudUserName) {
        this.tableData.setCloudUserName(cloudUserName);
    }

    @NotNull(groups={"createion"})
    public String getSecretKey() {
        return this.tableData.getSecretKey();
    }

    public void setSecretKey(String secretKey) {
        this.tableData.setSecretKey(secretKey);
    }

    @NotNull(groups={"createion"})
    public String getAccessKey() {
        return this.tableData.getAccessKey();
    }

    public void setAccessKey(String accessKey) {
        this.tableData.setAccessKey(accessKey);
    }

    public String getCloudId() {
        return this.tableData.getCloudId();
    }

    public void setCloudId(String cloudId) {
        this.tableData.setCloudId(cloudId);
    }

    @Size(max=256)
    @NotNull
    public String getDescription() {
        return this.tableData.getDescription();
    }

    public void setDescription(String description) {
        this.tableData.setDescription(description);
    }

    @NotNull(groups={"createion"})
    public CloudUserType getCloudUserType() {
        return CloudUserType.byNumber(this.tableData.getCloudUserType());
    }

    public void setCloudUserType(CloudUserType cloudUserType) {
        if (cloudUserType != null) {
            this.tableData.setCloudUserType(cloudUserType.number());
        } else {
            this.tableData.setCloudUserType((short)-1);
        }
    }

    @IdentityNullAllow(groups={"createion"})
    public String getParentCloudUserId() {
        return this.tableData.getParentCloudUserId();
    }

    public void setParentCloudUserId(String parentCloudUserId) {
        this.tableData.setParentCloudUserId(parentCloudUserId);
    }

    @Identity(groups={"createion"})
    public String getUserId() {
        return this.tableData.getUserId();
    }

    public void setUserId(String userId) {
        this.tableData.setUserId(userId);
    }

    public String getCloudResourceId() {
        return this.tableData.getCloudResourceId();
    }

    public void setCloudResourceId(String cloudResourceId) {
        this.tableData.setCloudResourceId(cloudResourceId);
    }

    @ReadOnly
    public Long getRegDate() {
        return this.tableData.getRegDate() != null ? Long.valueOf(this.tableData.getRegDate().getTime()) : null;
    }

    public void setRegDate(Long regDate) {
        if (regDate == null) {
            this.tableData.setRegDate(null);
        } else {
            this.tableData.setRegDate(new Date(regDate));
        }
    }

    @ReadOnly
    public Long getUpdateDate() {
        return this.tableData.getUpdateDate() != null ? Long.valueOf(this.tableData.getUpdateDate().getTime()) : null;
    }

    public void setUpdateDate(Long updateDate) {
        if (updateDate == null) {
            this.tableData.setUpdateDate(null);
        } else {
            this.tableData.setUpdateDate(new Date(updateDate));
        }
    }

    @ReadOnly
    public String getRegUser() {
        return this.tableData.getRegUser();
    }

    public void setRegUser(String regUser) {
        this.tableData.setRegUser(regUser);
    }

    @ReadOnly
    public String getUpdateUser() {
        return this.tableData.getUpdateUser();
    }

    public void setUpdateUser(String updateUser) {
        this.tableData.setUpdateUser(updateUser);
    }

    @XmlTransient
    public CloudUserData getTableData() {
        return this.tableData;
    }

    public static class CloudUserValidator
    implements CustomEntityValidator<CloudUser> {
        @Override
        public void validate(CloudUser entity, String group, EntityValidator.EntityContext context) throws ValidationFault {
            if ("creation".equals(group)) {
                EntityValidator.PropValidatorInfo prop = context.getPropValidator("parentCloudUserId");
                BasicAWSCredentials credentials = new BasicAWSCredentials(entity.getAccessKey(), entity.getSecretKey());
                AmazonIdentityManagementClient aim = new AmazonIdentityManagementClient((AWSCredentials)credentials);
                GetUserResult result = aim.getUser();
                User user = result.getUser();
                AWSUtil.AMIArn arn = new AWSUtil.AMIArn(user.getArn());
                CloudUserType userType = entity.getCloudUserType();
                switch (userType) {
                    case parent: {
                        if (!arn.isRoot()) {
                            ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message5"));
                            v.setElementId(prop.elementId());
                            v.setValidationId(this.getClass().getName());
                            throw v;
                        }
                        if (entity.getParentCloudUserId() == null) break;
                        ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message1"));
                        v.setElementId(prop.elementId());
                        v.setValidationId(this.getClass().getName());
                        throw v;
                    }
                    case child: {
                        CloudUserLocal parent = null;
                        try {
                            CloudUserLocalHome home = CloudUserUtil.getLocalHome();
                            parent = home.findByPrimaryKey(new CloudUserPK(entity.getParentCloudUserId()));
                            if (parent.getParentCloudUserId() != null) {
                                ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message2", entity.getCloudUserId(), entity.getParentCloudUserId()));
                                v.setElementId(prop.elementId());
                                v.setValidationId(this.getClass().getName());
                                throw v;
                            }
                        }
                        catch (ValidationFault e) {
                            throw e;
                        }
                        catch (Exception e) {
                            ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message3", entity.getCloudUserId(), entity.getParentCloudUserId()), e);
                            v.setElementId(prop.elementId());
                            v.setValidationId(this.getClass().getName());
                            throw v;
                        }
                        AWSUtil.AMIArn parentArn = new AWSUtil.AMIArn(parent.getCloudResourceId());
                        if (!arn.isRoot() && parentArn.accountId.equals(arn.accountId)) break;
                        ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message6"));
                        v.setElementId(prop.elementId());
                        v.setValidationId(this.getClass().getName());
                        throw v;
                    }
                }
            } else if ("modification".equals(group)) {
                BasicAWSCredentials credentials = new BasicAWSCredentials(entity.getAccessKey(), entity.getSecretKey());
                AmazonIdentityManagementClient aim = new AmazonIdentityManagementClient((AWSCredentials)credentials);
                GetUserResult result = aim.getUser();
                User user = result.getUser();
                CloudUserLocalHome home = null;
                CloudUserLocal self = null;
                try {
                    home = CloudUserUtil.getLocalHome();
                    self = home.findByPrimaryKey(new CloudUserPK(entity.getCloudUserId()));
                }
                catch (Exception e) {
                    ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message3", new Object[]{entity.getCloudUserId()}), e);
                    EntityValidator.PropValidatorInfo prop = context.getPropValidator("cloudUserId");
                    v.setElementId(prop.elementId());
                    v.setValidationId(this.getClass().getName());
                    throw v;
                }
                if (self.getParentCloudUserId() == null) {
                    if (!self.getCloudResourceId().equals(user.getArn())) {
                        EntityValidator.PropValidatorInfo prop = context.getPropValidator("accessKey");
                        ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message7", entity.getCloudUserId(), entity.getParentCloudUserId()));
                        v.setElementId(prop.elementId());
                        v.setValidationId(this.getClass().getName());
                        throw v;
                    }
                } else {
                    AWSUtil.AMIArn arn = new AWSUtil.AMIArn(user.getArn());
                    CloudUserLocal parent = null;
                    try {
                        parent = home.findByPrimaryKey(new CloudUserPK(entity.getParentCloudUserId()));
                    }
                    catch (Exception e) {
                        ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message3", entity.getCloudUserId(), entity.getParentCloudUserId()), e);
                        EntityValidator.PropValidatorInfo prop = context.getPropValidator("parentCloudUserId");
                        v.setElementId(prop.elementId());
                        v.setValidationId(this.getClass().getName());
                        throw v;
                    }
                    AWSUtil.AMIArn parentArn = new AWSUtil.AMIArn(parent.getCloudResourceId());
                    if (arn.isRoot() || !parentArn.accountId.equals(arn.accountId)) {
                        ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message6"));
                        EntityValidator.PropValidatorInfo prop = context.getPropValidator("parentCloudUserId");
                        v.setElementId(prop.elementId());
                        v.setValidationId(this.getClass().getName());
                        throw v;
                    }
                }
            }
        }
    }
}

