/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.CreateSnapshotRequest;
import com.amazonaws.services.ec2.model.CreateSnapshotResult;
import com.amazonaws.services.ec2.model.DeleteSnapshotRequest;
import com.amazonaws.services.ec2.model.DeregisterImageRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.GetPasswordDataRequest;
import com.amazonaws.services.ec2.model.GetPasswordDataResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceAttributeName;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.TagDescription;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.amazonaws.services.identitymanagement.model.User;
import com.clustercontrol.cloud.bean.AvailabilityZone;
import com.clustercontrol.cloud.bean.BillingAlarm;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.CloudType;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CreateInstanceBackupRequest;
import com.clustercontrol.cloud.bean.CreateStorageBackupRequest;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.bean.IpPermission;
import com.clustercontrol.cloud.bean.KeyPair;
import com.clustercontrol.cloud.bean.RestoreStatus;
import com.clustercontrol.cloud.bean.Snapshot;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmLocal;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmLocalHome;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmPK;
import com.clustercontrol.cloud.ejb.entity.BillingAlarmUtil;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupData;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupLocal;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupPK;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupUtil;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceLocal;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceUtil;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupData;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupLocal;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupPK;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupUtil;
import com.clustercontrol.cloud.ejb.entity.CloudTypeLocal;
import com.clustercontrol.cloud.ejb.entity.CloudTypeLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudTypeUtil;
import com.clustercontrol.cloud.ejb.entity.CloudUserBean;
import com.clustercontrol.cloud.ejb.entity.CloudUserData;
import com.clustercontrol.cloud.ejb.entity.CloudUserLocal;
import com.clustercontrol.cloud.ejb.entity.CloudUserLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudUserPK;
import com.clustercontrol.cloud.ejb.entity.CloudUserUtil;
import com.clustercontrol.cloud.factory.DescribeAvailabilityZonesRequest;
import com.clustercontrol.cloud.factory.DescribeImagesRequest;
import com.clustercontrol.cloud.factory.DescribeInstaceTypesRequest;
import com.clustercontrol.cloud.factory.DescribeKeyPairsRequest;
import com.clustercontrol.cloud.factory.DescribeServiceNamesRequest;
import com.clustercontrol.cloud.factory.DescribeSnapshotsRequest;
import com.clustercontrol.cloud.factory.DescribeVolumeTypesRequest;
import com.clustercontrol.cloud.persistence.PersistenceManager;
import com.clustercontrol.cloud.persistence.PersistenceUtil;
import com.clustercontrol.cloud.util.aws.AWSErrorCode;
import com.clustercontrol.cloud.util.aws.AWSUtil;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import com.clustercontrol.cloud.util.aws.InstanceBackupUtil;
import com.clustercontrol.cloud.util.aws.SecurityGroupUtil;
import com.clustercontrol.cloud.util.aws.StorageBackupUtil;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationMessages;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.NotifyNotFound;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.session.NotifyControllerLocal;
import com.clustercontrol.notify.ejb.session.NotifyControllerUtil;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.logging.Logger;

public class CloudCommandFacade {
    private static Log m_log = LogFactory.getLog(CloudCommandFacade.class);
    private SessionContext context;

    public CloudUser getCurrentCloudUserInfo() throws CloudManagerFault {
        try {
            CloudUser[] users = this.findCloudUsers(new Filter[]{new Filter("userId", this.context.getCallerPrincipal().getName())});
            if (users.length == 0) {
                ValidationFault v = new ValidationFault(ValidationMessages.getString("validation.cloud_user.message4", new Object[]{this.context.getCallerPrincipal().getName()}));
                v.setElementId("cloudUser.userId");
                v.setValidationId(this.getClass().getName() + ".getCurrentCloudUserInfo");
                throw v;
            }
            return users[0];
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public void setSessionContext(SessionContext context) {
        this.context = context;
    }

    public BillingAlarm findBillingAlarm(String alarmId) throws NamingException, FinderException, CreateException, NotifyNotFound, HinemosUnknown, ValidationFault, CloudManagerFault {
        m_log.debug((Object)"findBillingAlarm");
        BillingAlarmLocalHome home = BillingAlarmUtil.getLocalHome();
        BillingAlarmLocal bal = home.findByPrimaryKey(new BillingAlarmPK(alarmId));
        CloudUser currentCu = this.getCurrentCloudUserInfo();
        if (currentCu.getParentCloudUserId() == null) {
            boolean match = false;
            CloudUser[] children = this.findCloudUsers(new Filter[]{new Filter("parentCloudUserId", currentCu.getCloudUserId())});
            ArrayList<CloudUser> targets = new ArrayList<CloudUser>(Arrays.asList(children));
            targets.add(currentCu);
            for (CloudUser cu : targets) {
                if (!bal.getCloudUserId().equals(cu.getCloudUserId())) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new FinderException("Not found " + bal.getAlarmId());
            }
        } else if (currentCu != null && !bal.getCloudUserId().equals(currentCu.getCloudUserId())) {
            throw new FinderException("Not found " + bal.getAlarmId());
        }
        NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
        nc.getNotifyRelation(bal.getNotifyGroupId());
        ArrayList tempNris = nc.getNotifyRelation(bal.getNotifyGroupId());
        ArrayList<NotifyRelationInfo> nris = new ArrayList<NotifyRelationInfo>();
        for (Object nri : tempNris) {
            nris.add((NotifyRelationInfo)nri);
        }
        return new BillingAlarm(bal.getDetail(), nris);
    }

    public void removeBillingAlarm(String alarmId) throws CloudManagerFault, NamingException, FinderException, CreateException, NotifyNotFound, HinemosUnknown, EJBException, RemoveException {
        m_log.debug((Object)"removeBillingAlarm");
        BillingAlarmLocalHome home = BillingAlarmUtil.getLocalHome();
        BillingAlarmPK pk = new BillingAlarmPK(alarmId);
        BillingAlarmLocal bal = home.findByPrimaryKey(pk);
        CloudUser currentCu = this.getCurrentCloudUserInfo();
        if (currentCu.getParentCloudUserId() == null) {
            boolean match = false;
            CloudUser[] children = this.findCloudUsers(new Filter[]{new Filter("parentCloudUserId", currentCu.getCloudUserId())});
            ArrayList<CloudUser> targets = new ArrayList<CloudUser>(Arrays.asList(children));
            targets.add(currentCu);
            for (CloudUser cu : targets) {
                if (!bal.getCloudUserId().equals(cu.getCloudUserId())) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new FinderException("Not found " + bal.getAlarmId());
            }
        } else if (currentCu != null && !bal.getCloudUserId().equals(currentCu.getCloudUserId())) {
            throw new FinderException("Not found " + bal.getAlarmId());
        }
        NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
        nc.deleteNotifyRelation(bal.getNotifyGroupId());
        home.remove(pk);
    }

    public BillingAlarm[] findAllBillingAlarm() throws NamingException, FinderException, HinemosUnknown, NotifyNotFound, CreateException, CloudManagerFault {
        m_log.debug((Object)"findAllBillingAlarm");
        CloudUser currentCu = this.getCurrentCloudUserInfo();
        List<CloudUser> targets = Collections.emptyList();
        if (currentCu.getParentCloudUserId() == null) {
            CloudUser[] children = this.findCloudUsers(new Filter[]{new Filter("parentCloudUserId", currentCu.getCloudUserId())});
            targets = new ArrayList<CloudUser>(Arrays.asList(children));
            targets.add(currentCu);
        }
        BillingAlarmLocalHome home = BillingAlarmUtil.getLocalHome();
        Collection col = home.findAll();
        NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
        ArrayList<BillingAlarm> bas = new ArrayList<BillingAlarm>();
        block0: for (Object obj : col) {
            BillingAlarmLocal bal = (BillingAlarmLocal)obj;
            if (targets.isEmpty()) {
                if (!bal.getCloudUserId().equals(currentCu.getCloudUserId())) continue;
                ArrayList tempNris = nc.getNotifyRelation(bal.getNotifyGroupId());
                ArrayList<NotifyRelationInfo> nris = new ArrayList<NotifyRelationInfo>();
                for (Object nri : tempNris) {
                    nris.add((NotifyRelationInfo)nri);
                }
                bas.add(new BillingAlarm(bal.getDetail(), nris));
                continue;
            }
            for (CloudUser cu : targets) {
                if (!bal.getCloudUserId().equals(cu.getCloudUserId())) continue;
                ArrayList tempNris = nc.getNotifyRelation(bal.getNotifyGroupId());
                ArrayList<NotifyRelationInfo> nris = new ArrayList<NotifyRelationInfo>();
                for (Object nri : tempNris) {
                    nris.add((NotifyRelationInfo)nri);
                }
                bas.add(new BillingAlarm(bal.getDetail(), nris));
                continue block0;
            }
        }
        return bas.toArray(new BillingAlarm[0]);
    }

    public void modifyBillingAlarm(BillingAlarm billingAlarm) throws NamingException, FinderException, CreateException, HinemosUnknown, NotifyNotFound, CloudManagerFault {
        m_log.debug((Object)"modifyBillingAlarm");
        BillingAlarmLocalHome home = BillingAlarmUtil.getLocalHome();
        BillingAlarmLocal bal = home.findByPrimaryKey(billingAlarm.getTableData().getPrimaryKey());
        CloudUser currentCu = this.getCurrentCloudUserInfo();
        if (currentCu.getParentCloudUserId() == null) {
            boolean match = false;
            CloudUser[] children = this.findCloudUsers(new Filter[]{new Filter("parentCloudUserId", currentCu.getCloudUserId())});
            ArrayList<CloudUser> targets = new ArrayList<CloudUser>(Arrays.asList(children));
            targets.add(currentCu);
            for (CloudUser cu : targets) {
                if (!bal.getCloudUserId().equals(cu.getCloudUserId())) continue;
                match = true;
                break;
            }
            if (!match) {
                throw new FinderException("Not found " + billingAlarm.getAlarmId());
            }
        } else if (currentCu != null && !bal.getCloudUserId().equals(currentCu.getCloudUserId())) {
            throw new FinderException("Not found " + billingAlarm.getAlarmId());
        }
        if (billingAlarm.getAlarmName() != null) {
            bal.setAlarmName(billingAlarm.getAlarmName());
        }
        if (billingAlarm.getDescription() != null) {
            bal.setDescription(billingAlarm.getDescription());
        }
        if (billingAlarm.getTarget() != null) {
            bal.setTarget(billingAlarm.getTarget());
        }
        if (billingAlarm.getThresholdInfoLimit() != null) {
            bal.setThresholdInfoLimit(billingAlarm.getThresholdInfoLimit());
        }
        if (billingAlarm.getThresholdWarnLimit() != null) {
            bal.setThresholdWarnLimit(billingAlarm.getThresholdWarnLimit());
        }
        if (billingAlarm.getValidFlg() != null) {
            bal.setValidFlg(billingAlarm.getTableData().getValidFlg());
        }
        if (billingAlarm.getApplication() != null) {
            bal.setApplication(billingAlarm.getApplication());
        }
        if (billingAlarm.getNotifyRelationInfos() != null) {
            NotifyControllerLocal nc = NotifyControllerUtil.getLocalHome().create();
            nc.deleteNotifyRelation(billingAlarm.getNotifyGroupId());
            nc.modifyNotifyRelation(billingAlarm.getNotifyRelationInfos(), billingAlarm.getNotifyGroupId());
        }
    }

    public CloudUser createCloudUser(CloudUser cu) throws CloudManagerFault {
        m_log.debug((Object)"createCloudUser");
        try {
            BasicAWSCredentials credentials = new BasicAWSCredentials(cu.getAccessKey(), cu.getSecretKey());
            AmazonIdentityManagementClient aim = new AmazonIdentityManagementClient((AWSCredentials)credentials);
            GetUserResult result = aim.getUser();
            User user = result.getUser();
            m_log.debug((Object)("Amazon Resource Name is " + user.getArn()));
            CloudUserData cud = new CloudUserData(cu.getTableData());
            cud.setCloudResourceId(user.getArn());
            cud.setCloudId(this.findAllCloudType()[0].getCloudId());
            CloudUserLocalHome home = CloudUserUtil.getLocalHome();
            CloudUserLocal local = home.create(cud);
            CloudUserData newCud = new CloudUserData(local.getDetail());
            return new CloudUser(newCud);
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public CloudUser findCloudUser(String cloudUserId) throws NamingException, FinderException, ValidationFault {
        m_log.debug((Object)"findCloudUser");
        CloudUserLocalHome home = CloudUserUtil.getLocalHome();
        CloudUserLocal cul = home.findByPrimaryKey(new CloudUserPK(cloudUserId));
        return new CloudUser(cul.getDetail());
    }

    public CloudUser[] findCloudUsers(Filter[] filters) throws NamingException, FinderException {
        m_log.debug((Object)"findCloudUsers");
        CloudUserLocalHome home = CloudUserUtil.getLocalHome();
        Collection col = home.findByFilter(filters);
        CloudUser[] cus = new CloudUser[col.size()];
        Iterator iter = col.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            CloudUserLocal cu = (CloudUserLocal)obj;
            cus[i] = new CloudUser(cu.getDetail());
            ++i;
        }
        return cus;
    }

    public void removeCloudUser(String cloudUserId) throws NamingException, RemoveException, FinderException, ValidationFault {
        m_log.debug((Object)"removeCloudUser");
        PersistenceManager.EntityTypeInfo ti = PersistenceUtil.getPersistenceManager().getEntityTypeInfo(CloudUserBean.class);
        if (ti == null) {
            throw new IllegalStateException(CloudUserBean.class.getName());
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            DataSource ds = (DataSource)this.context.lookup("java:DefaultDS");
            conn = ds.getConnection();
            PersistenceManager.BeanPropInfo cloudUserIdColumn = ti.getPropInfo("cloudUserId");
            PersistenceManager.BeanPropInfo parentCloudUserIdColumn = ti.getPropInfo("parentCloudUserId");
            StringBuilder deleteSql = new StringBuilder("DELETE FROM ").append(ti.tableName()).append(" WHERE ").append(cloudUserIdColumn.cloumnName()).append(" = ? or ").append(parentCloudUserIdColumn.cloumnName()).append(" = ?");
            String deleteCommand = deleteSql.toString();
            stmt = conn.prepareStatement(deleteCommand);
            stmt.setString(1, cloudUserId);
            stmt.setString(2, cloudUserId);
            int deleted = stmt.executeUpdate();
            if (deleted == 0) {
                String msg = "cloudUserId : " + cloudUserId + " not found.";
                throw new RemoveException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + cloudUserId + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + cloudUserId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("remove() end : " + cloudUserId));
        }
    }

    public CloudUser[] findAllCloudUser() throws NamingException, FinderException {
        CloudUserLocalHome home = CloudUserUtil.getLocalHome();
        Collection col = home.findAll();
        CloudUser[] cus = new CloudUser[col.size()];
        Iterator iter = col.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object obj = iter.next();
            CloudUserLocal cu = (CloudUserLocal)obj;
            cus[i] = new CloudUser(cu.getDetail());
            ++i;
        }
        return cus;
    }

    public void modifyCloudUser(CloudUser cu) throws NamingException, FinderException, NotifyNotFound, CreateException {
        m_log.debug((Object)"modifyCloudUser");
        CloudUserLocalHome home = CloudUserUtil.getLocalHome();
        CloudUserLocal cul = home.findByPrimaryKey(cu.getTableData().getPrimaryKey());
        if (cu.getCloudUserName() != null) {
            cul.setCloudUserName(cu.getCloudUserName());
        }
        if (cu.getDescription() != null) {
            cul.setDescription(cu.getDescription());
        }
        if (cu.getAccessKey() != null) {
            cul.setAccessKey(cu.getAccessKey());
        }
        if (cu.getSecretKey() != null) {
            cul.setSecretKey(cu.getSecretKey());
        }
    }

    public CloudType[] findAllCloudType() throws CloudManagerFault {
        try {
            CloudTypeLocalHome home = CloudTypeUtil.getLocalHome();
            Collection col = home.findAll();
            CloudType[] cus = new CloudType[col.size()];
            Iterator iter = col.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Object obj = iter.next();
                CloudTypeLocal cu = (CloudTypeLocal)obj;
                cus[i] = new CloudType(cu.getDetail());
                ++i;
            }
            return cus;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public com.clustercontrol.cloud.bean.SecurityGroup addSecurityGroup(String regionName, com.clustercontrol.cloud.bean.SecurityGroup sg) throws CloudManagerFault, NamingException, FinderException, CreateException {
        throw new UnsupportedOperationException();
    }

    public void removeSecurityGroup(String regionName, String securityGroupId) throws CloudManagerFault, NamingException, FinderException {
        throw new UnsupportedOperationException();
    }

    public com.clustercontrol.cloud.bean.SecurityGroup[] getSecurityGroupsByRegion(String regionName) throws CloudManagerFault, NamingException, FinderException {
        m_log.debug((Object)"getSecurityGroupsByRegion");
        CloudUser user = this.getCurrentCloudUserInfo();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), regionName);
        List awsSgs = new ArrayList();
        try {
            DescribeSecurityGroupsResult dsgResult = ec2.describeSecurityGroups();
            awsSgs = dsgResult.getSecurityGroups();
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e);
        }
        ArrayList<com.clustercontrol.cloud.bean.SecurityGroup> groups = new ArrayList<com.clustercontrol.cloud.bean.SecurityGroup>();
        for (SecurityGroup awsSg : awsSgs) {
            com.clustercontrol.cloud.bean.SecurityGroup sg = SecurityGroupUtil.convertToSecrurityGroup(regionName, awsSg);
            groups.add(sg);
        }
        return groups.toArray(new com.clustercontrol.cloud.bean.SecurityGroup[0]);
    }

    public com.clustercontrol.cloud.bean.SecurityGroup[] getSecurityGroups(String regionName, Filter[] filters) throws CloudManagerFault {
        m_log.debug((Object)"getSecurityGroups");
        CloudUser user = this.getCurrentCloudUserInfo();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), regionName);
        List awsSgs = new ArrayList();
        try {
            DescribeSecurityGroupsRequest awsRequest = new DescribeSecurityGroupsRequest();
            for (Filter f : filters) {
                com.amazonaws.services.ec2.model.Filter awsFilter = new com.amazonaws.services.ec2.model.Filter(f.getName(), f.getValues());
                awsRequest.getFilters().add(awsFilter);
            }
            DescribeSecurityGroupsResult dsgResult = ec2.describeSecurityGroups(awsRequest);
            awsSgs = dsgResult.getSecurityGroups();
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e);
        }
        ArrayList<com.clustercontrol.cloud.bean.SecurityGroup> groups = new ArrayList<com.clustercontrol.cloud.bean.SecurityGroup>();
        for (SecurityGroup awsSg : awsSgs) {
            com.clustercontrol.cloud.bean.SecurityGroup sg = SecurityGroupUtil.convertToSecrurityGroup(regionName, awsSg);
            groups.add(sg);
        }
        return groups.toArray(new com.clustercontrol.cloud.bean.SecurityGroup[0]);
    }

    public IpPermission authorizeIpPermission(String regionName, String securityGroupId, IpPermission permission) throws CloudManagerFault, NamingException, FinderException, CreateException {
        throw new UnsupportedOperationException();
    }

    public void revokeIpPermission(String regionName, String securityGroupId, IpPermission permission) throws CloudManagerFault, NamingException, FinderException {
        throw new UnsupportedOperationException();
    }

    public AvailabilityZone[] getAvailabilityZones(String region) throws CloudManagerFault {
        m_log.debug((Object)"getAvailabilityZones");
        CloudUser user = null;
        try {
            user = this.getCurrentCloudUserInfo();
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        DescribeAvailabilityZonesRequest request = new DescribeAvailabilityZonesRequest();
        request.setRegion(region);
        return request.execute(user).getAvailabilityZones().toArray(new AvailabilityZone[0]);
    }

    public Image[] getImages(String region, Filter[] filters) throws CloudManagerFault {
        m_log.debug((Object)"getImageList");
        CloudUser user = null;
        try {
            user = this.getCurrentCloudUserInfo();
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        DescribeImagesRequest request = new DescribeImagesRequest();
        request.setRegion(region);
        request.setFilters(Arrays.asList(filters));
        return request.execute(user).getImages().toArray(new Image[0]);
    }

    public String[] getAllInstanceType() throws CloudManagerFault {
        m_log.debug((Object)"getInstanceTypes");
        CloudUser user = null;
        try {
            user = this.getCurrentCloudUserInfo();
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        DescribeInstaceTypesRequest request = new DescribeInstaceTypesRequest();
        return request.execute(user).getInstanceTypes().toArray(new String[0]);
    }

    public KeyPair[] getKeyNames(String region) throws CloudManagerFault {
        m_log.debug((Object)"getKeyNames");
        CloudUser user = null;
        try {
            user = this.getCurrentCloudUserInfo();
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        DescribeKeyPairsRequest request = new DescribeKeyPairsRequest();
        request.setRegion(region);
        return request.execute(user).getKeyPairs().toArray(new KeyPair[0]);
    }

    public CloudInstanceBackup createInstanceBackup(CreateInstanceBackupRequest backup) throws CloudManagerFault, NamingException, FinderException, NotifyNotFound, CreateException, ValidationFault {
        m_log.debug((Object)"createInstanceBackup");
        CloudInstanceBackupData data = new CloudInstanceBackupData();
        data.setRegion(backup.getRegion());
        data.setInstanceId(backup.getInstanceId());
        data.setDescription(backup.getDescription());
        data.setImageName(backup.getImageName());
        CloudUser user = this.getCurrentCloudUserInfo();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), backup.getRegion());
        try {
            Filter f1 = new Filter("region", backup.getRegion());
            Filter f2 = new Filter("instanceId", backup.getInstanceId());
            CloudInstanceLocal cloudInstanceLocal = (CloudInstanceLocal)CloudInstanceUtil.getLocalHome().findByFilter(new Filter[]{f1, f2}).iterator().next();
            data.setAvailabilityZone(cloudInstanceLocal.getAvailabilityZone());
            DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(new String[]{backup.getInstanceId()});
            DescribeInstancesResult result = ec2.describeInstances(request);
            Instance instance = (Instance)((Reservation)result.getReservations().get(0)).getInstances().get(0);
            data.setKeyName(instance.getKeyName());
            NodeInfo nodeInfo = RepositoryControllerUtil.getLocalHome().create().getNode(cloudInstanceLocal.getFacilityId());
            data.setFacilityId(nodeInfo.getFacilityId());
            data.setFacilityName(nodeInfo.getFacilityName());
            data.setNodeName(nodeInfo.getNodeName());
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        CloudInstanceBackup image = null;
        CreateImageRequest createImageRequest = new CreateImageRequest().withInstanceId(backup.getInstanceId()).withName(backup.getImageName()).withDescription(backup.getDescription()).withNoReboot(backup.getNoReboot());
        if (!backup.getWithEBSVolume().booleanValue()) {
            DescribeInstanceAttributeRequest describeInstanceAttributeRequest = new DescribeInstanceAttributeRequest();
            describeInstanceAttributeRequest.setInstanceId(backup.getInstanceId());
            describeInstanceAttributeRequest.setAttribute(InstanceAttributeName.RootDeviceName);
            DescribeInstanceAttributeResult describeInstanceAttributeResult = ec2.describeInstanceAttribute(describeInstanceAttributeRequest);
            String rootDeviceName = describeInstanceAttributeResult.getInstanceAttribute().getRootDeviceName();
            describeInstanceAttributeRequest.setAttribute(InstanceAttributeName.BlockDeviceMapping);
            describeInstanceAttributeResult = ec2.describeInstanceAttribute(describeInstanceAttributeRequest);
            ArrayList<BlockDeviceMapping> blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
            for (InstanceBlockDeviceMapping instanceBlockDeviceMapping : describeInstanceAttributeResult.getInstanceAttribute().getBlockDeviceMappings()) {
                if (instanceBlockDeviceMapping.getDeviceName().equals(rootDeviceName)) continue;
                BlockDeviceMapping blockDeviceMapping = new BlockDeviceMapping();
                blockDeviceMapping.setDeviceName(instanceBlockDeviceMapping.getDeviceName());
                blockDeviceMapping.setNoDevice("");
                blockDeviceMappings.add(blockDeviceMapping);
            }
            createImageRequest.setBlockDeviceMappings(blockDeviceMappings);
        }
        String imageId = null;
        try {
            CreateImageResult createImageResult = ec2.createImage(createImageRequest);
            imageId = createImageResult.getImageId();
            AWSUtil.addTag(ec2, createImageResult.getImageId(), "SouceInstanceId", backup.getInstanceId());
            com.amazonaws.services.ec2.model.DescribeImagesRequest describeImagesRequest = new com.amazonaws.services.ec2.model.DescribeImagesRequest().withImageIds(new String[]{createImageResult.getImageId()});
            DescribeImagesResult describeImagesResult = ec2.describeImages(describeImagesRequest);
            com.amazonaws.services.ec2.model.Image awsImage = (com.amazonaws.services.ec2.model.Image)describeImagesResult.getImages().get(0);
            data.setImageId(awsImage.getImageId());
            data.setCloudId(this.findAllCloudType()[0].getCloudId());
            data.setCloudUserId(user.getCloudUserName());
            data.setRestoreStatus(RestoreStatus.available.number());
            data.setCloudAccountId(AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()));
            CloudInstanceBackupLocalHome home = CloudInstanceBackupUtil.getLocalHome();
            CloudInstanceBackupLocal local = home.create(data);
            image = new CloudInstanceBackup(local.getDetail());
            image.setImageType(awsImage.getImageType());
            image.setPlatform(awsImage.getPlatform());
        }
        catch (Exception e) {
            if (imageId != null) {
                DeregisterImageRequest deregisterImageRequest = new DeregisterImageRequest().withImageId(imageId);
                ec2.deregisterImage(deregisterImageRequest);
            }
            throw new CloudManagerFault(e);
        }
        return image;
    }

    public CloudInstanceBackup findInstanceBackup(String region, String imageId) throws CloudManagerFault, NamingException, FinderException {
        m_log.debug((Object)"findInstanceBackup");
        CloudUser user = this.getCurrentCloudUserInfo();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), region);
        try {
            List<CloudInstanceBackup> images = InstanceBackupUtil.getInstanceBackup(ec2, new Filter("region", region), new Filter("imageId", imageId), new Filter("cloudAccountId", AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId())));
            return images.get(0);
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)("Not exist backup(" + imageId + ")."));
            throw new CloudManagerFault(e);
        }
    }

    public CloudInstanceBackup[] findInstanceBackupsByRegion(String regionName) throws CloudManagerFault, NamingException, FinderException {
        return this.findInstanceBackupsByRegion(this.getCurrentCloudUserInfo(), regionName);
    }

    public CloudInstanceBackup[] findInstanceBackupsByRegion(CloudUser user, String regionName) throws CloudManagerFault, NamingException, FinderException {
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), regionName);
        try {
            List<CloudInstanceBackup> images = InstanceBackupUtil.getInstanceBackup(ec2, new Filter("region", regionName), new Filter("cloudAccountId", AWSUtil.getAccountIdFromIAM(user.getCloudResourceId())));
            return images.toArray(new CloudInstanceBackup[0]);
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)"Any backup lacked.");
            throw new CloudManagerFault(e);
        }
    }

    public void removeInstanceBackup(String region, String imageId) throws NamingException, RemoveException, FinderException, ValidationFault, CreateException, CloudManagerFault {
        m_log.debug((Object)"removeInstanceBackup");
        CloudInstanceBackupLocal local = null;
        CloudInstanceBackupLocalHome home = CloudInstanceBackupUtil.getLocalHome();
        try {
            local = home.findByPrimaryKey(new CloudInstanceBackupPK(imageId, AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()), region));
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)("Not exist storage(" + imageId + ")."));
        }
        if (local != null) {
            com.amazonaws.services.ec2.model.Image image;
            AmazonEC2 ec2;
            block10: {
                CloudUser user = this.getCurrentCloudUserInfo();
                ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), region);
                image = null;
                try {
                    DescribeImagesResult result = ec2.describeImages(new com.amazonaws.services.ec2.model.DescribeImagesRequest().withImageIds(new String[]{imageId}));
                    if (!result.getImages().isEmpty()) {
                        image = (com.amazonaws.services.ec2.model.Image)result.getImages().get(0);
                        ec2.deregisterImage(new DeregisterImageRequest(imageId));
                    }
                }
                catch (AmazonServiceException e) {
                    if (AWSErrorCode.InvalidAMIID_NotFound.label().equals(e.getErrorCode())) break block10;
                    throw e;
                }
            }
            if (image != null) {
                for (BlockDeviceMapping bdm : image.getBlockDeviceMappings()) {
                    try {
                        ec2.deleteSnapshot(new DeleteSnapshotRequest(bdm.getEbs().getSnapshotId()));
                    }
                    catch (AmazonServiceException e) {
                        if (AWSErrorCode.InvalidSnapshot_NotFound.label().equals(e.getErrorCode())) continue;
                        Logger logger = Logger.getLogger(this.getClass());
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            home.remove(local.getPrimaryKey());
        }
    }

    public CloudInstanceBackup[] findAllInstanceBackup() throws NamingException, FinderException, CloudManagerFault {
        m_log.debug((Object)"findAllInstanceBackup");
        CloudInstanceBackupLocal local = null;
        CloudInstanceBackupLocalHome home = CloudInstanceBackupUtil.getLocalHome();
        ArrayList<CloudInstanceBackup> backups = new ArrayList<CloudInstanceBackup>();
        for (Object o : home.findByFilter(new Filter[]{new Filter("cloudAccountId", AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()))})) {
            local = (CloudInstanceBackupLocal)o;
            backups.add(new CloudInstanceBackup(local.getDetail()));
        }
        return backups.toArray(new CloudInstanceBackup[0]);
    }

    public CloudStorageBackup createStorageBackup(CloudStorageBackup backup) throws CloudManagerFault, NamingException, FinderException, NotifyNotFound, CreateException, ValidationFault {
        com.amazonaws.services.ec2.model.Snapshot awsSnapshot;
        m_log.debug((Object)"createStorageBackup");
        CloudUser user = this.getCurrentCloudUserInfo();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), backup.getRegion());
        CloudStorageBackup snapshots = null;
        CreateSnapshotRequest createSnapshotRequest = new CreateSnapshotRequest().withVolumeId(backup.getStorageId()).withDescription(backup.getDescription());
        CreateSnapshotResult createSnapshotResult = ec2.createSnapshot(createSnapshotRequest);
        AWSUtil.addTag(ec2, createSnapshotResult.getSnapshot().getSnapshotId(), "SouceStorageId", backup.getStorageId());
        String storageName = null;
        com.amazonaws.services.ec2.model.Filter tagFilter = new com.amazonaws.services.ec2.model.Filter();
        tagFilter.setName("resource-id");
        tagFilter.setValues(Arrays.asList(backup.getStorageId()));
        DescribeTagsRequest tagsRequest = new DescribeTagsRequest().withFilters(new com.amazonaws.services.ec2.model.Filter[]{tagFilter});
        DescribeTagsResult tagsResult = ec2.describeTags(tagsRequest);
        for (TagDescription tag : tagsResult.getTags()) {
            if (!tag.getKey().equals("Name")) continue;
            storageName = tag.getValue();
            break;
        }
        if ((awsSnapshot = createSnapshotResult.getSnapshot()) != null) {
            CloudStorageBackupLocalHome home = CloudStorageBackupUtil.getLocalHome();
            CloudStorageBackupData data = new CloudStorageBackupData(backup.getTableData());
            data.setSnapshotId(awsSnapshot.getSnapshotId());
            data.setCloudId("AWS");
            data.setCloudUserId(user.getCloudUserName());
            data.setRestoreStatus(RestoreStatus.available.number());
            data.setCloudAccountId(AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()));
            if (storageName != null) {
                data.setStorageName(storageName);
            }
            CloudStorageBackupLocal local = home.create(data);
            snapshots = new CloudStorageBackup(local.getDetail());
        }
        return snapshots;
    }

    public CloudStorageBackup createStorageBackup(CreateStorageBackupRequest request) throws CloudManagerFault, NamingException, FinderException, NotifyNotFound, CreateException, ValidationFault {
        com.amazonaws.services.ec2.model.Snapshot awsSnapshot;
        m_log.debug((Object)"createStorageBackup");
        CloudUser user = this.getCurrentCloudUserInfo();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), request.getRegionName());
        DescribeVolumesRequest describeVolumesRequest = new DescribeVolumesRequest().withVolumeIds(new String[]{request.getStorageId()});
        DescribeVolumesResult describeVolumesResult = ec2.describeVolumes(describeVolumesRequest);
        Volume volume = (Volume)describeVolumesResult.getVolumes().get(0);
        CloudStorageBackup snapshots = null;
        CreateSnapshotRequest createSnapshotRequest = new CreateSnapshotRequest().withVolumeId(request.getStorageId()).withDescription(request.getDescription());
        CreateSnapshotResult createSnapshotResult = ec2.createSnapshot(createSnapshotRequest);
        AWSUtil.addTag(ec2, createSnapshotResult.getSnapshot().getSnapshotId(), "SouceStorageId", request.getStorageId());
        String storageName = null;
        com.amazonaws.services.ec2.model.Filter tagFilter = new com.amazonaws.services.ec2.model.Filter();
        tagFilter.setName("resource-id");
        tagFilter.setValues(Arrays.asList(request.getStorageId()));
        DescribeTagsRequest tagsRequest = new DescribeTagsRequest().withFilters(new com.amazonaws.services.ec2.model.Filter[]{tagFilter});
        DescribeTagsResult tagsResult = ec2.describeTags(tagsRequest);
        for (TagDescription tag : tagsResult.getTags()) {
            if (!tag.getKey().equals("Name")) continue;
            storageName = tag.getValue();
            break;
        }
        if ((awsSnapshot = createSnapshotResult.getSnapshot()) != null) {
            CloudStorageBackupData data = new CloudStorageBackupData();
            data.setSnapshotId(awsSnapshot.getSnapshotId());
            data.setCloudId(this.findAllCloudType()[0].getCloudId());
            data.setCloudUserId(user.getCloudUserName());
            data.setRestoreStatus(RestoreStatus.available.number());
            data.setCloudAccountId(AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()));
            data.setRestoreStatus(RestoreStatus.available.number());
            data.setDescription(request.getDescription());
            data.setAvailabilityZone(volume.getAvailabilityZone());
            data.setStorageSize(volume.getSize());
            data.setSnapshotName(request.getSnapshotName());
            data.setRegion(request.getRegionName());
            data.setStorageId(request.getStorageId());
            if (storageName != null) {
                data.setStorageName(storageName);
            }
            CloudStorageBackupLocalHome home = CloudStorageBackupUtil.getLocalHome();
            CloudStorageBackupLocal local = home.create(data);
            snapshots = new CloudStorageBackup(local.getDetail());
        }
        return snapshots;
    }

    public CloudStorageBackup findStorageBackup(String region, String snapshotId) throws NamingException, FinderException, ValidationFault, CloudManagerFault {
        m_log.debug((Object)"findStorageBackup");
        CloudUser user = this.getCurrentCloudUserInfo();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), region);
        try {
            List<CloudStorageBackup> snapshots = StorageBackupUtil.getStorageBackup(ec2, new Filter("region", region), new Filter("snapshotId", snapshotId), new Filter("cloudAccountId", AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId())));
            return snapshots.get(0);
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)("Not exist backup(" + snapshotId + ")."));
            throw new CloudManagerFault(e);
        }
    }

    public CloudStorageBackup[] findStorageBackupsByRegion(String regionName) throws NamingException, FinderException, ValidationFault, CloudManagerFault {
        return this.findStorageBackupsByRegion(this.getCurrentCloudUserInfo(), regionName);
    }

    public CloudStorageBackup[] findStorageBackupsByRegion(CloudUser user, String regionName) throws NamingException, FinderException, ValidationFault, CloudManagerFault {
        m_log.debug((Object)"findStorageBackups");
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), regionName);
        try {
            List<CloudStorageBackup> snapshots = StorageBackupUtil.getStorageBackup(ec2, new Filter("region", regionName), new Filter("cloudAccountId", AWSUtil.getAccountIdFromIAM(user.getCloudResourceId())));
            return snapshots.toArray(new CloudStorageBackup[0]);
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)("Not exist backup in (" + regionName + ")."));
            throw new CloudManagerFault(e);
        }
    }

    public void removeStorageBackup(String region, String snapshotId) throws NamingException, RemoveException, FinderException, ValidationFault, CreateException, CloudManagerFault {
        m_log.debug((Object)"removeStorageBackup");
        CloudStorageBackupLocal local = null;
        CloudStorageBackupLocalHome home = CloudStorageBackupUtil.getLocalHome();
        try {
            local = home.findByPrimaryKey(new CloudStorageBackupPK(snapshotId, AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()), region));
        }
        catch (FinderException e) {
            Logger logger = Logger.getLogger(this.getClass());
            logger.debug((Object)("Not exist storage(" + snapshotId + ")."));
        }
        if (local != null) {
            block5: {
                try {
                    CloudUser user = this.getCurrentCloudUserInfo();
                    AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), region);
                    ec2.deleteSnapshot(new DeleteSnapshotRequest(snapshotId));
                }
                catch (AmazonServiceException e) {
                    if (AWSErrorCode.InvalidSnapshot_NotFound.label().equals(e.getErrorCode())) break block5;
                    throw e;
                }
            }
            home.remove(local.getPrimaryKey());
        }
    }

    public CloudStorageBackup[] findAllStorageBackup() throws NamingException, FinderException, CloudManagerFault {
        m_log.debug((Object)"findAllStorageBackup");
        CloudStorageBackupLocal local = null;
        CloudStorageBackupLocalHome home = CloudStorageBackupUtil.getLocalHome();
        ArrayList<CloudStorageBackup> backups = new ArrayList<CloudStorageBackup>();
        for (Object o : home.findByFilter(new Filter[]{new Filter("cloudAccountId", AWSUtil.getAccountIdFromIAM(this.getCurrentCloudUserInfo().getCloudResourceId()))})) {
            local = (CloudStorageBackupLocal)o;
            backups.add(new CloudStorageBackup(local.getDetail()));
        }
        return backups.toArray(new CloudStorageBackup[0]);
    }

    public String getWindowsPassword(String region, String instanceId) throws CloudManagerFault {
        m_log.debug((Object)"getWindowsPassword");
        try {
            CloudUser user = this.getCurrentCloudUserInfo();
            AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), region);
            GetPasswordDataRequest request = new GetPasswordDataRequest().withInstanceId(instanceId);
            GetPasswordDataResult result = ec2.getPasswordData(request);
            return result.getPasswordData();
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public Snapshot[] getSnapshots(String region, Filter[] filters) throws CloudManagerFault {
        m_log.debug((Object)"getSnapshots");
        CloudUser user = null;
        try {
            user = this.getCurrentCloudUserInfo();
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        DescribeSnapshotsRequest request = new DescribeSnapshotsRequest();
        request.setRegion(region);
        request.setFilters(Arrays.asList(filters));
        return request.execute(user).getSnapshots().toArray(new Snapshot[0]);
    }

    public String[] getAllVolumeType() throws CloudManagerFault {
        m_log.debug((Object)"getAllVoluemType");
        CloudUser user = null;
        try {
            user = this.getCurrentCloudUserInfo();
        }
        catch (CloudManagerFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
        DescribeVolumeTypesRequest request = new DescribeVolumeTypesRequest();
        return request.execute(user).getVolumeTypes().toArray(new String[0]);
    }

    public String[] getAllServiceName() throws CloudManagerFault {
        m_log.debug((Object)"getAllServiceName");
        DescribeServiceNamesRequest request = new DescribeServiceNamesRequest();
        return request.execute(null).getServiceNames().toArray(new String[0]);
    }
}

