/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.services.ec2.AmazonEC2;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.Image;
import com.clustercontrol.cloud.factory.CloudRequest;
import com.clustercontrol.cloud.factory.DescribeImagesResult;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import java.util.ArrayList;
import java.util.List;

public class DescribeImagesRequest
extends CloudRequest {
    private String region;
    private List<Filter> filters = new ArrayList<Filter>();

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public DescribeImagesResult execute(CloudUser user) throws CloudManagerFault {
        com.amazonaws.services.ec2.model.DescribeImagesRequest awsRequest = new com.amazonaws.services.ec2.model.DescribeImagesRequest();
        for (Filter f : this.getFilters()) {
            com.amazonaws.services.ec2.model.Filter awsFilter = new com.amazonaws.services.ec2.model.Filter(f.getName(), f.getValues());
            awsRequest.getFilters().add(awsFilter);
        }
        DescribeImagesResult imageResult = new DescribeImagesResult();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), this.region);
        com.amazonaws.services.ec2.model.DescribeImagesResult awsResult = ec2.describeImages(awsRequest);
        for (com.amazonaws.services.ec2.model.Image awsImage : awsResult.getImages()) {
            Image image = new Image();
            image.setImageId(awsImage.getImageId());
            image.setName(awsImage.getName());
            imageResult.getImages().add(image);
        }
        return imageResult;
    }
}

