/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.Snapshot;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.factory.CloudRequest;
import com.clustercontrol.cloud.factory.DescribeSnapshotsResult;
import com.clustercontrol.cloud.util.aws.AmazonEC2Provider;
import java.util.ArrayList;
import java.util.List;

public class DescribeInstancesRequest
extends CloudRequest {
    private String region;
    private List<Filter> filters = new ArrayList<Filter>();

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public DescribeSnapshotsResult execute(CloudUser user) throws CloudManagerFault {
        DescribeSnapshotsRequest awsRequest = new DescribeSnapshotsRequest();
        for (Filter f : this.getFilters()) {
            com.amazonaws.services.ec2.model.Filter awsFilter = new com.amazonaws.services.ec2.model.Filter(f.getName(), f.getValues());
            awsRequest.getFilters().add(awsFilter);
        }
        DescribeSnapshotsResult storagesResult = new DescribeSnapshotsResult();
        AmazonEC2 ec2 = AmazonEC2Provider.getAmazonEC2Provider().getAmazonEC2(new AmazonEC2Provider.CloudCredential(user.getAccessKey(), user.getSecretKey()), this.region);
        com.amazonaws.services.ec2.model.DescribeSnapshotsResult awsResult = ec2.describeSnapshots(awsRequest);
        for (Snapshot awsSnapshot : awsResult.getSnapshots()) {
            com.clustercontrol.cloud.bean.Snapshot snapshot = new com.clustercontrol.cloud.bean.Snapshot();
            snapshot.setSnapshotId(awsSnapshot.getSnapshotId());
            snapshot.setRegion(this.region);
            snapshot.setDescription(awsSnapshot.getDescription());
            storagesResult.getSnapshots().add(snapshot);
        }
        return storagesResult;
    }
}

