/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.factory;

import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.TemplateJobsArgument;
import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.util.Messages;
import com.clustercontrol.commons.util.SendQueue;
import com.clustercontrol.hinemosagent.util.AgentConnectUtil;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobParameterInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.JobTriggerInfo;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerLocal;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerLocalHome;
import com.clustercontrol.jobmanagement.ejb.session.JobControllerUtil;
import com.clustercontrol.jobmanagement.util.JobUtil;
import com.clustercontrol.notify.bean.OutputBasicInfo;
import com.clustercontrol.repository.bean.NodeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocalHome;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jboss.logging.Logger;

public class TemplateJobOperator {
    public static void runJobAfterOperation(String facilityId, String jobId, List<TemplateJobsArgument> arguments, final Starter operationStarter) throws CloudManagerFault {
        InternalJob internalJob = new InternalJob(facilityId, jobId, arguments);
        final JobStarter jobStarter = new JobStarter(internalJob);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Boolean executeFlg = operationStarter.start();
                    if (!executeFlg.booleanValue()) {
                        throw new CloudManagerFault("Operation failed. Job didn't execute.");
                    }
                    jobStarter.start();
                }
                catch (Exception e) {
                    Logger logger = Logger.getLogger(TemplateJobOperator.class);
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
        thread.start();
    }

    public static void runJobBeforeOperation(String facilityId, final String jobId, List<TemplateJobsArgument> arguments, final Starter operationStarter) throws CloudManagerFault {
        final InternalJob internalJob = new InternalJob(facilityId, jobId, arguments);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Logger logger = Logger.getLogger(TemplateJobOperator.class);
                try {
                    int maxCount = Integer.parseInt(CloudPropertyConstants.templatejob_endcheck_count.value());
                    long interval = Long.parseLong(CloudPropertyConstants.templatejob_endcheck_interval.value());
                    String sessionId = internalJob.execute();
                    int counter = 0;
                    while (true) {
                        logger.debug((Object)("It tries to check job end jobId: " + jobId + " sessionId: " + sessionId + " " + ++counter + "/" + maxCount + " time."));
                        if (JobUtil.isRunJob((String)sessionId, (String)"AWS", (String)jobId)) {
                            operationStarter.start();
                            return;
                        }
                        if (maxCount != 0 && counter >= maxCount) {
                            throw new CloudManagerFault("It timed out. The end of the job wasn't able to be checked.");
                        }
                        Thread.sleep(interval);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
        });
        thread.start();
    }

    public static void registAgent(final String facilityId) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Logger logger = Logger.getLogger(TemplateJobOperator.class);
                try {
                    int counter = 0;
                    int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
                    long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
                    while (true) {
                        logger.debug((Object)("It tries to regist agent " + facilityId + " " + ++counter + "/" + maxCount + " time."));
                        if (AgentConnectUtil.sendManagerIp((String)facilityId)) {
                            return;
                        }
                        if (maxCount != 0 && counter >= maxCount) {
                            throw new CloudManagerFault("It timed out. Target agent doesn't exist.");
                        }
                        Thread.sleep(interval);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
        });
        thread.start();
    }

    public static Boolean registAgentObserve(String facilityId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(TemplateJobOperator.class);
        try {
            int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
            long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
            int counter = 0;
            Boolean sendMessageState = false;
            while (true) {
                logger.debug((Object)("It tries to regist agent " + facilityId + " " + ++counter + "/" + maxCount + " time."));
                if (AgentConnectUtil.checkAgentConnection((String)facilityId)) {
                    return true;
                }
                if (!sendMessageState.booleanValue()) {
                    sendMessageState = AgentConnectUtil.sendManagerIp((String)facilityId);
                }
                if (maxCount != 0 && counter >= maxCount) {
                    if (sendMessageState.booleanValue() && AgentConnectUtil.checkAgentConnection((String)facilityId)) {
                        return true;
                    }
                    throw new CloudManagerFault("It timed out. Target agent doesn't exist.");
                }
                Thread.sleep(interval);
            }
        }
        catch (Exception e) {
            InternalEventNotifier internalEventNotifier = new InternalEventNotifier("AGT_CONNECTION", facilityId, Messages.getString("cloud.template.message.agent_connection.error_message"));
            internalEventNotifier.start();
            throw new CloudManagerFault(e);
        }
    }

    public static Boolean findAgentObserve(String facilityId) throws CloudManagerFault {
        Logger logger = Logger.getLogger(TemplateJobOperator.class);
        try {
            int maxCount = Integer.parseInt(CloudPropertyConstants.agent_connection_count.value());
            long interval = Long.parseLong(CloudPropertyConstants.agent_connection_interval.value());
            int counter = 0;
            while (true) {
                ++counter;
                logger.debug((Object)("It tries to find agent " + facilityId + " " + ++counter + "/" + maxCount + " time."));
                if (AgentConnectUtil.checkAgentConnection((String)facilityId)) {
                    return true;
                }
                if (maxCount != 0 && counter >= maxCount) {
                    throw new CloudManagerFault("It timed out. Target agent doesn't exist.");
                }
                Thread.sleep(interval);
            }
        }
        catch (Exception e) {
            throw new CloudManagerFault(e);
        }
    }

    public static class InternalEventNotifier
    implements Starter {
        private static final String MONITOR_ID = "SYS";
        private static final String APPLICATION = Messages.getString("cloud.template.message.notify.application");
        private static final String MESSAGE_ID = "001";
        private static final int PRIORITY = 2;
        private String pluginId;
        private String facilityId;
        private String message;

        InternalEventNotifier(String pluginId, String facilityId, String message) {
            this.pluginId = pluginId;
            this.facilityId = facilityId;
            this.message = message;
        }

        @Override
        public Boolean start() throws CloudManagerFault {
            try {
                SendQueue messageQueue = new SendQueue("queue/clustercontrolNotifyEvent");
                OutputBasicInfo output = new OutputBasicInfo();
                output.setPluginId(this.pluginId);
                output.setMonitorId(MONITOR_ID);
                output.setFacilityId(this.facilityId);
                RepositoryControllerLocalHome repositoryHome = RepositoryControllerUtil.getLocalHome();
                RepositoryControllerLocal repositoryLocal = repositoryHome.create();
                NodeInfo nodeInfo = repositoryLocal.getNode(this.facilityId);
                output.setScopeText(nodeInfo.getFacilityName());
                output.setApplication(APPLICATION);
                output.setMessageId(MESSAGE_ID);
                output.setMessage(this.message);
                output.setPriority(2);
                output.setGenerationDate(Long.valueOf(new Date().getTime()));
                messageQueue.put((Serializable)output);
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(TemplateJobOperator.class);
                logger.error((Object)e.getMessage(), (Throwable)e);
                return false;
            }
            return true;
        }
    }

    private static class InternalJob {
        String jobunitId = "AWS";
        String jobId;
        OutputBasicInfo info = new OutputBasicInfo();
        JobTriggerInfo triggerInfo = new JobTriggerInfo();
        List<TemplateJobsArgument> arguments;

        public InternalJob(String facilityId, String jobId, List<TemplateJobsArgument> arguments) {
            this.jobId = jobId;
            this.info.setFacilityId(facilityId);
            this.triggerInfo.setTrigger_info(JobTriggerTypeConstant.STRING_MANUAL);
            this.triggerInfo.setTrigger_type(Integer.valueOf(2));
            this.arguments = arguments;
        }

        public String execute() throws CloudManagerFault {
            Logger logger = Logger.getLogger(TemplateJobOperator.class);
            logger.debug((Object)("runJob : jobunitId=" + this.jobunitId + ", jobId=" + this.jobId + ", info=" + this.info + ", triggerInfo=" + this.triggerInfo));
            try {
                JobControllerLocalHome home = JobControllerUtil.getLocalHome();
                JobControllerLocal local = home.create();
                JobTreeItem root = local.getJobTree(true, Locale.getDefault());
                JobTreeItem awsRoot = null;
                for (JobTreeItem item : ((JobTreeItem)root.getChildren().get(0)).getChildren()) {
                    if (!item.getData().getId().equals("AWS")) continue;
                    awsRoot = item;
                }
                if (awsRoot != null) {
                    JobInfo info = local.getJobFull(awsRoot.getData());
                    awsRoot.setData(info);
                    ArrayList paramList = info.getParam();
                    if (paramList != null && this.arguments != null && this.arguments.size() > 0) {
                        for (JobParameterInfo param : paramList) {
                            for (TemplateJobsArgument arg : this.arguments) {
                                if (!param.getParamId().equals("aws_" + arg.getJobId())) continue;
                                param.setValue(arg.getArg());
                            }
                        }
                        info.setEdit(true);
                        awsRoot.setData(info);
                        local.replaceJobunit(awsRoot);
                    }
                } else {
                    throw new CloudManagerFault("Jobunit AWS not found.");
                }
                return local.runJob(this.jobunitId, this.jobId, this.info, this.triggerInfo);
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
    }

    private static class JobStarter
    implements Starter {
        InternalJob job;

        public JobStarter(InternalJob job) {
            this.job = job;
        }

        @Override
        public Boolean start() throws CloudManagerFault {
            try {
                this.job.execute();
                return true;
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
    }

    public static interface Starter {
        public Boolean start() throws CloudManagerFault;
    }
}

