/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.persistence;

import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.persistence.ApplyCurrentTime;
import com.clustercontrol.cloud.persistence.ApplyUserName;
import com.clustercontrol.cloud.persistence.Column;
import com.clustercontrol.cloud.persistence.Cryption;
import com.clustercontrol.cloud.persistence.PersistenceManager;
import com.clustercontrol.cloud.persistence.PrimaryKey;
import com.clustercontrol.cloud.persistence.Table;
import com.clustercontrol.cloud.persistence.Unmodifiable;
import com.clustercontrol.cloud.util.aws.CryptionUtil;
import com.clustercontrol.commons.util.ConnectionManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.jboss.logging.Logger;

public class PersistenceManagerImpl
implements PersistenceManager {
    private Map<Class<?>, PersistenceManager.EntityTypeInfo> typeInfoMap = new HashMap();
    private EntityContext context;
    private String cryptKey;

    public PersistenceManagerImpl(String cryptKey) {
        this.cryptKey = cryptKey;
    }

    @Override
    public synchronized PersistenceManager.EntityTypeInfo getEntityTypeInfo(Class<?> type) {
        Class<?> clazz;
        PersistenceManager.EntityTypeInfo typeInfo = null;
        for (clazz = type; clazz != Object.class && (typeInfo = this.typeInfoMap.get(type)) == null; clazz = clazz.getSuperclass()) {
        }
        if (typeInfo == null) {
            for (clazz = type; clazz != Object.class; clazz = clazz.getSuperclass()) {
                Table t = clazz.getAnnotation(Table.class);
                if (t == null) continue;
                Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
                logger.debug((Object)("checking : " + clazz.getName()));
                EntityTypeInfoImpl ti = new EntityTypeInfoImpl();
                typeInfo = ti;
                ti.setType(clazz);
                ti.setTableName(t.tableName());
                ArrayList<BeanPropInfoImpl> primaryKey = new ArrayList<BeanPropInfoImpl>();
                HashMap<String, Method> setMethodMap = new HashMap<String, Method>();
                HashMap<String, BeanPropInfoImpl> getMethodMap = new HashMap<String, BeanPropInfoImpl>();
                for (Method method : clazz.getMethods()) {
                    Cryption crypt;
                    ApplyUserName un;
                    ApplyCurrentTime ct;
                    Unmodifiable um;
                    logger.debug((Object)("checking : " + method.getName()));
                    Column c = method.getAnnotation(Column.class);
                    if (c == null) {
                        logger.debug((Object)("not applicable : " + method.getName()));
                        if (!method.getName().startsWith("set")) continue;
                        logger.debug((Object)("found SetMethod : " + method.getName()));
                        if (Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                        String propName = method.getName().substring("set".length());
                        BeanPropInfoImpl pi = (BeanPropInfoImpl)getMethodMap.get(propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1));
                        if (pi != null) {
                            logger.debug((Object)("complete : " + propName));
                            pi.setSetMethod(method);
                            continue;
                        }
                        logger.debug((Object)("store : " + propName));
                        setMethodMap.put(propName, method);
                        continue;
                    }
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException();
                    }
                    if (method.isSynthetic()) {
                        throw new IllegalStateException();
                    }
                    if (method.getParameterTypes().length != 0) {
                        throw new IllegalStateException();
                    }
                    if (!method.getName().startsWith("get")) {
                        throw new IllegalStateException();
                    }
                    Class<?> returnType = method.getReturnType();
                    if (Void.class.isAssignableFrom(returnType) || Void.TYPE.isAssignableFrom(returnType)) {
                        throw new IllegalStateException();
                    }
                    logger.debug((Object)("found getMethod : " + method.getName()));
                    BeanPropInfoImpl propInfo = new BeanPropInfoImpl();
                    propInfo.setCloumnName(c.value());
                    propInfo.setGetMethod(method);
                    propInfo.setType(returnType);
                    PrimaryKey pk = method.getAnnotation(PrimaryKey.class);
                    if (pk != null) {
                        primaryKey.add(propInfo);
                    }
                    if ((um = method.getAnnotation(Unmodifiable.class)) != null) {
                        propInfo.setUnmodifiable(true);
                    }
                    if ((ct = method.getAnnotation(ApplyCurrentTime.class)) != null) {
                        if (returnType == Date.class) {
                            propInfo.setApplyCurrentTime(true);
                        } else {
                            throw new IllegalStateException();
                        }
                    }
                    if ((un = method.getAnnotation(ApplyUserName.class)) != null) {
                        if (returnType == String.class) {
                            propInfo.setApplyUserName(true);
                        } else {
                            throw new IllegalStateException();
                        }
                    }
                    if ((crypt = method.getAnnotation(Cryption.class)) != null) {
                        if (returnType == String.class) {
                            propInfo.setCryption(true);
                        } else {
                            throw new IllegalStateException();
                        }
                    }
                    String propName = method.getName().substring("get".length());
                    propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                    propInfo.setPropName(propName);
                    Method setMethod = (Method)setMethodMap.get(propName);
                    if (setMethod != null && setMethod.getParameterTypes()[0] == propInfo.type()) {
                        setMethodMap.remove(propName);
                        propInfo.setSetMethod(setMethod);
                        logger.debug((Object)("complete : " + propName));
                    }
                    getMethodMap.put(propName, propInfo);
                }
                for (Map.Entry entry : getMethodMap.entrySet()) {
                    if (((BeanPropInfoImpl)entry.getValue()).setMethod() != null) continue;
                    throw new IllegalStateException((String)entry.getKey());
                }
                if (primaryKey.isEmpty()) {
                    throw new IllegalStateException("not found primary key");
                }
                PkTypeInfoImpl pkType = new PkTypeInfoImpl();
                pkType.setType(t.pkType());
                ArrayList<PkFieldInfoImpl> pkFieldList = new ArrayList<PkFieldInfoImpl>();
                for (PersistenceManager.BeanPropInfo beanPropInfo : primaryKey) {
                    Field f;
                    PkFieldInfoImpl fieldInfo = new PkFieldInfoImpl();
                    try {
                        f = t.pkType().getField(beanPropInfo.propName());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                    fieldInfo.setField(f);
                    fieldInfo.setPropName(beanPropInfo.propName());
                    pkFieldList.add(fieldInfo);
                }
                pkType.setFields(pkFieldList.toArray(new PersistenceManager.PkFieldInfo[0]));
                ti.setPkType(pkType);
                ti.setPrimaryKey(primaryKey.toArray(new BeanPropInfoImpl[0]));
                ArrayList list = new ArrayList(getMethodMap.values());
                list.removeAll(primaryKey);
                ti.setPropInfos(list.toArray(new BeanPropInfoImpl[0]));
            }
            this.typeInfoMap.put(type, typeInfo);
        }
        return typeInfo;
    }

    @Override
    public void insert(Object entity) throws CreateException, EJBException, DuplicateKeyException {
        Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
        logger.debug((Object)("insert() start : " + entity.toString()));
        PersistenceManager.EntityTypeInfo ti = this.getEntityTypeInfo(entity.getClass());
        if (ti == null) {
            throw new IllegalStateException(entity.getClass().getName());
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            int i;
            conn = ConnectionManager.getConnectionManager().getConnection();
            PersistenceManager.BeanPropInfo[] ps = ti.allPropInfo();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(ti.tableName()).append(" (");
            for (i = 0; i < ps.length; ++i) {
                if (i < ps.length - 1) {
                    sql.append(ps[i].cloumnName()).append(", ");
                    continue;
                }
                sql.append(ps[i].cloumnName()).append(") ");
            }
            sql.append("VALUES (");
            for (i = 0; i < ps.length; ++i) {
                sql.append('?');
                if (i >= ps.length - 1) continue;
                sql.append(',');
            }
            sql.append(')');
            String sqlCommand = sql.toString();
            logger.debug((Object)sqlCommand);
            stmt = conn.prepareStatement(sqlCommand);
            try {
                ArrayList<Object> params = new ArrayList<Object>();
                for (PersistenceManager.BeanPropInfo pi : ps) {
                    if (pi.isApplyCurrentTime()) {
                        Date current = new Date();
                        params.add(current);
                        pi.setMethod().invoke(entity, current);
                        continue;
                    }
                    if (pi.isApplyUserName()) {
                        String user = this.context.getCallerPrincipal().getName();
                        params.add(user);
                        pi.setMethod().invoke(entity, user);
                        continue;
                    }
                    if (pi.isCryption()) {
                        String word = (String)pi.getMethod().invoke(entity, new Object[0]);
                        word = CryptionUtil.crypt(word, this.cryptKey);
                        params.add(word);
                        continue;
                    }
                    params.add(pi.getMethod().invoke(entity, new Object[0]));
                }
                PersistenceManagerImpl.setupStatement((PreparedStatement)stmt, 0, ps, params.toArray());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            int row = stmt.executeUpdate();
            if (row != 1) {
                logger.error((Object)("create() error : " + entity.toString() + " SQLException"));
                throw new EJBException("result row is not 1");
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                logger.error((Object)("insert error : " + entity.toString() + ", " + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                logger.error((Object)("create() error : " + entity.toString() + " SQLException"));
                throw new EJBException((Exception)e1);
            }
        }
        logger.debug((Object)("create() end : " + entity.toString()));
    }

    @Override
    public <T> T findByPrimaryKey(Class<?> type, T pk) throws FinderException {
        Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
        logger.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
        PersistenceManager.EntityTypeInfo ti = this.getEntityTypeInfo(type);
        if (ti == null) {
            throw new IllegalStateException(type.getName());
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            int i;
            conn = ConnectionManager.getConnectionManager().getConnection();
            PersistenceManager.BeanPropInfo[] primaryKey = ti.primaryKey();
            StringBuilder sql = new StringBuilder("SELECT ");
            for (i = 0; i < primaryKey.length; ++i) {
                if (i < primaryKey.length - 1) {
                    sql.append(primaryKey[i].cloumnName()).append(", ");
                    continue;
                }
                sql.append(primaryKey[i].cloumnName()).append(" ");
            }
            sql.append(" FROM ").append(ti.tableName()).append(" WHERE ");
            for (i = 0; i < primaryKey.length; ++i) {
                if (i < primaryKey.length - 1) {
                    sql.append(primaryKey[i].cloumnName()).append(" = ? AND ");
                    continue;
                }
                sql.append(primaryKey[i].cloumnName()).append(" = ?");
            }
            String sqlCommand = sql.toString();
            logger.debug((Object)("findByPrimaryKey : " + sqlCommand + ", " + pk.toString()));
            stmt = conn.prepareStatement(sqlCommand);
            ArrayList<Object> params = new ArrayList<Object>();
            try {
                for (PersistenceManager.BeanPropInfo pi : primaryKey) {
                    params.add(pk.getClass().getField(pi.propName()).get(pk));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            PersistenceManagerImpl.setupStatement((PreparedStatement)stmt, 0, primaryKey, params.toArray());
            res = stmt.executeQuery();
            if (res.next()) {
                T e = pk;
                return e;
            }
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                logger.error((Object)("findByPrimaryKey() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                logger.error((Object)("findByPrimaryKey() error : " + pk.toString() + " SQLException"));
                throw new EJBException((Exception)e1);
            }
            logger.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
        }
    }

    @Override
    public void load(Object pk, Object entity) throws EJBException {
        block25: {
            Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
            logger.debug((Object)("load() start : " + pk.toString()));
            PersistenceManager.EntityTypeInfo ti = this.getEntityTypeInfo(entity.getClass());
            if (ti == null) {
                throw new IllegalStateException(entity.getClass().getName());
            }
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                int i;
                conn = ConnectionManager.getConnectionManager().getConnection();
                PersistenceManager.BeanPropInfo[] primaryKey = ti.primaryKey();
                PersistenceManager.BeanPropInfo[] propInfos = ti.allPropInfo();
                StringBuilder sql = new StringBuilder("SELECT ");
                for (i = 0; i < propInfos.length; ++i) {
                    if (i < propInfos.length - 1) {
                        sql.append(propInfos[i].cloumnName()).append(", ");
                        continue;
                    }
                    sql.append(propInfos[i].cloumnName()).append(" ");
                }
                sql.append(" FROM ").append(ti.tableName()).append(" WHERE ");
                for (i = 0; i < primaryKey.length; ++i) {
                    if (i < primaryKey.length - 1) {
                        sql.append(primaryKey[i].cloumnName()).append(" = ? AND ");
                        continue;
                    }
                    sql.append(primaryKey[i].cloumnName()).append(" = ?");
                }
                String sqlCommand = sql.toString();
                logger.debug((Object)("load() : " + sqlCommand + ", " + pk.toString()));
                stmt = conn.prepareStatement(sqlCommand);
                ArrayList<Object> pkparams = new ArrayList<Object>();
                try {
                    for (PersistenceManager.BeanPropInfo pi : primaryKey) {
                        Object prop = pk.getClass().getField(pi.propName()).get(pk);
                        logger.debug((Object)("Primary key : " + pi.propName() + "=" + prop.toString()));
                        pkparams.add(prop);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                PersistenceManagerImpl.setupStatement((PreparedStatement)stmt, 0, primaryKey, pkparams.toArray());
                res = stmt.executeQuery();
                if (res.next()) {
                    try {
                        Object[] values = PersistenceManagerImpl.getValues(res, propInfos);
                        for (int i2 = 0; i2 < values.length; ++i2) {
                            if (propInfos[i2].isCryption()) {
                                String word = CryptionUtil.decrypt((String)values[i2], this.cryptKey);
                                propInfos[i2].setMethod().invoke(entity, word);
                                continue;
                            }
                            propInfos[i2].setMethod().invoke(entity, values[i2]);
                        }
                        break block25;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                String msg = "id " + pk.toString() + " not found.";
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                logger.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    logger.error((Object)("load() error : " + pk.toString() + " SQLException"));
                    throw new EJBException((Exception)e1);
                }
                logger.debug((Object)("load() end : " + pk.toString()));
            }
        }
    }

    private static void setupStatement(PreparedStatement stmt, int beginIndex, PersistenceManager.BeanPropInfo[] pis, Object[] params) throws SQLException {
        for (int i = 0; i < pis.length; ++i) {
            if (String.class == pis[i].type()) {
                stmt.setString(beginIndex + i + 1, (String)params[i]);
                continue;
            }
            if (Date.class == pis[i].type()) {
                stmt.setTimestamp(beginIndex + i + 1, new Timestamp(((Date)params[i]).getTime()));
                continue;
            }
            if (Double.TYPE == pis[i].type()) {
                stmt.setDouble(beginIndex + i + 1, (Double)params[i]);
                continue;
            }
            if (Double.class == pis[i].type()) {
                stmt.setDouble(beginIndex + i + 1, (Double)params[i]);
                continue;
            }
            if (Integer.TYPE == pis[i].type()) {
                stmt.setInt(beginIndex + i + 1, (Integer)params[i]);
                continue;
            }
            if (Integer.class == pis[i].type()) {
                stmt.setObject(beginIndex + i + 1, (Integer)params[i]);
                continue;
            }
            if (Short.TYPE == pis[i].type()) {
                stmt.setShort(beginIndex + i + 1, (Short)params[i]);
                continue;
            }
            if (Short.class == pis[i].type()) {
                stmt.setShort(beginIndex + i + 1, (Short)params[i]);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    private static void setupStatementForFilter(PreparedStatement stmt, int beginIndex, PersistenceManager.BeanPropInfo[] pis, String[] params) throws SQLException {
        for (int i = 0; i < pis.length; ++i) {
            if (params[i] == null) continue;
            if (String.class == pis[i].type()) {
                stmt.setString(beginIndex + i + 1, params[i]);
                continue;
            }
            if (Date.class == pis[i].type()) {
                stmt.setTimestamp(beginIndex + i + 1, new Timestamp(Long.valueOf(params[i])));
                continue;
            }
            if (Double.TYPE == pis[i].type()) {
                stmt.setDouble(beginIndex + i + 1, Double.valueOf(params[i]));
                continue;
            }
            if (Double.class == pis[i].type()) {
                stmt.setDouble(beginIndex + i + 1, Double.valueOf(params[i]));
                continue;
            }
            if (Integer.TYPE == pis[i].type()) {
                stmt.setInt(beginIndex + i + 1, Integer.valueOf(params[i]));
                continue;
            }
            if (Integer.class == pis[i].type()) {
                stmt.setInt(beginIndex + i + 1, Integer.valueOf(params[i]));
                continue;
            }
            if (Short.TYPE == pis[i].type()) {
                stmt.setShort(beginIndex + i + 1, Short.valueOf(params[i]));
                continue;
            }
            if (Short.class == pis[i].type()) {
                stmt.setShort(beginIndex + i + 1, Short.valueOf(params[i]));
                continue;
            }
            throw new IllegalStateException();
        }
    }

    private static Object[] getValues(ResultSet res, PersistenceManager.BeanPropInfo[] pis) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        for (PersistenceManager.BeanPropInfo pi : pis) {
            Object prop = null;
            if (String.class == pi.type()) {
                prop = res.getString(pi.cloumnName());
            } else if (Date.class == pi.type()) {
                prop = new Date(res.getTimestamp(pi.cloumnName()).getTime());
            } else if (Double.TYPE == pi.type()) {
                prop = res.getDouble(pi.cloumnName());
            } else if (Double.class == pi.type()) {
                prop = res.getDouble(pi.cloumnName());
            } else if (Integer.TYPE == pi.type()) {
                prop = res.getInt(pi.cloumnName());
            } else if (Integer.class == pi.type()) {
                prop = res.getInt(pi.cloumnName());
            } else if (Short.TYPE == pi.type()) {
                prop = res.getShort(pi.cloumnName());
            } else if (Short.class == pi.type()) {
                prop = res.getShort(pi.cloumnName());
            } else {
                throw new IllegalStateException();
            }
            params.add((String)prop);
        }
        return params.toArray();
    }

    @Override
    public void remove(Class<?> type, Object pk) throws EJBException, RemoveException {
        Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
        logger.debug((Object)("remove() start : " + pk.toString()));
        PersistenceManager.EntityTypeInfo ti = this.getEntityTypeInfo(type);
        if (ti == null) {
            throw new IllegalStateException(type.getName());
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            PersistenceManager.BeanPropInfo[] primaryKey = ti.primaryKey();
            StringBuilder sql = new StringBuilder("DELETE FROM ").append(ti.tableName()).append(" WHERE ");
            for (int i = 0; i < primaryKey.length; ++i) {
                if (i < primaryKey.length - 1) {
                    sql.append(primaryKey[i].cloumnName()).append(" = ? AND ");
                    continue;
                }
                sql.append(primaryKey[i].cloumnName()).append(" = ?");
            }
            String sqlCommand = sql.toString();
            logger.debug((Object)("remove() : " + sqlCommand + ", " + pk.toString()));
            stmt = conn.prepareStatement(sqlCommand);
            ArrayList<Object> params = new ArrayList<Object>();
            try {
                for (PersistenceManager.BeanPropInfo pi : primaryKey) {
                    params.add(ti.pkTypeInfo().getField(pi.propName()).field().get(pk));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            PersistenceManagerImpl.setupStatement((PreparedStatement)stmt, 0, primaryKey, params.toArray());
            int deleted = stmt.executeUpdate();
            if (deleted > 0) {
                return;
            }
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new RemoveException(msg);
            }
            catch (SQLException e) {
                logger.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException((Exception)e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                logger.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException((Exception)e1);
            }
            logger.debug((Object)("remove() end : " + pk.toString()));
        }
    }

    @Override
    public List<Object> findAll(Class<?> type) throws FinderException {
        Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
        logger.debug((Object)"findAll() start");
        PersistenceManager.EntityTypeInfo ti = this.getEntityTypeInfo(type);
        if (ti == null) {
            throw new IllegalStateException(type.getName());
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        List<Object> list = Collections.emptyList();
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            PersistenceManager.BeanPropInfo[] primaryKey = ti.primaryKey();
            StringBuilder sql = new StringBuilder("SELECT ");
            for (int i = 0; i < primaryKey.length; ++i) {
                if (i < primaryKey.length - 1) {
                    sql.append(primaryKey[i].cloumnName()).append(", ");
                    continue;
                }
                sql.append(primaryKey[i].cloumnName());
            }
            sql.append(" FROM ").append(ti.tableName());
            String sqlCommand = sql.toString();
            logger.debug((Object)("findAll() : " + sqlCommand));
            stmt = conn.prepareStatement(sqlCommand);
            res = stmt.executeQuery();
            try {
                list = new ArrayList();
                while (res.next()) {
                    Object[] values = PersistenceManagerImpl.getValues(res, primaryKey);
                    Object pk = ti.pkTypeInfo().type().newInstance();
                    for (int i = 0; i < values.length; ++i) {
                        ti.pkTypeInfo().getField(primaryKey[i].propName()).field().set(pk, values[i]);
                    }
                    list.add(pk);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"findAll() error", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                logger.error((Object)"findAll() error", (Throwable)e1);
                throw new EJBException((Exception)e1);
            }
            logger.debug((Object)"findAll() end");
        }
        return list;
    }

    @Override
    public void store(Object entity) throws EJBException {
        Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
        logger.debug((Object)"store() start");
        PersistenceManager.EntityTypeInfo ti = this.getEntityTypeInfo(entity.getClass());
        if (ti == null) {
            throw new IllegalStateException(entity.getClass().getName());
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            int i;
            conn = ConnectionManager.getConnectionManager().getConnection();
            PersistenceManager.BeanPropInfo[] primaryKey = ti.primaryKey();
            ArrayList<PersistenceManager.BeanPropInfo> tempList = new ArrayList<PersistenceManager.BeanPropInfo>();
            for (PersistenceManager.BeanPropInfo pi : ti.propInfos()) {
                if (pi.isUnmodifiable()) continue;
                tempList.add(pi);
            }
            PersistenceManager.BeanPropInfo[] propInfos = tempList.toArray(new PersistenceManager.BeanPropInfo[0]);
            StringBuilder sql = new StringBuilder("UPDATE ").append(ti.tableName()).append(" SET ");
            for (i = 0; i < propInfos.length; ++i) {
                if (i < propInfos.length - 1) {
                    sql.append(propInfos[i].cloumnName()).append(" = ?, ");
                    continue;
                }
                sql.append(propInfos[i].cloumnName()).append(" = ?");
            }
            sql.append(" WHERE ");
            for (i = 0; i < primaryKey.length; ++i) {
                if (i < primaryKey.length - 1) {
                    sql.append(primaryKey[i].cloumnName()).append(" = ? and ");
                    continue;
                }
                sql.append(primaryKey[i].cloumnName()).append(" = ?");
            }
            String sqlCommand = sql.toString();
            logger.debug((Object)("store() : " + sqlCommand));
            stmt = conn.prepareStatement(sqlCommand);
            ArrayList<Object> params = new ArrayList<Object>();
            try {
                for (PersistenceManager.BeanPropInfo pi : propInfos) {
                    if (pi.isApplyCurrentTime()) {
                        Date current = new Date();
                        params.add(current);
                        pi.setMethod().invoke(entity, current);
                        continue;
                    }
                    if (pi.isApplyUserName()) {
                        String user = this.context.getCallerPrincipal().getName();
                        params.add(user);
                        pi.setMethod().invoke(entity, user);
                        continue;
                    }
                    if (pi.isCryption()) {
                        String word = (String)pi.getMethod().invoke(entity, new Object[0]);
                        word = CryptionUtil.crypt(word, this.cryptKey);
                        params.add(word);
                        continue;
                    }
                    params.add(pi.getMethod().invoke(entity, new Object[0]));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            PersistenceManagerImpl.setupStatement((PreparedStatement)stmt, 0, propInfos, params.toArray());
            ArrayList<Object> pkParams = new ArrayList<Object>();
            try {
                for (PersistenceManager.BeanPropInfo pi : primaryKey) {
                    pkParams.add(pi.getMethod().invoke(entity, new Object[0]));
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            PersistenceManagerImpl.setupStatement((PreparedStatement)stmt, params.size(), primaryKey, pkParams.toArray());
            int updated = stmt.executeUpdate();
            if (updated == 1) {
                return;
            }
            try {
                String msg = "failed to update : " + entity.toString();
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                logger.error((Object)"store() error", (Throwable)e);
                throw new EJBException((Exception)e);
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                logger.error((Object)"store() error", (Throwable)e1);
                throw new EJBException((Exception)e1);
            }
            logger.debug((Object)"store() end");
        }
    }

    @Override
    public void setContext(EntityContext context) {
        this.context = context;
    }

    @Override
    public List<Object> findByFilter(Class<?> type, Filter[] filters) throws FinderException {
        Logger logger = Logger.getLogger(PersistenceManagerImpl.class);
        logger.debug((Object)"findByFilter() start");
        PersistenceManager.EntityTypeInfo ti = this.getEntityTypeInfo(type);
        if (ti == null) {
            throw new IllegalStateException(type.getName());
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        List<Object> list = Collections.emptyList();
        try {
            int i;
            conn = ConnectionManager.getConnectionManager().getConnection();
            ArrayList<Filter> validFilters = new ArrayList<Filter>();
            ArrayList<PersistenceManager.BeanPropInfo> filterColums = new ArrayList<PersistenceManager.BeanPropInfo>();
            for (Filter f : filters) {
                PersistenceManager.BeanPropInfo bpi = ti.getPropInfo(f.getName());
                if (bpi == null || f.getValues().isEmpty()) continue;
                validFilters.add(f);
                filterColums.add(bpi);
            }
            ArrayList<String> params = new ArrayList<String>();
            for (Filter f : validFilters) {
                params.add(f.getValues().get(0));
            }
            PersistenceManager.BeanPropInfo[] primaryKey = ti.primaryKey();
            StringBuilder sql = new StringBuilder("SELECT ");
            for (i = 0; i < primaryKey.length; ++i) {
                if (i < primaryKey.length - 1) {
                    sql.append(primaryKey[i].cloumnName()).append(", ");
                    continue;
                }
                sql.append(primaryKey[i].cloumnName());
            }
            sql.append(" FROM ").append(ti.tableName());
            if (!filterColums.isEmpty()) {
                sql.append(" WHERE ");
                for (i = 0; i < filterColums.size(); ++i) {
                    sql.append(((PersistenceManager.BeanPropInfo)filterColums.get(i)).cloumnName()).append(' ');
                    if (params.get(i) == null) {
                        sql.append("IS NULL");
                    } else if (((PersistenceManager.BeanPropInfo)filterColums.get(i)).type() == String.class) {
                        sql.append("~ ?");
                    } else {
                        sql.append("= ?");
                    }
                    if (i >= filterColums.size() - 1) continue;
                    sql.append(" AND ");
                }
            }
            String sqlCommand = sql.toString();
            logger.debug((Object)("findByFilter() : " + sqlCommand));
            stmt = conn.prepareStatement(sqlCommand);
            PersistenceManagerImpl.setupStatementForFilter((PreparedStatement)stmt, 0, filterColums.toArray(new PersistenceManager.BeanPropInfo[0]), params.toArray(new String[0]));
            res = stmt.executeQuery();
            try {
                list = new ArrayList();
                while (res.next()) {
                    Object[] values = PersistenceManagerImpl.getValues(res, primaryKey);
                    Object pk = ti.pkTypeInfo().type().newInstance();
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        ti.pkTypeInfo().getField(primaryKey[i2].propName()).field().set(pk, values[i2]);
                    }
                    list.add(pk);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"findByFilter() error", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                logger.error((Object)"findByFilter() error", (Throwable)e1);
                throw new EJBException((Exception)e1);
            }
            logger.debug((Object)"findByFilter() end");
        }
        return list;
    }

    private static class PkTypeInfoImpl
    implements PersistenceManager.PkTypeInfo {
        private Class<?> type;
        private PersistenceManager.PkFieldInfo[] fields = new PersistenceManager.PkFieldInfo[0];
        private Map<String, PersistenceManager.PkFieldInfo> fieldMap = new HashMap<String, PersistenceManager.PkFieldInfo>();

        private PkTypeInfoImpl() {
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        @Override
        public PersistenceManager.PkFieldInfo[] fields() {
            return this.fields;
        }

        public void setFields(PersistenceManager.PkFieldInfo[] fields) {
            for (PersistenceManager.PkFieldInfo f : this.fields) {
                this.fieldMap.remove(f.propName());
            }
            for (PersistenceManager.PkFieldInfo f : this.fields = fields) {
                this.fieldMap.put(f.propName(), f);
            }
        }

        @Override
        public Object getPkObject(Object entity) {
            return null;
        }

        @Override
        public PersistenceManager.PkFieldInfo getField(String propName) {
            return this.fieldMap.get(propName);
        }
    }

    private static class PkFieldInfoImpl
    implements PersistenceManager.PkFieldInfo {
        private Field field;
        private String propName;

        private PkFieldInfoImpl() {
        }

        @Override
        public String propName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }

        @Override
        public Field field() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }
    }

    private static class BeanPropInfoImpl
    implements PersistenceManager.BeanPropInfo {
        private String propName;
        private String columnName;
        private Class<?> type;
        private Method setMethod;
        private Method getMethod;
        private boolean unmodifiable;
        private boolean applyCurrentTime;
        private boolean applyUserName;
        private boolean cryption;

        private BeanPropInfoImpl() {
        }

        @Override
        public String cloumnName() {
            return this.columnName;
        }

        public void setCloumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        @Override
        public Method getMethod() {
            return this.getMethod;
        }

        public void setGetMethod(Method getMethod) {
            this.getMethod = getMethod;
        }

        @Override
        public Method setMethod() {
            return this.setMethod;
        }

        public void setSetMethod(Method setMethod) {
            this.setMethod = setMethod;
        }

        @Override
        public String propName() {
            return this.propName;
        }

        public void setPropName(String propName) {
            this.propName = propName;
        }

        @Override
        public boolean isUnmodifiable() {
            return this.unmodifiable;
        }

        public void setUnmodifiable(boolean unmodifiable) {
            this.unmodifiable = unmodifiable;
        }

        @Override
        public boolean isApplyCurrentTime() {
            return this.applyCurrentTime;
        }

        public void setApplyCurrentTime(boolean applyCurrentTime) {
            this.applyCurrentTime = applyCurrentTime;
        }

        @Override
        public boolean isApplyUserName() {
            return this.applyUserName;
        }

        public void setApplyUserName(boolean applyUserName) {
            this.applyUserName = applyUserName;
        }

        public void setCryption(boolean cryption) {
            this.cryption = cryption;
        }

        @Override
        public boolean isCryption() {
            return this.cryption;
        }
    }

    private static class EntityTypeInfoImpl
    implements PersistenceManager.EntityTypeInfo {
        private String tableName;
        private Class<?> type;
        private PersistenceManager.PkTypeInfo pkTypeInfo;
        private PersistenceManager.BeanPropInfo[] primaryKey = new PersistenceManager.BeanPropInfo[0];
        private PersistenceManager.BeanPropInfo[] propInfos = new PersistenceManager.BeanPropInfo[0];
        private Map<String, PersistenceManager.BeanPropInfo> propMap = new HashMap<String, PersistenceManager.BeanPropInfo>();

        private EntityTypeInfoImpl() {
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public PersistenceManager.BeanPropInfo[] primaryKey() {
            return this.primaryKey;
        }

        public void setPrimaryKey(PersistenceManager.BeanPropInfo[] primaryKey) {
            for (PersistenceManager.BeanPropInfo pi : this.primaryKey) {
                this.propMap.remove(pi.propName());
            }
            for (PersistenceManager.BeanPropInfo pi : this.primaryKey = primaryKey) {
                this.propMap.put(pi.propName(), pi);
            }
        }

        @Override
        public PersistenceManager.BeanPropInfo[] propInfos() {
            return this.propInfos;
        }

        public void setPropInfos(PersistenceManager.BeanPropInfo[] propInfos) {
            for (PersistenceManager.BeanPropInfo pi : this.propInfos) {
                this.propMap.remove(pi.propName());
            }
            for (PersistenceManager.BeanPropInfo pi : this.propInfos = propInfos) {
                this.propMap.put(pi.propName(), pi);
            }
        }

        @Override
        public PersistenceManager.PkTypeInfo pkTypeInfo() {
            return this.pkTypeInfo;
        }

        public void setPkType(PersistenceManager.PkTypeInfo pkTypeInfo) {
            this.pkTypeInfo = pkTypeInfo;
        }

        @Override
        public PersistenceManager.BeanPropInfo[] allPropInfo() {
            int i;
            PersistenceManager.BeanPropInfo[] all = new PersistenceManager.BeanPropInfo[this.propInfos().length + this.primaryKey().length];
            for (i = 0; i < this.propInfos().length; ++i) {
                all[i] = this.propInfos()[i];
            }
            for (i = 0; i < this.primaryKey().length; ++i) {
                all[i + this.propInfos().length] = this.primaryKey()[i];
            }
            return all;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        @Override
        public PersistenceManager.BeanPropInfo getPropInfo(String propName) {
            return this.propMap.get(propName);
        }
    }
}

