/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.clustercontrol.cloud.bean.CloudManagerFault;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.bean.CloudUserType;
import com.clustercontrol.cloud.bean.Region;
import com.clustercontrol.cloud.common.util.CloudPropertyConstants;
import com.clustercontrol.cloud.ejb.session.CloudControllerUtil;
import com.clustercontrol.util.Messages;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;

public class AmazonEC2Provider {
    private Map<String, String> endpointMap = new HashMap<String, String>();
    private Map<String, AvailabilityZone[]> availabilityZonesMap = new HashMap<String, AvailabilityZone[]>();
    private static AmazonEC2Provider singleton;

    public synchronized AmazonEC2 getAmazonEC2(CloudCredential credential, String regionName) throws CloudManagerFault {
        final AmazonEC2 ec2 = this.createAmazonEC2(credential);
        String endpoint = this.endpointMap.get(regionName);
        if (endpoint == null) {
            DescribeRegionsResult result = ec2.describeRegions();
            for (com.amazonaws.services.ec2.model.Region r : result.getRegions()) {
                this.endpointMap.put(r.getRegionName(), r.getEndpoint());
            }
            endpoint = this.endpointMap.get(regionName);
        }
        if (endpoint == null) {
            throw new CloudManagerFault(Messages.getString((String)"cloud.aws.region.message.invalid_region_name") + " : " + regionName);
        }
        ec2.setEndpoint(endpoint);
        InvocationHandler h = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Logger logger = Logger.getLogger(AmazonEC2Provider.class);
                    long before = System.currentTimeMillis();
                    Object result = method.invoke((Object)ec2, args);
                    long after = System.currentTimeMillis();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Called ").append(method.getName()).append(" : ").append("elapsedTime=").append(after - before).append("ms");
                    if (args != null) {
                        for (Object arg : args) {
                            sb.append(", arg=").append(arg.toString());
                        }
                    }
                    logger.debug((Object)sb.toString());
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        };
        return (AmazonEC2)Proxy.newProxyInstance(AmazonEC2.class.getClassLoader(), new Class[]{AmazonEC2.class}, h);
    }

    public synchronized Region[] getAllRegion(CloudUser user) throws CloudManagerFault {
        CloudUser accessibleUser = user;
        if (user.getCloudUserType() == CloudUserType.child) {
            try {
                accessibleUser = CloudControllerUtil.getLocalHome().create().findCloudUser(user.getParentCloudUserId());
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.getAllRegion(new CloudCredential(accessibleUser.getAccessKey(), accessibleUser.getSecretKey()));
    }

    public synchronized Region[] getAllRegion(CloudCredential credential) {
        if (this.endpointMap.isEmpty()) {
            AmazonEC2 ec2 = this.createAmazonEC2(credential);
            DescribeRegionsResult result = ec2.describeRegions();
            for (Object r : result.getRegions()) {
                this.endpointMap.put(r.getRegionName(), r.getEndpoint());
            }
        }
        ArrayList<Object> regions = new ArrayList<Object>();
        for (String regionName : this.endpointMap.keySet()) {
            Object r;
            r = new Region();
            ((Region)r).setRegionName(regionName);
            regions.add(r);
        }
        return regions.toArray(new Region[0]);
    }

    private AmazonEC2 createAmazonEC2(CloudCredential credential) {
        BasicAWSCredentials awsCledential = new BasicAWSCredentials(credential.getAccessKey(), credential.getSecretKey());
        ClientConfiguration conf = new ClientConfiguration();
        conf.setConnectionTimeout(Integer.valueOf(CloudPropertyConstants.aws_client_config_connectionTimeout.value()).intValue());
        conf.setMaxConnections(Integer.valueOf(CloudPropertyConstants.aws_client_config_maxConnections.value()).intValue());
        conf.setMaxErrorRetry(Integer.valueOf(CloudPropertyConstants.aws_client_config_maxErrorRetry.value()).intValue());
        conf.setProtocol(Protocol.HTTP.toString().equals(CloudPropertyConstants.aws_client_config_protocol.value()) ? Protocol.HTTP : Protocol.HTTPS);
        conf.setProxyDomain(CloudPropertyConstants.aws_client_config_proxyDomain.value());
        conf.setProxyHost(CloudPropertyConstants.aws_client_config_proxyHost.value());
        conf.setProxyPassword(CloudPropertyConstants.aws_client_config_proxyPassword.value());
        conf.setProxyPort(Integer.valueOf(CloudPropertyConstants.aws_client_config_proxyPort.value()).intValue());
        conf.setProxyUsername(CloudPropertyConstants.aws_client_config_proxyUsername.value());
        conf.setProxyWorkstation(CloudPropertyConstants.aws_client_config_proxyWorkstation.value());
        conf.setSocketTimeout(Integer.valueOf(CloudPropertyConstants.aws_client_config_socketTimeout.value()).intValue());
        return new AmazonEC2Client((AWSCredentials)awsCledential, conf);
    }

    public synchronized AvailabilityZone[] getAvailabilityZones(CloudUser user, String regionName) throws CloudManagerFault {
        CloudUser accessibleUser = user;
        if (user.getCloudUserType() == CloudUserType.child) {
            try {
                accessibleUser = CloudControllerUtil.getLocalHome().create().findCloudUser(user.getParentCloudUserId());
            }
            catch (Exception e) {
                throw new CloudManagerFault(e);
            }
        }
        return this.getAvailabilityZones(new CloudCredential(accessibleUser.getAccessKey(), accessibleUser.getSecretKey()), regionName);
    }

    public synchronized AvailabilityZone[] getAvailabilityZones(CloudCredential credential, String regionName) throws CloudManagerFault {
        AvailabilityZone[] zones = this.availabilityZonesMap.get(regionName);
        if (zones == null) {
            AmazonEC2 ec2 = this.getAmazonEC2(credential, regionName);
            DescribeAvailabilityZonesResult result = ec2.describeAvailabilityZones();
            zones = result.getAvailabilityZones().toArray(new AvailabilityZone[0]);
            this.availabilityZonesMap.put(regionName, zones);
        }
        return zones;
    }

    public void clear() {
        this.endpointMap.clear();
        this.availabilityZonesMap.clear();
    }

    public static synchronized AmazonEC2Provider getAmazonEC2Provider() {
        if (singleton == null) {
            singleton = new AmazonEC2Provider();
        }
        return singleton;
    }

    public static class CloudCredential {
        private String accessKey;
        private String secretKey;

        public CloudCredential(String accessKey, String secretKey) {
            assert (accessKey != null);
            assert (secretKey != null);
            this.accessKey = accessKey;
            this.secretKey = secretKey;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof CloudCredential) {
                CloudCredential value = (CloudCredential)anObject;
                return (this.accessKey == null ? this.accessKey == value.accessKey : this.accessKey.equals(value.accessKey)) && (this.secretKey == null ? this.secretKey == value.secretKey : this.secretKey.equals(value.secretKey));
            }
            return false;
        }

        public int hashCode() {
            int h = 0;
            h = 31 * h + this.accessKey == null ? 0 : this.accessKey.hashCode();
            h = 31 * h + this.secretKey == null ? 0 : this.secretKey.hashCode();
            return h;
        }
    }
}

