/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.aws;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.Image;
import com.clustercontrol.cloud.bean.CloudInstanceBackup;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.RestoreStatus;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupLocal;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudInstanceBackupUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class InstanceBackupUtil {
    public static List<CloudInstanceBackup> getInstanceBackup(AmazonEC2 ec2, Filter ... filters) throws NamingException, FinderException {
        CloudInstanceBackupLocal local = null;
        CloudInstanceBackupLocalHome home = CloudInstanceBackupUtil.getLocalHome();
        Collection result = filters != null && filters.length > 0 ? home.findByFilter(filters) : home.findAll();
        ArrayList<CloudInstanceBackup> backups = new ArrayList<CloudInstanceBackup>();
        HashMap<String, CloudInstanceBackupLocal> managedImageMap = new HashMap<String, CloudInstanceBackupLocal>();
        ArrayList<String> imageIds = new ArrayList<String>();
        if (!result.isEmpty()) {
            for (Object o : result) {
                local = (CloudInstanceBackupLocal)o;
                if (local.getRestoreStatus().shortValue() == RestoreStatus.available.number()) {
                    imageIds.add(local.getImageId());
                    managedImageMap.put(local.getImageId(), local);
                }
                backups.add(new CloudInstanceBackup(local.getDetail()));
            }
            if (!imageIds.isEmpty()) {
                DescribeImagesRequest describeImagesRequest = new DescribeImagesRequest().withImageIds(imageIds);
                DescribeImagesResult describeImagesResult = ec2.describeImages(describeImagesRequest);
                HashMap<String, Image> awsImageMap = new HashMap<String, Image>();
                for (Image image : describeImagesResult.getImages()) {
                    awsImageMap.put(image.getImageId(), image);
                }
                for (CloudInstanceBackup backup : backups) {
                    if (awsImageMap.containsKey(backup.getImageId())) {
                        backup.setImageType(((Image)awsImageMap.get(backup.getImageId())).getImageType());
                        backup.setPlatform(((Image)awsImageMap.get(backup.getImageId())).getPlatform());
                        continue;
                    }
                    if (!managedImageMap.containsKey(backup.getImageId())) continue;
                    ((CloudInstanceBackupLocal)managedImageMap.get(backup.getImageId())).setRestoreStatus(RestoreStatus.unavailable.number());
                    backup.setRestoreStatus(RestoreStatus.unavailable.number());
                }
            }
        }
        return backups;
    }
}

