/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.util.aws;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotsResult;
import com.amazonaws.services.ec2.model.Snapshot;
import com.clustercontrol.cloud.bean.CloudStorageBackup;
import com.clustercontrol.cloud.bean.Filter;
import com.clustercontrol.cloud.bean.RestoreStatus;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupLocal;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupLocalHome;
import com.clustercontrol.cloud.ejb.entity.CloudStorageBackupUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class StorageBackupUtil {
    public static List<CloudStorageBackup> getStorageBackup(AmazonEC2 ec2, Filter ... filters) throws NamingException, FinderException {
        CloudStorageBackupLocal local = null;
        CloudStorageBackupLocalHome home = CloudStorageBackupUtil.getLocalHome();
        Collection result = filters != null && filters.length > 0 ? home.findByFilter(filters) : home.findAll();
        ArrayList<CloudStorageBackup> backups = new ArrayList<CloudStorageBackup>();
        HashMap<String, CloudStorageBackupLocal> managedSnapshotMap = new HashMap<String, CloudStorageBackupLocal>();
        ArrayList<String> snapshotIds = new ArrayList<String>();
        if (!result.isEmpty()) {
            for (Object o : result) {
                local = (CloudStorageBackupLocal)o;
                if (local.getRestoreStatus().shortValue() == RestoreStatus.available.number()) {
                    snapshotIds.add(local.getSnapshotId());
                    managedSnapshotMap.put(local.getSnapshotId(), local);
                }
                backups.add(new CloudStorageBackup(local.getDetail()));
            }
            if (!snapshotIds.isEmpty()) {
                com.amazonaws.services.ec2.model.Filter awsFilter = new com.amazonaws.services.ec2.model.Filter();
                awsFilter.setName("snapshot-id");
                awsFilter.setValues(snapshotIds);
                ArrayList<com.amazonaws.services.ec2.model.Filter> awsFilters = new ArrayList<com.amazonaws.services.ec2.model.Filter>();
                awsFilters.add(awsFilter);
                DescribeSnapshotsRequest describeSnapshotsRequest = new DescribeSnapshotsRequest().withFilters(awsFilters);
                DescribeSnapshotsResult describeSnapshotsResult = ec2.describeSnapshots(describeSnapshotsRequest);
                HashMap<String, Snapshot> awsSnapshotMap = new HashMap<String, Snapshot>();
                for (Snapshot snapshot : describeSnapshotsResult.getSnapshots()) {
                    awsSnapshotMap.put(snapshot.getSnapshotId(), snapshot);
                }
                for (CloudStorageBackup backup : backups) {
                    if (awsSnapshotMap.containsKey(backup.getSnapshotId()) || !managedSnapshotMap.containsKey(backup.getSnapshotId())) continue;
                    ((CloudStorageBackupLocal)managedSnapshotMap.get(backup.getSnapshotId())).setRestoreStatus(RestoreStatus.unavailable.number());
                    backup.setRestoreStatus(RestoreStatus.unavailable.number());
                }
            }
        }
        return backups;
    }
}

