/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.validation.ContainerValidator;
import com.clustercontrol.cloud.validation.CustomEntityValidator;
import com.clustercontrol.cloud.validation.CustomMethodValidator;
import com.clustercontrol.cloud.validation.EntityValidator;
import com.clustercontrol.cloud.validation.MethodValidator;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.Validator;
import com.clustercontrol.cloud.validation.annotation.CustomMethodValidation;
import com.clustercontrol.cloud.validation.annotation.ValidatedBy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class MethodValidatorImpl
implements MethodValidator {
    private Map<Method, MethodValidator.MethodContext> validationContextMap = new HashMap<Method, MethodValidator.MethodContext>();
    private static Method initMethod;
    private static Method validateMethod;

    @Override
    public void validate(Method method, Object[] params, String group) throws ValidationFault {
        MethodValidator.MethodContext validationContext = this.getMethodContext(method);
        if (validationContext != null) {
            validationContext.validate(params, group);
            CustomMethodValidator cv = validationContext.getCustomMethodValidator();
            if (cv != null) {
                try {
                    this.getValidateMethod().invoke((Object)cv, method, params, group, validationContext);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ValidationFault) {
                        throw (ValidationFault)e.getCause();
                    }
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause());
                }
            }
        }
    }

    @Override
    public MethodValidator.MethodContext getMethodContext(Method method) {
        MethodValidator.MethodContext validationContext = this.validationContextMap.get(method);
        if (validationContext == null) {
            Logger logger = Logger.getLogger(MethodValidatorImpl.class);
            logger.debug((Object)("checking : " + method.getName()));
            MethodContextImpl mc = null;
            CustomMethodValidation c = method.getAnnotation(CustomMethodValidation.class);
            if (c != null) {
                mc = new MethodContextImpl();
                mc.setMethod(method);
                CustomMethodValidator cm = null;
                try {
                    Class<? extends CustomMethodValidator> cmClazz = c.value();
                    cm = cmClazz.newInstance();
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) {
                        throw (IllegalStateException)e;
                    }
                    throw new IllegalStateException(e);
                }
                mc.setMethodCustomValidator(cm);
            }
            if (method.getParameterAnnotations().length > 0 && mc == null) {
                mc = new MethodContextImpl();
                mc.setMethod(method);
            }
            StringBuilder elementIdBuilder = new StringBuilder();
            elementIdBuilder.append(Character.toLowerCase(method.getDeclaringClass().getSimpleName().charAt(0)) + method.getDeclaringClass().getSimpleName().substring(1));
            elementIdBuilder.append('.');
            elementIdBuilder.append(Character.toLowerCase(method.getName().charAt(0)) + method.getName().substring(1));
            for (Class<?> clazz : method.getParameterTypes()) {
                elementIdBuilder.append('_');
                elementIdBuilder.append(Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1));
            }
            String elementId = elementIdBuilder.toString();
            Annotation[][] annotationss = method.getParameterAnnotations();
            for (int i = 0; i < annotationss.length; ++i) {
                ArrayList<Validator> list = new ArrayList<Validator>();
                ArrayList<ContainerValidator> containerList = new ArrayList<ContainerValidator>();
                for (Annotation anno : annotationss[i]) {
                    logger.debug((Object)("annotation : " + anno.annotationType().getName()));
                    ValidatedBy vb = anno.annotationType().getAnnotation(ValidatedBy.class);
                    if (vb == null) continue;
                    Class<?> validatorClass = vb.value();
                    logger.debug((Object)("validator : " + validatorClass.getName()));
                    try {
                        Validator paramValidator = (Validator)validatorClass.newInstance();
                        this.getInitMethod().invoke((Object)paramValidator, anno);
                        if (paramValidator.getElementId() == null || paramValidator.getElementId().equals("")) {
                            paramValidator.setElementId(elementId + "." + i);
                        }
                        if (paramValidator instanceof ContainerValidator) {
                            containerList.add((ContainerValidator)paramValidator);
                            continue;
                        }
                        list.add(paramValidator);
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalStateException) {
                            throw (IllegalStateException)e;
                        }
                        throw new IllegalStateException(e);
                    }
                }
                ParamValidatorInfoImpl pvm = new ParamValidatorInfoImpl();
                pvm.setValidators(list.toArray(new Validator[0]));
                pvm.setContainerValidators(containerList.toArray(new ContainerValidator[0]));
                pvm.setType(method.getParameterTypes()[i]);
                mc.addPropValidator(pvm);
            }
            if (mc != null) {
                this.validationContextMap.put(method, mc);
            }
            validationContext = mc;
        }
        return validationContext;
    }

    private Method getInitMethod() {
        if (initMethod == null) {
            try {
                initMethod = Validator.class.getDeclaredMethod("init", Annotation.class);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return initMethod;
    }

    private Method getValidateMethod() {
        if (validateMethod == null) {
            try {
                validateMethod = CustomEntityValidator.class.getDeclaredMethod("validate", Object.class, EntityValidator.EntityContext.class);
            }
            catch (Exception e) {
                if (e instanceof IllegalStateException) {
                    throw (IllegalStateException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return validateMethod;
    }

    private static class MethodContextImpl
    implements MethodValidator.MethodContext {
        private Method method;
        private List<MethodValidator.ParamValidatorInfo> validatorList = new ArrayList<MethodValidator.ParamValidatorInfo>();
        private CustomMethodValidator customMethodValidator;

        private MethodContextImpl() {
        }

        @Override
        public Method method() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        @Override
        public CustomMethodValidator getCustomMethodValidator() {
            return this.customMethodValidator;
        }

        public void setMethodCustomValidator(CustomMethodValidator customMethodValidator) {
            this.customMethodValidator = customMethodValidator;
        }

        @Override
        public void validate(Object[] params, String group) throws ValidationFault {
            if (params.length != this.validatorList.size()) {
                throw new IllegalStateException();
            }
            for (int i = 0; i < this.validatorList.size(); ++i) {
                this.validatorList.get(0).validate(params[i], group);
            }
        }

        @Override
        public MethodValidator.ParamValidatorInfo[] getPropValidators() {
            return this.validatorList.toArray(new MethodValidator.ParamValidatorInfo[0]);
        }

        public void addPropValidator(MethodValidator.ParamValidatorInfo validator) {
            this.validatorList.add(validator);
        }
    }

    private static class ParamValidatorInfoImpl
    implements MethodValidator.ParamValidatorInfo {
        private Method validateMethod;
        private Validator<? extends Annotation, ?>[] validators;
        private TypeKind typeKind;
        private ContainerValidator<? extends Annotation, ?>[] containerValidators;

        private ParamValidatorInfoImpl() {
        }

        @Override
        public void validate(Object param, String group) throws ValidationFault {
            switch (this.typeKind) {
                case Array: 
                case List: {
                    try {
                        for (Validator<? extends Annotation, ?> validator : this.containerValidators) {
                            this.getValidateMethod().invoke(validator, param, group);
                        }
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof ValidationFault) {
                            throw (ValidationFault)e.getCause();
                        }
                        if (e.getCause() instanceof IllegalStateException) {
                            throw (IllegalStateException)e.getCause();
                        }
                        throw new IllegalStateException(e.getCause());
                    }
                }
            }
            block16: for (Validator<? extends Annotation, ?> validator : this.validators) {
                try {
                    switch (this.typeKind) {
                        case List: {
                            for (Object element : (List)param) {
                                this.getValidateMethod().invoke(validator, element, group);
                            }
                            continue block16;
                        }
                        case Array: {
                            for (Object element : (Object[])param) {
                                this.getValidateMethod().invoke(validator, element, group);
                            }
                            continue block16;
                        }
                        default: {
                            this.getValidateMethod().invoke(validator, param, group);
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof ValidationFault) {
                        throw (ValidationFault)e.getCause();
                    }
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause());
                }
            }
        }

        public void setValidators(Validator<?, ?>[] validators) {
            this.validators = validators;
        }

        public void setContainerValidators(ContainerValidator<?, ?>[] containerValidators) {
            this.containerValidators = containerValidators;
        }

        public void setType(Class<?> returnType) {
            this.typeKind = List.class.isAssignableFrom(returnType) ? TypeKind.List : (returnType.isArray() ? TypeKind.Array : TypeKind.Simple);
        }

        private Method getValidateMethod() {
            if (this.validateMethod == null) {
                try {
                    this.validateMethod = Validator.class.getDeclaredMethod("validate", Object.class, String.class);
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) {
                        throw (IllegalStateException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
            return this.validateMethod;
        }

        private static enum TypeKind {
            Simple,
            Array,
            List;

        }
    }
}

