/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ValidationMessages {
    private static final String RESOURCE_BUNDLE = "com.clustercontrol.cloud.validation.validation_messages";
    private static ResourceBundle m_bundle = ResourceBundle.getBundle("com.clustercontrol.cloud.validation.validation_messages");

    private ValidationMessages() {
    }

    public static ResourceBundle getBundle() {
        return m_bundle;
    }

    public static String getString(String key, Object ... args) {
        MessageFormat messageFormat = new MessageFormat(ValidationMessages.getString(key));
        return messageFormat.format(args);
    }

    public static String getString(String key) {
        try {
            return m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String key, String def) {
        try {
            return m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }

    public static String getString(String key, Object[] args, Locale locale) {
        return MessageFormat.format(ValidationMessages.getString(key, locale), args);
    }

    public static String getString(String key, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getString(String key, String def, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return def;
        }
    }
}

