/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.BillingAlarm;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateBillingAlarmRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarmService;
import com.clustercontrol.cloud.aws.presenter.Inventory;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BillingAlarmService
extends Element
implements IBillingAlarmService {
    private Inventory iv;
    private List<BillingAlarm> billingAlarms;

    public BillingAlarmService(Inventory iv) {
        this.iv = iv;
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.iv.getCloudResourceManager();
    }

    public Inventory getInventory() {
        return this.iv;
    }

    public BillingAlarm[] getBillingAlarms() {
        if (this.billingAlarms == null) {
            this.billingAlarms = new ArrayList<BillingAlarm>();
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            try {
                List bas = ce.getAllBillingAlarm();
                for (com.clustercontrol.ws.cloud.BillingAlarm ba : bas) {
                    BillingAlarm newBillingAlarm = BillingAlarm.createBillingAlarm(this, ba);
                    this.billingAlarms.add(newBillingAlarm);
                }
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
        return this.billingAlarms.toArray(new BillingAlarm[0]);
    }

    @Override
    public void update() {
        try {
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            List billindAlarms = ce.getAllBillingAlarm();
            this.internalUpdate(billindAlarms);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    public void internalUpdate(List<com.clustercontrol.ws.cloud.BillingAlarm> wsBillingAlarms) throws CloudModelException {
        ArrayList<BillingAlarm> billingAlarmsTemp = new ArrayList<BillingAlarm>(this.billingAlarms);
        ArrayList<com.clustercontrol.ws.cloud.BillingAlarm> wsBillingAlarmsTemp = new ArrayList<com.clustercontrol.ws.cloud.BillingAlarm>(wsBillingAlarms);
        Iterator wsBillingAlarmsIter = wsBillingAlarmsTemp.iterator();
        block0: while (wsBillingAlarmsIter.hasNext()) {
            com.clustercontrol.ws.cloud.BillingAlarm wsBa = (com.clustercontrol.ws.cloud.BillingAlarm)wsBillingAlarmsIter.next();
            Iterator billingAlarmsIter = billingAlarmsTemp.iterator();
            while (billingAlarmsIter.hasNext()) {
                BillingAlarm ba = (BillingAlarm)billingAlarmsIter.next();
                if (!wsBa.getAlarmId().equals(ba.getAlarmId())) continue;
                ba.internalUpdate(wsBa);
                billingAlarmsIter.remove();
                wsBillingAlarmsIter.remove();
                continue block0;
            }
        }
        for (BillingAlarm ba : billingAlarmsTemp) {
            this.billingAlarms.remove(ba);
            this.fireElementRemoved(IBillingAlarmService.p2.billingAlarms, ba);
        }
        for (com.clustercontrol.ws.cloud.BillingAlarm wsBillingAlarm : wsBillingAlarmsTemp) {
            BillingAlarm newBillingAlarm = BillingAlarm.createBillingAlarm(this, wsBillingAlarm);
            this.billingAlarms.add(newBillingAlarm);
            this.fireElementAdded(IBillingAlarmService.p2.billingAlarms, newBillingAlarm);
        }
    }

    @Override
    public BillingAlarm createBillingAlarm(CreateBillingAlarmRequest request) {
        BillingAlarm newBillingAlarm = null;
        try {
            com.clustercontrol.ws.cloud.BillingAlarm ba = new com.clustercontrol.ws.cloud.BillingAlarm();
            ba.setAlarmId(request.getAlarmId());
            ba.setAlarmName(request.getAlarmName());
            ba.setDescription(request.getDescription());
            ba.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_BILLING", (String)request.getAlarmId()));
            ba.setTarget(request.getTarget());
            ba.setThresholdInfoLimit(request.getThresholdInfoLimit());
            ba.setThresholdWarnLimit(request.getThresholdWarnLimit());
            ba.setValidFlg(request.isValidFlg());
            List<Object> notifies = Collections.emptyList();
            if (request.getNotifyRelationInfos() != null) {
                notifies = request.getNotifyRelationInfos();
            }
            ba.getNotifyRelationInfos().addAll(notifies);
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            com.clustercontrol.ws.cloud.BillingAlarm addedAlarm = ce.addBillingAlarm(ba);
            newBillingAlarm = BillingAlarm.createBillingAlarm(this, addedAlarm);
            this.billingAlarms.add(newBillingAlarm);
            this.fireElementAdded(IBillingAlarmService.p2.billingAlarms, newBillingAlarm);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return newBillingAlarm;
    }

    @Override
    public void deleteBillingAlarm(String alarmId) {
        try {
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            ce.removeBillingAlarm(alarmId);
            for (BillingAlarm billingAlarm : this.billingAlarms) {
                if (!alarmId.equals(billingAlarm.getAlarmId())) continue;
                this.billingAlarms.remove(billingAlarm);
                this.fireElementRemoved(IBillingAlarmService.p2.billingAlarms, billingAlarm);
                break;
            }
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }
}

