/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.cloud.aws.presenter.CacheService;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.HinemosService;
import com.clustercontrol.cloud.aws.presenter.IFacilityRoot;
import com.clustercontrol.cloud.aws.presenter.IScope;
import com.clustercontrol.cloud.aws.presenter.Node;
import com.clustercontrol.cloud.aws.presenter.RootScope;
import com.clustercontrol.cloud.aws.presenter.Scope;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FacilityRoot
extends Element
implements IFacilityRoot {
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private HinemosService hinemosService;
    private RootScope rootScope;

    public FacilityRoot(HinemosService hinemosService) {
        this.hinemosService = hinemosService;
        try {
            FacilityTreeItem fti = new FacilityTree().getTreeItem();
            List<FacilityTreeItem> roots = this.collectTopScope(fti);
            for (FacilityTreeItem root : roots) {
                if (!"AmazonWebService".equals(root.getData().getFacilityName())) continue;
                this.rootScope = new RootScope(this);
                this.rootScope.setName(root.getData().getFacilityName());
                this.rootScope.setFacilityId(root.getData().getFacilityId());
                this.rootScope.setScopeType(IScope.ScopeType.root);
                this.convertChildren(this.rootScope, root);
                break;
            }
            if (this.rootScope == null) {
                throw new CloudModelException(this.bundle_messages.getString("model.warning.not_found_root_scope"), "FacilityRoot.InvalidRootScope.NotFound");
            }
        }
        catch (Exception e) {
            throw new CloudModelException("faild to get repositry tree.", e);
        }
    }

    @Override
    public void update() throws CloudModelException {
        Logger logger;
        FacilityTreeItem fti = CacheService.getSingleton().get(this, FacilityTreeItem.class);
        if (fti == null) {
            try {
                fti = new FacilityTree().getTreeItem();
            }
            catch (Exception e) {
                logger = Logger.getLogger(this.getClass());
                logger.error((Object)"faild to get repositry tree.", (Throwable)e);
            }
        } else {
            CacheService.getSingleton().remove(this);
        }
        try {
            List<FacilityTreeItem> roots = this.collectTopScope(fti);
            FacilityTreeItem awsRoot = null;
            for (FacilityTreeItem root : roots) {
                if (!"AmazonWebService".equals(root.getData().getFacilityName())) continue;
                awsRoot = root;
                break;
            }
            if (awsRoot == null) {
                throw new CloudModelException(this.bundle_messages.getString("model.warning.not_found_root_scope"), "FacilityRoot.InvalidRootScope.NotFound");
            }
            ArrayList<Scope> regionScopes = new ArrayList<Scope>(Arrays.asList(this.rootScope.getScopes()));
            ArrayList treeItems = new ArrayList(awsRoot.getChildren());
            Iterator regionScopesIter = regionScopes.iterator();
            block5: while (regionScopesIter.hasNext()) {
                Scope regionScope = (Scope)regionScopesIter.next();
                Iterator treeItemIter = treeItems.iterator();
                while (treeItemIter.hasNext()) {
                    FacilityTreeItem treeItem = (FacilityTreeItem)treeItemIter.next();
                    FacilityInfo fi = treeItem.getData();
                    if (fi.getFacilityType() == 0) {
                        if (!fi.getFacilityId().equals(regionScope.getFacilityId())) continue;
                        regionScope.setName(fi.getFacilityName());
                        ArrayList<Scope> zoneScopes = new ArrayList<Scope>(Arrays.asList(regionScope.getScopes()));
                        ArrayList treeItems2 = new ArrayList(treeItem.getChildren());
                        Iterator zoneScopesIter = zoneScopes.iterator();
                        while (zoneScopesIter.hasNext()) {
                            Scope zoneScope = (Scope)zoneScopesIter.next();
                            Iterator treeItemIter2 = treeItems2.iterator();
                            while (treeItemIter2.hasNext()) {
                                FacilityTreeItem treeItem2 = (FacilityTreeItem)treeItemIter2.next();
                                FacilityInfo fi2 = treeItem2.getData();
                                if (fi2.getFacilityType() == 0) {
                                    if (!fi2.getFacilityId().equals(zoneScope.getFacilityId())) continue;
                                    zoneScope.setName(fi2.getFacilityName());
                                    ArrayList<Node> nodes = new ArrayList<Node>(Arrays.asList(zoneScope.getNodes()));
                                    ArrayList treeItems3 = new ArrayList(treeItem2.getChildren());
                                    Iterator nodesIter = nodes.iterator();
                                    while (nodesIter.hasNext()) {
                                        Node node = (Node)nodesIter.next();
                                        Iterator treeItemIter3 = treeItems3.iterator();
                                        while (treeItemIter3.hasNext()) {
                                            FacilityTreeItem treeItem3 = (FacilityTreeItem)treeItemIter3.next();
                                            FacilityInfo fi3 = treeItem3.getData();
                                            if (fi3.getFacilityType() == 1) {
                                                if (!fi3.getFacilityId().equals(node.getFacilityId())) continue;
                                                node.setName(fi3.getFacilityName());
                                                nodesIter.remove();
                                                treeItemIter3.remove();
                                                continue;
                                            }
                                            treeItemIter3.remove();
                                        }
                                    }
                                    for (Node node : nodes) {
                                        zoneScope.removeChildNode(node);
                                    }
                                    for (FacilityTreeItem treeItem3 : treeItems3) {
                                        this.convertChild(zoneScope, treeItem3);
                                    }
                                    zoneScopesIter.remove();
                                    treeItemIter2.remove();
                                    continue;
                                }
                                treeItemIter2.remove();
                            }
                        }
                        for (Scope zone : zoneScopes) {
                            regionScope.removeChildScope(zone);
                        }
                        for (FacilityTreeItem treeItem2 : treeItems2) {
                            this.convertChild(regionScope, treeItem2);
                        }
                        regionScopesIter.remove();
                        treeItemIter.remove();
                        continue block5;
                    }
                    treeItemIter.remove();
                }
            }
            for (Scope region : regionScopes) {
                this.rootScope.removeChildScope(region);
            }
            for (FacilityTreeItem treeItem : treeItems) {
                this.convertChild(this.rootScope, treeItem);
            }
        }
        catch (Exception e) {
            logger = Logger.getLogger(this.getClass());
            logger.error((Object)"faild to get repositry tree.", (Throwable)e);
        }
        super.update();
    }

    public Scope[] getScopes() {
        if (this.rootScope != null) {
            return new Scope[]{this.rootScope};
        }
        return new Scope[0];
    }

    public CloudResourceManager getCloudResourceManager() {
        return this.getHinemosService().getCloudResourceManager();
    }

    @Override
    public HinemosService getHinemosService() {
        return this.hinemosService;
    }

    private static Node convertNode(Scope parent, FacilityTreeItem fti) {
        Node node = new Node();
        node.setParent(parent);
        node.setName(fti.getData().getFacilityName());
        node.setFacilityId(fti.getData().getFacilityId());
        return node;
    }

    private Scope convertScope(Scope parent, IScope.ScopeType type, FacilityTreeItem fti) {
        try {
            FacilityInfo fi = fti.getData();
            assert (fi.getFacilityType() == 0) : "unexpected";
            Scope scope = new Scope();
            scope.setParent(parent);
            scope.setName(fi.getFacilityName());
            scope.setFacilityId(fti.getData().getFacilityId());
            scope.setScopeType(type);
            return scope;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void convertChildren(Scope scope, FacilityTreeItem fti) {
        for (FacilityTreeItem child : fti.getChildren()) {
            this.convertChild(scope, child);
        }
    }

    private void convertChild(Scope parent, FacilityTreeItem child) {
        switch (child.getData().getFacilityType()) {
            case 0: {
                IScope.ScopeType nextType = null;
                switch (parent.getScopeType()) {
                    case root: {
                        nextType = IScope.ScopeType.region;
                        break;
                    }
                    case region: {
                        nextType = IScope.ScopeType.availabilityZone;
                    }
                }
                if (nextType == null) break;
                Scope childScope = this.convertScope(parent, nextType, child);
                parent.addChildScope(childScope);
                this.convertChildren(childScope, child);
                break;
            }
            case 1: {
                if (parent.getScopeType() != IScope.ScopeType.availabilityZone) break;
                Node node = FacilityRoot.convertNode(parent, child);
                parent.addChildNode(node);
            }
        }
    }

    private static boolean isInternalScope(FacilityInfo facility) {
        return facility.getFacilityType() == 0 && ("REGISTERED".equals(facility.getFacilityId()) || "INTERNAL".equals(facility.getFacilityId()) || "UNREGISTERED".equals(facility.getFacilityId()));
    }

    private List<FacilityTreeItem> collectTopScope(FacilityTreeItem treeItem) {
        ArrayList<FacilityTreeItem> buf = new ArrayList<FacilityTreeItem>();
        return this.recursiveCollectTopScope(treeItem, buf);
    }

    private List<FacilityTreeItem> recursiveCollectTopScope(FacilityTreeItem treeItem, List<FacilityTreeItem> buf) {
        if (!this.isScope(treeItem.getData())) {
            for (FacilityTreeItem fti : treeItem.getChildren()) {
                this.recursiveCollectTopScope(fti, buf);
            }
        } else {
            buf.add(treeItem);
        }
        return buf;
    }

    private boolean isScope(FacilityInfo facility) {
        switch (facility.getFacilityType()) {
            case 0: {
                if (FacilityRoot.isInternalScope(facility)) break;
                return true;
            }
        }
        return false;
    }
}

