/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.CacheService;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateInstanceRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IInstanceRoot;
import com.clustercontrol.cloud.aws.presenter.Instance;
import com.clustercontrol.cloud.aws.presenter.Region;
import com.clustercontrol.cloud.aws.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.aws.resources.GroupIdentifier;
import com.clustercontrol.cloud.aws.resources.Tag;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import com.clustercontrol.ws.cloud.CreateInstanceByTemplateRequest;
import com.clustercontrol.ws.cloud.EbsBlockDevice;
import com.clustercontrol.ws.cloud.InstanceDetail;
import com.clustercontrol.ws.cloud.NodeDetail;
import com.clustercontrol.ws.cloud.RestoreInstanceRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class InstanceRoot
extends Element
implements IInstanceRoot {
    private Region region;
    private List<Instance> instances;

    public InstanceRoot(Region region) {
        this.region = region;
    }

    @Override
    public void update() throws CloudModelException {
        CloudInstance[] cloudInstanceArray = CacheService.getSingleton().get(this, CloudInstance[].class);
        List<CloudInstance> cloudInstances = Collections.emptyList();
        if (cloudInstanceArray == null) {
            try {
                CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
                cloudInstances = endpoint.getInstancesByRegion(this.getRegion().getRegionName());
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        } else {
            cloudInstances = Arrays.asList(cloudInstanceArray);
            CacheService.getSingleton().remove(this);
        }
        this.internalUpdate(cloudInstances);
        super.update();
    }

    public void internalUpdate(List<CloudInstance> cloudInstances) throws CloudModelException {
        if (this.isInitialized()) {
            ArrayList<Instance> instancesTemp = new ArrayList<Instance>(this.instances);
            ArrayList<CloudInstance> cloudInstancesTemp = new ArrayList<CloudInstance>(cloudInstances);
            Iterator cloudInstancesIter = cloudInstancesTemp.iterator();
            block0: while (cloudInstancesIter.hasNext()) {
                CloudInstance ci = (CloudInstance)cloudInstancesIter.next();
                Iterator instancesIter = instancesTemp.iterator();
                while (instancesIter.hasNext()) {
                    Instance i = (Instance)instancesIter.next();
                    if (!ci.getRegion().equals(i.getRegion().getRegionName()) || !ci.getInstanceId().equals(i.getInstanceId())) continue;
                    i.internalUpdate(ci);
                    instancesIter.remove();
                    cloudInstancesIter.remove();
                    continue block0;
                }
            }
            for (Instance i : instancesTemp) {
                this.getInstancesList().remove(i);
                this.fireElementRemoved(IInstanceRoot.p2.instances, i);
            }
            for (CloudInstance ci : cloudInstancesTemp) {
                Instance newInstance = Instance.createInstance(this, ci);
                this.getInstancesList().add(newInstance);
                this.fireElementAdded(IInstanceRoot.p2.instances, newInstance);
            }
        } else {
            ArrayList<Instance> tempInstances = new ArrayList<Instance>();
            for (CloudInstance instance : cloudInstances) {
                tempInstances.add(Instance.createInstance(this, instance));
            }
            this.instances = tempInstances;
        }
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public Instance[] getInstances() {
        return this.getInstancesList().toArray(new Instance[0]);
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.region.getCloudResourceManager();
    }

    @Override
    public IInstance createInstance(CreateInstanceRequest request) {
        Instance newInstance;
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        com.clustercontrol.ws.cloud.CreateInstanceRequest cir = new com.clustercontrol.ws.cloud.CreateInstanceRequest();
        cir.setNodeDetail(new NodeDetail());
        cir.setInstanceDetail(new InstanceDetail());
        cir.getNodeDetail().setFacilityId(request.facilityId);
        cir.getNodeDetail().setFacilityName(request.facilityName);
        cir.getNodeDetail().setNodeName(request.nodeName);
        cir.getNodeDetail().setDescription(request.description);
        cir.getNodeDetail().setReplaceNode(request.replaceNode);
        cir.setRegion(this.getRegion().getRegionName());
        cir.setImageId(request.image.getImageId());
        cir.setAvailabilityZone(request.availabilityZone != null ? request.availabilityZone.getZoneName() : null);
        cir.setSubnetId(request.subnet != null ? request.subnet.getSubnetId() : null);
        cir.getInstanceDetail().setInstanceType(request.instanceType);
        cir.getInstanceDetail().setKeyName(request.keyName);
        cir.getInstanceDetail().setInstanceInitiatedShutdownBehavior(request.instanceInitiatedShutdownBehavior);
        cir.getInstanceDetail().setDisableApiTermination(request.disableApiTermination);
        cir.getInstanceDetail().setEbsOptimized(request.ebsOptimized);
        cir.getInstanceDetail().setMonitoring(request.monitoring);
        for (GroupIdentifier gi : request.securityGroups) {
            cir.getInstanceDetail().getSecurityGroupIds().add(gi.getGroupId());
        }
        for (Tag tag : request.tags) {
            com.clustercontrol.ws.cloud.Tag t = new com.clustercontrol.ws.cloud.Tag();
            t.setName(tag.name);
            t.setValue(tag.value);
            cir.getInstanceDetail().getTags().add(t);
        }
        if (request.rootBlockDevice != null) {
            EbsBlockDevice device = new EbsBlockDevice();
            device.setVolumeSize(request.rootBlockDevice.volumeSize);
            device.setIops(request.rootBlockDevice.iops);
            device.setDeleteOnTermination(request.rootBlockDevice.deleteOnTermination);
            device.setVolumeType(request.rootBlockDevice.volumeType);
            cir.getInstanceDetail().setRootBlockDevice(device);
        }
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            CloudInstance cloudInstance = endpoint.addInstance(cir);
            newInstance = Instance.createInstance(this, cloudInstance);
            this.getInstancesList().add(newInstance);
            this.fireElementAdded(IInstanceRoot.p2.instances, newInstance);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return newInstance;
    }

    @Override
    public IInstance createInstance(CreateInstanceRequest request, String templateId, List<TemplateJobsArgument> arguments) {
        Instance newInstance;
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        CreateInstanceByTemplateRequest cloudRequest = new CreateInstanceByTemplateRequest();
        cloudRequest.setNodeDetail(new NodeDetail());
        cloudRequest.setInstanceDetail(new InstanceDetail());
        cloudRequest.getNodeDetail().setFacilityId(request.facilityId);
        cloudRequest.getNodeDetail().setFacilityName(request.facilityName);
        cloudRequest.getNodeDetail().setNodeName(request.nodeName);
        cloudRequest.getNodeDetail().setDescription(request.description);
        cloudRequest.getNodeDetail().setReplaceNode(request.replaceNode);
        cloudRequest.setAvailabilityZone(request.availabilityZone != null ? request.availabilityZone.getZoneName() : null);
        cloudRequest.setSubnetId(request.subnet != null ? request.subnet.getSubnetId() : null);
        cloudRequest.getInstanceDetail().setInstanceType(request.instanceType);
        cloudRequest.getInstanceDetail().setKeyName(request.keyName);
        cloudRequest.getInstanceDetail().setInstanceInitiatedShutdownBehavior(request.instanceInitiatedShutdownBehavior);
        cloudRequest.getInstanceDetail().setDisableApiTermination(request.disableApiTermination);
        cloudRequest.getInstanceDetail().setEbsOptimized(request.ebsOptimized);
        cloudRequest.getInstanceDetail().setMonitoring(request.monitoring);
        for (GroupIdentifier gi : request.securityGroups) {
            cloudRequest.getInstanceDetail().getSecurityGroupIds().add(gi.getGroupId());
        }
        for (Tag tag : request.tags) {
            com.clustercontrol.ws.cloud.Tag t = new com.clustercontrol.ws.cloud.Tag();
            t.setName(tag.name);
            t.setValue(tag.value);
            cloudRequest.getInstanceDetail().getTags().add(t);
        }
        if (request.rootBlockDevice != null) {
            EbsBlockDevice device = new EbsBlockDevice();
            device.setVolumeSize(request.rootBlockDevice.volumeSize);
            device.setIops(request.rootBlockDevice.iops);
            device.setDeleteOnTermination(request.rootBlockDevice.deleteOnTermination);
            device.setVolumeType(request.rootBlockDevice.volumeType);
            cloudRequest.getInstanceDetail().setRootBlockDevice(device);
        }
        cloudRequest.setTemplateId(templateId);
        List cloudArguments = cloudRequest.getArguments();
        if (arguments != null) {
            for (TemplateJobsArgument argument : arguments) {
                com.clustercontrol.ws.cloud.TemplateJobsArgument cloudArgument = new com.clustercontrol.ws.cloud.TemplateJobsArgument();
                cloudArgument.setJobId(argument.getJobId());
                cloudArgument.setArg(argument.getArg());
                cloudArguments.add(cloudArgument);
            }
        }
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            CloudInstance cloudInstance = endpoint.addInstanceByTemplate(cloudRequest);
            newInstance = Instance.createInstance(this, cloudInstance);
            this.getInstancesList().add(newInstance);
            this.fireElementAdded(IInstanceRoot.p2.instances, newInstance);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return newInstance;
    }

    @Override
    public void deleteInstance(String instanceId) {
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        try {
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            ce.removeInstance(this.getRegion().getRegionName(), instanceId);
            for (Instance instance : this.getInstancesList()) {
                if (!instanceId.equals(instance.getInstanceId())) continue;
                this.getInstancesList().remove(instance);
                this.fireElementRemoved(IInstanceRoot.p2.instances, instance);
                break;
            }
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void unregistNode(String instanceId) {
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        try {
            CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            ce.unregistNode(this.getRegion().getRegionName(), instanceId);
            for (Instance instance : this.getInstancesList()) {
                if (!instanceId.equals(instance.getInstanceId())) continue;
                this.getInstancesList().remove(instance);
                this.fireElementRemoved(IInstanceRoot.p2.instances, instance);
                break;
            }
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    public boolean isInitialized() {
        return this.instances != null;
    }

    private List<Instance> getInstancesList() {
        if (!this.isInitialized()) {
            this.update();
        }
        return this.instances;
    }

    @Override
    public Instance restore(CreateInstanceRequest request) {
        Instance newInstance;
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        CloudEndpoint coudEndpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
        RestoreInstanceRequest wsRequest = new RestoreInstanceRequest();
        wsRequest.setNodeDetail(new NodeDetail());
        wsRequest.getNodeDetail().setFacilityId(request.facilityId);
        wsRequest.getNodeDetail().setFacilityName(request.facilityName);
        wsRequest.getNodeDetail().setNodeName(request.nodeName);
        wsRequest.getNodeDetail().setDescription(request.description);
        wsRequest.getNodeDetail().setReplaceNode(request.replaceNode);
        wsRequest.setInstanceDetail(new InstanceDetail());
        wsRequest.getInstanceDetail().setInstanceType(request.instanceType);
        wsRequest.getInstanceDetail().setKeyName(request.keyName);
        wsRequest.getInstanceDetail().setDisableApiTermination(request.disableApiTermination);
        wsRequest.getInstanceDetail().setEbsOptimized(request.ebsOptimized);
        wsRequest.getInstanceDetail().setInstanceInitiatedShutdownBehavior(request.instanceInitiatedShutdownBehavior);
        wsRequest.getInstanceDetail().setMonitoring(request.monitoring);
        for (GroupIdentifier gi : request.securityGroups) {
            wsRequest.getInstanceDetail().getSecurityGroupIds().add(gi.getGroupId());
        }
        if (request.rootBlockDevice != null) {
            EbsBlockDevice device = new EbsBlockDevice();
            device.setDeleteOnTermination(request.rootBlockDevice != null ? request.rootBlockDevice.deleteOnTermination : null);
            device.setIops(request.rootBlockDevice != null ? request.rootBlockDevice.iops : null);
            device.setVolumeSize(request.rootBlockDevice != null ? request.rootBlockDevice.volumeSize : null);
            device.setVolumeType(request.rootBlockDevice != null ? request.rootBlockDevice.volumeType : null);
            wsRequest.getInstanceDetail().setRootBlockDevice(device);
        }
        wsRequest.setRegion(this.getRegion().getRegionName());
        wsRequest.setAvailabilityZone(request.availabilityZone != null ? request.availabilityZone.getZoneName() : null);
        wsRequest.setSubnetId(request.subnet != null ? request.subnet.getSubnetId() : null);
        wsRequest.setImageId(request.image != null ? request.image.getImageId() : null);
        try {
            CloudInstance cloudInstance = coudEndpoint.restoreInstance(wsRequest);
            newInstance = Instance.createInstance(this, cloudInstance);
            this.getInstancesList().add(newInstance);
            this.fireElementAdded(IInstanceRoot.p2.instances, newInstance);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return newInstance;
    }
}

