/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.BillingAlarmService;
import com.clustercontrol.cloud.aws.presenter.Category;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CollectionObserver2;
import com.clustercontrol.cloud.aws.presenter.EC2Service;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IBillingAlarmService;
import com.clustercontrol.cloud.aws.presenter.ICategory;
import com.clustercontrol.cloud.aws.presenter.IEC2Service;
import com.clustercontrol.cloud.aws.presenter.IFolder;
import com.clustercontrol.cloud.aws.presenter.IIdentity;
import com.clustercontrol.cloud.aws.presenter.IInventory;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.presenter.Identity;
import com.clustercontrol.cloud.aws.presenter.TemplateManagement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Inventory
extends Element
implements IInventory {
    private CollectionObserver2<IIdentity> identityObserver = new CollectionObserver2<IIdentity>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<IIdentity> event) {
            IIdentity element = event.getAddedElement();
            if (element.getHinemosUserId().equals(Inventory.this.cm.getAccountName())) {
                Inventory.this.credential = element;
            }
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<IIdentity> event) {
            IIdentity element = event.getRemovedElement();
            if (element.getHinemosUserId().equals(Inventory.this.cm.getAccountName())) {
                Inventory.this.credential = element;
            }
        }
    };
    private CloudResourceManager cm;
    private Map<Class<? extends IFolder>, IFolder> folders = new HashMap<Class<? extends IFolder>, IFolder>();
    private IIdentity credential;

    public Inventory(CloudResourceManager cm) {
        this.cm = cm;
        String currentId = cm.getAccountName();
        block0: for (Category c : this.cm.getIdentityManagement().getCategories()) {
            c.addPropertyObserver2(ICategory.p2.identities, this.identityObserver);
            for (Identity parent : c.getIdentities()) {
                parent.addPropertyObserver2(IIdentity.p2.identities, this.identityObserver);
                if (this.credential == null && parent.getHinemosUserId().equals(currentId)) {
                    this.credential = parent;
                    break block0;
                }
                for (Identity child : parent.getIdentities()) {
                    if (this.credential != null || !child.getHinemosUserId().equals(currentId)) continue;
                    this.credential = child;
                    break block0;
                }
            }
        }
        EC2Service ec2Service = new EC2Service(this);
        this.folders.put(IEC2Service.class, ec2Service);
        BillingAlarmService billingAlarmService = new BillingAlarmService(this);
        this.folders.put(IBillingAlarmService.class, billingAlarmService);
        TemplateManagement templateManagement = new TemplateManagement(this);
        this.folders.put(ITemplateManagement.class, templateManagement);
    }

    @Override
    public List<IFolder> getFolders() {
        return new ArrayList<IFolder>(this.folders.values());
    }

    @Override
    public boolean isAccessible() {
        return this.credential != null;
    }

    public CloudResourceManager getCloudResourceManager() {
        return this.cm;
    }

    @Override
    public IIdentity getCredential() {
        return this.credential;
    }

    @Override
    public <P extends IFolder> P getFolder(Class<P> clazz) {
        return (P)this.folders.get(clazz);
    }
}

