/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.CacheService;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.Region;
import com.clustercontrol.cloud.aws.presenter.StorageAttachment;
import com.clustercontrol.cloud.aws.presenter.StorageRoot;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudStorage;
import com.clustercontrol.ws.cloud.Tag;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class Storage
extends Element
implements IStorage {
    private StorageRoot root;
    private String storageId;
    private String storageName;
    private String storageType;
    private String storageKind;
    private String cloudId;
    private String cloudUserId;
    private String facilityId;
    private String facilityName;
    private Integer deviceIndex;
    private String state;
    private Integer size;
    private Integer iops;
    private String deviceType;
    private String deviceName;
    private String availabilityZone;
    private IStorage.RegistStateType registState;
    private StorageAttachment storageAttachment;
    private String snapshotId;
    private List<IStorage.Tag> tags;
    private Date regDate;
    private Date updateDate;
    private String regUser;
    private String updateUser;

    public Storage(StorageRoot root) {
        this.root = root;
    }

    @Override
    public StorageRoot getStorageRoot() {
        return this.root;
    }

    @Override
    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    @Override
    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    @Override
    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @Override
    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    @Override
    public String getCloudUserId() {
        return this.cloudUserId;
    }

    public void setCloudUserId(String cloudUserId) {
        this.cloudUserId = cloudUserId;
    }

    @Override
    public String getFacilityId() {
        return this.facilityId;
    }

    public void setFacilityId(String facilityId) {
        this.internalSet("facilityId", IStorage.p2.facilityId, facilityId);
    }

    @Override
    public Integer getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(Integer deviceIndex) {
        this.internalSet("deviceIndex", IStorage.p2.deviceIndex, deviceIndex);
    }

    @Override
    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.internalSet("deviceType", IStorage.p2.deviceType, deviceType);
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.internalSet("deviceName", IStorage.p2.deviceName, deviceName);
    }

    @Override
    public Region getRegion() {
        return this.getStorageRoot().getRegion();
    }

    @Override
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    @Override
    public IStorage.RegistStateType getRegistState() {
        return this.registState;
    }

    public void setRegistState(IStorage.RegistStateType registState) {
        this.registState = registState;
    }

    @Override
    public Date getRegDate() {
        return this.regDate;
    }

    public void setRegDate(Date regDate) {
        this.regDate = regDate;
    }

    @Override
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.internalSet("updateDate", IStorage.p2.updateDate, updateDate);
    }

    @Override
    public String getRegUser() {
        return this.regUser;
    }

    public void setRegUser(String regUser) {
        this.regUser = regUser;
    }

    @Override
    public String getUpdateUser() {
        return this.updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public void update() throws CloudModelException {
        CloudStorage cloudStorage = CacheService.getSingleton().get(this, CloudStorage.class);
        if (cloudStorage == null) {
            try {
                CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
                cloudStorage = endpoint.getStorage(this.getRegion().getRegionName(), this.getStorageId());
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(this.getClass());
                logger.error((Object)"faild to get repositry tree.", (Throwable)e);
            }
        } else {
            CacheService.getSingleton().remove(this);
        }
        if (cloudStorage != null) {
            this.internalUpdate(cloudStorage);
        }
        super.update();
    }

    public void internalUpdate(CloudStorage cloudStorage) {
        this.overwriteByCloudStorage(cloudStorage);
    }

    public static Storage createStorage(StorageRoot root, CloudStorage cloudStorage) {
        Storage newStorage = new Storage(root);
        newStorage.overwriteByCloudStorage(cloudStorage);
        return newStorage;
    }

    protected void overwriteByCloudStorage(CloudStorage cloudStorage) {
        this.setStorageId(cloudStorage.getStorageId());
        this.setStorageType(cloudStorage.getStorageType());
        this.setStorageKind(cloudStorage.getStorageKind());
        this.setStorageName(cloudStorage.getStorageName());
        this.setState(cloudStorage.getState());
        this.setSnapshotId(cloudStorage.getSnapshotId());
        this.setSize(cloudStorage.getSize());
        this.setIops(cloudStorage.getIops());
        this.setCloudId(cloudStorage.getCloudId());
        this.setCloudUserId(cloudStorage.getCloudUserId());
        this.setDeviceIndex(cloudStorage.getDeviceIndex());
        this.setDeviceType(cloudStorage.getDeviceType());
        this.setDeviceName(cloudStorage.getDeviceName());
        this.setFacilityId(cloudStorage.getFacilityId());
        this.setFacilityName(cloudStorage.getFacilityName());
        this.setAvailabilityZone(cloudStorage.getAvailabilityZone());
        this.setRegistState(IStorage.RegistStateType.valueOf(cloudStorage.getRegistState().value()));
        ArrayList<IStorage.Tag> tags = new ArrayList<IStorage.Tag>();
        for (Tag t : cloudStorage.getTags()) {
            tags.add(new IStorage.Tag(t.getName(), t.getValue()));
        }
        this.setTags(tags);
        this.setRegDate(cloudStorage.getRegDate() != null ? new Date(cloudStorage.getRegDate()) : null);
        this.setUpdateDate(cloudStorage.getUpdateDate() != null ? new Date(cloudStorage.getUpdateDate()) : null);
        this.setRegUser(cloudStorage.getRegUser());
        this.setUpdateUser(cloudStorage.getUpdateUser());
        if (cloudStorage.getStorageAttachment() != null) {
            com.clustercontrol.ws.cloud.StorageAttachment wsVa = cloudStorage.getStorageAttachment();
            StorageAttachment va = new StorageAttachment(wsVa.getInstanceId(), wsVa.getDevice(), wsVa.getState(), wsVa.isDeleteOnTerminate(), wsVa.getAttachTime() == null ? null : new Date(wsVa.getAttachTime()));
            this.setStorageAttachment(va);
        } else {
            this.setStorageAttachment(null);
        }
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    @Override
    public Integer getIops() {
        return this.iops;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    @Override
    public StorageAttachment getStorageAttachment() {
        return this.storageAttachment;
    }

    public void setStorageAttachment(StorageAttachment storageAttachment) {
        this.internalSet("storageAttachment", IStorage.p2.storageAttachment, storageAttachment);
    }

    @Override
    public void attachInstance(String instanceId, String deviceName) {
        try {
            this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).attachStorage(this.getRegion().getRegionName(), instanceId, this.getStorageId(), deviceName);
            this.update();
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void detachInstance() {
        if (this.getStorageAttachment() != null) {
            try {
                this.getCloudResourceManager().getEndpoint(CloudEndpoint.class).detachStorage(this.getRegion().getRegionName(), this.getStorageAttachment().getInstanceId(), this.getStorageId());
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        }
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.getRegion().getCloudResourceManager();
    }

    @Override
    public String getStorageKind() {
        return this.storageKind;
    }

    public void setStorageKind(String storageKind) {
        this.storageKind = storageKind;
    }

    @Override
    public String getFacilityName() {
        return this.facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.internalSet("facilityName", IStorage.p2.facilityName, facilityName);
    }

    @Override
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.internalSet("state", IStorage.p2.state, state);
    }

    @Override
    public List<IStorage.Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<IStorage.Tag> tags) {
        this.internalSet("tags", IStorage.p2.tags, tags);
    }
}

