/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.presenter.StorageBackupRoot;
import com.clustercontrol.ws.cloud.CloudStorageBackup;
import java.util.Date;

public class StorageBackup
extends Element
implements IStorageBackup {
    StorageBackupRoot root;
    CloudStorageBackup cloudStorageBackup;
    private IStorageBackup.ExistStatusType existStatus;

    private StorageBackup(StorageBackupRoot root) {
        this.root = root;
    }

    @Override
    public StorageBackupRoot getStorageBackupRoot() {
        return this.root;
    }

    @Override
    public String getSnapshotId() {
        return this.cloudStorageBackup.getSnapshotId();
    }

    @Override
    public String getSnapshotName() {
        return this.cloudStorageBackup.getSnapshotName();
    }

    @Override
    public String getCloudId() {
        return this.cloudStorageBackup.getCloudId();
    }

    @Override
    public String getDescription() {
        return this.cloudStorageBackup.getDescription();
    }

    @Override
    public String getVolumeId() {
        return this.cloudStorageBackup.getStorageId();
    }

    @Override
    public String getRegion() {
        return this.cloudStorageBackup.getRegion();
    }

    @Override
    public String getAvailabilityZone() {
        return this.cloudStorageBackup.getAvailabilityZone();
    }

    @Override
    public IStorageBackup.ExistStatusType getExistsStatus() {
        return this.existStatus;
    }

    @Override
    public Integer getStorageSize() {
        return this.cloudStorageBackup.getStorageSize();
    }

    @Override
    public Date getRegDate() {
        return new Date(this.cloudStorageBackup.getRegDate());
    }

    @Override
    public String getRegUser() {
        return this.cloudStorageBackup.getRegUser();
    }

    public void setVolumeId(String volumeId) {
        this.cloudStorageBackup.setStorageId(volumeId);
    }

    public void setExistsStatus(IStorageBackup.ExistStatusType status) {
        this.internalSet("existStatus", IStorageBackup.p2.existStatus, status);
    }

    public static StorageBackup createStorageBackup(StorageBackupRoot root, CloudStorageBackup cloudStorageBackup) {
        StorageBackup storageBackup = new StorageBackup(root);
        storageBackup.overwriteByCloudStorageBackup(cloudStorageBackup);
        return storageBackup;
    }

    public void internalUpdate(CloudStorageBackup cloudStorageBackup) {
        this.overwriteByCloudStorageBackup(cloudStorageBackup);
    }

    public void overwriteByCloudStorageBackup(CloudStorageBackup cloudStorageBackup) {
        this.cloudStorageBackup = cloudStorageBackup;
        this.setExistsStatus(cloudStorageBackup.getRestoreStatus() != null ? IStorageBackup.ExistStatusType.byNumber(cloudStorageBackup.getRestoreStatus()) : null);
    }

    @Override
    public String getStorageName() {
        return this.cloudStorageBackup.getStorageName();
    }
}

