/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.cloud.aws.presenter.CacheService;
import com.clustercontrol.cloud.aws.presenter.CloudModelException;
import com.clustercontrol.cloud.aws.presenter.CloudResourceManager;
import com.clustercontrol.cloud.aws.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.aws.presenter.Element;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.aws.presenter.IStorageRoot;
import com.clustercontrol.cloud.aws.presenter.Region;
import com.clustercontrol.cloud.aws.presenter.Storage;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class StorageRoot
extends Element
implements IStorageRoot {
    private Region region;
    private List<Storage> storages;

    public StorageRoot(Region region) {
        this.region = region;
    }

    @Override
    public void update() throws CloudModelException {
        CloudStorage[] cloudStorageArray = CacheService.getSingleton().get(this, CloudStorage[].class);
        List<CloudStorage> cloudStorages = Collections.emptyList();
        if (cloudStorageArray == null) {
            try {
                CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
                cloudStorages = endpoint.getStoragesByRegion(this.getRegion().getRegionName());
            }
            catch (Exception e) {
                throw new CloudModelException(e);
            }
        } else {
            cloudStorages = Arrays.asList(cloudStorageArray);
            CacheService.getSingleton().remove(this);
        }
        this.internalUpdate(cloudStorages);
        super.update();
    }

    public void internalUpdate(List<CloudStorage> cloudStorages) throws CloudModelException {
        if (this.isInitialized()) {
            ArrayList<Storage> storagesTemp = new ArrayList<Storage>(this.storages);
            ArrayList<CloudStorage> cloudStoragesTemp = new ArrayList<CloudStorage>(cloudStorages);
            Iterator cloudStoragesIter = cloudStoragesTemp.iterator();
            block0: while (cloudStoragesIter.hasNext()) {
                CloudStorage cs = (CloudStorage)cloudStoragesIter.next();
                Iterator storagesIter = storagesTemp.iterator();
                while (storagesIter.hasNext()) {
                    Storage s = (Storage)storagesIter.next();
                    if (!cs.getRegion().equals(s.getRegion().getRegionName()) || !cs.getStorageId().equals(s.getStorageId())) continue;
                    s.internalUpdate(cs);
                    storagesIter.remove();
                    cloudStoragesIter.remove();
                    continue block0;
                }
            }
            for (Storage s : storagesTemp) {
                this.getInstancesList().remove(s);
                this.fireElementRemoved(IStorageRoot.p2.storages, s);
            }
            for (CloudStorage cs : cloudStoragesTemp) {
                Storage newInstance = Storage.createStorage(this, cs);
                this.getInstancesList().add(newInstance);
                this.fireElementAdded(IStorageRoot.p2.storages, newInstance);
            }
        } else {
            ArrayList<Storage> tempStorages = new ArrayList<Storage>();
            for (CloudStorage instance : cloudStorages) {
                tempStorages.add(Storage.createStorage(this, instance));
            }
            this.storages = tempStorages;
        }
    }

    public Storage[] getStorages() {
        return this.getInstancesList().toArray(new Storage[0]);
    }

    @Override
    public CloudResourceManager getCloudResourceManager() {
        return this.region.getCloudResourceManager();
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public Storage createStorage(CreateStorageRequest request) {
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        com.clustercontrol.ws.cloud.CreateStorageRequest csr = new com.clustercontrol.ws.cloud.CreateStorageRequest();
        csr.setRegion(this.getRegion().getRegionName());
        csr.setAvailabilityZone(request.getAvailabilityZone());
        csr.setSnapshotId(request.getSnapshotId());
        csr.setStorageName(request.getStorageName());
        csr.setStorageSize(request.getStorageSize());
        csr.setStorageKind(request.getStorageKind());
        csr.setIops(request.getIops());
        Storage newStorage = null;
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            CloudStorage cloudStorage = endpoint.addStorage(csr);
            newStorage = Storage.createStorage(this, cloudStorage);
            this.storages.add(newStorage);
            this.fireElementAdded(IStorageRoot.p2.storages, newStorage);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return newStorage;
    }

    @Override
    public IStorage restore(CreateStorageRequest request) {
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        com.clustercontrol.ws.cloud.CreateStorageRequest csr = new com.clustercontrol.ws.cloud.CreateStorageRequest();
        csr.setRegion(this.getRegion().getRegionName());
        csr.setSnapshotId(request.getSnapshotId());
        csr.setAvailabilityZone(request.getAvailabilityZone());
        csr.setStorageName(request.getStorageName());
        csr.setStorageSize(request.getStorageSize());
        csr.setStorageKind(request.getStorageKind());
        csr.setIops(request.getIops());
        Storage newStorage = null;
        try {
            CloudEndpoint endpoint = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
            CloudStorage cloudStorage = endpoint.restoreStorage(csr);
            newStorage = Storage.createStorage(this, cloudStorage);
            this.storages.add(newStorage);
            this.fireElementAdded(IStorageRoot.p2.storages, newStorage);
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
        return newStorage;
    }

    @Override
    public void deleteStorage(String storageId) {
        if (!this.isInitialized()) {
            this.getInstancesList();
        }
        CloudEndpoint ce = this.getCloudResourceManager().getEndpoint(CloudEndpoint.class);
        try {
            ce.removeStorage(this.getRegion().getRegionName(), storageId);
            for (Storage storage : this.storages) {
                if (!storage.getStorageId().equals(storageId)) continue;
                this.storages.remove(storage);
                this.fireElementRemoved(IStorageRoot.p2.storages, storage);
                break;
            }
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    public boolean isInitialized() {
        return this.storages != null;
    }

    private List<Storage> getInstancesList() {
        if (!this.isInitialized()) {
            this.update();
        }
        return this.storages;
    }
}

