/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.presenter;

import com.clustercontrol.ws.repository.FacilityInfo;
import com.clustercontrol.ws.repository.FacilityTreeItem;
import com.clustercontrol.ws.repository.RepositoryEndpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WrappedFacilityTreeItem {
    private List<WrappedFacilityTreeItem> children;
    private FacilityInfo data;
    private FacilityTreeItem facilityTreeItem;
    private WrappedFacilityTreeItem parent;
    private RepositoryEndpoint endpoint;
    private Map<String, FacilityInfo> nodeMap;

    public WrappedFacilityTreeItem(WrappedFacilityTreeItem parent, FacilityTreeItem facilityTreeItem, RepositoryEndpoint endpoint) {
        assert (facilityTreeItem != null);
        this.parent = parent;
        this.facilityTreeItem = facilityTreeItem;
        this.endpoint = endpoint;
    }

    public List<WrappedFacilityTreeItem> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<WrappedFacilityTreeItem>();
            for (FacilityTreeItem child : this.facilityTreeItem.getChildren()) {
                this.children.add(new WrappedFacilityTreeItem(this, child, this.endpoint));
            }
        }
        return this.children;
    }

    public FacilityInfo getData() {
        if (this.data == null) {
            switch (this.facilityTreeItem.getData().getFacilityType()) {
                case 0: {
                    this.data = this.facilityTreeItem.getData();
                    break;
                }
                case 1: {
                    FacilityInfo fi = this.facilityTreeItem.getData();
                    this.data = this.getNodeMap().get(fi.getFacilityId());
                    if (this.data != null) break;
                    try {
                        this.data = this.endpoint.getNode(this.facilityTreeItem.getData().getFacilityId());
                        this.getNodeMap().put(fi.getFacilityId(), this.data);
                    }
                    catch (Exception e) {
                        Logger logger = Logger.getLogger(WrappedFacilityTreeItem.class);
                        logger.warn((Object)("faild to get NodeInfo of " + fi.getFacilityId() + "."));
                    }
                    break;
                }
                default: {
                    this.data = this.facilityTreeItem.getData();
                }
            }
        }
        return this.data;
    }

    public WrappedFacilityTreeItem getParent() {
        return this.parent;
    }

    protected Map<String, FacilityInfo> getNodeMap() {
        Map<String, FacilityInfo> lnodeMap;
        if (this.parent == null) {
            if (this.nodeMap == null) {
                this.nodeMap = new HashMap<String, FacilityInfo>();
            }
            lnodeMap = this.nodeMap;
        } else {
            lnodeMap = this.parent.getNodeMap();
        }
        return lnodeMap;
    }
}

