/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.commons.util;

import com.clustercontrol.cloud.commons.util.Asn1Object;
import com.clustercontrol.cloud.commons.util.DerParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.EncodedKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;

public class KeyCodec {
    private String cipherAlgorithm = "RSA";
    private String cipherMode = "/ECB/PKCS1PADDING";
    private Cipher cipher;
    private KeyFactory keyFactory;
    private Key encryptSecretKey;
    private Key decryptSecretKey;
    private Key encryptPublicKey;
    private Key decryptPublicKey;

    public KeyCodec() {
        try {
            this.updateCipher();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCipherAlgorithm(String cipherAlgorithm) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.cipherMode = "";
        try {
            this.updateCipher();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCipherAlgorithm(String cipherAlgorithm, String cipherMode) {
        this.cipherAlgorithm = cipherAlgorithm;
        this.cipherMode = cipherMode;
        try {
            this.updateCipher();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCipherMode(String cipherMode) {
        this.cipherMode = cipherMode;
        try {
            this.updateCipher();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPrivateKeyFile(String privateKeyFile) throws Exception {
        RSAPrivateCrtKeySpec keySpec = this.getRSAKeySpec(KeyCodec.loadBinaryFile(privateKeyFile));
        this.decryptSecretKey = this.keyFactory.generatePrivate(keySpec);
    }

    public void setPublicKeyFile(String publicKeyFile) throws Exception {
        try {
            EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(KeyCodec.loadBinaryFile(publicKeyFile));
            this.encryptPublicKey = this.keyFactory.generatePublic(keyspec);
            keyspec = new X509EncodedKeySpec(KeyCodec.loadBinaryFile(publicKeyFile));
            this.decryptPublicKey = this.keyFactory.generatePublic(keyspec);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(this.cipherAlgorithm + this.cipherMode);
        this.keyFactory = KeyFactory.getInstance(this.cipherAlgorithm);
    }

    public byte[] encryptWithPrivateKey(byte[] source) {
        try {
            if (this.encryptSecretKey == null) {
                throw new RuntimeException("Secret key is not set.");
            }
            this.cipher.init(1, this.encryptSecretKey);
            return this.cipher.doFinal(source);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decryptWithPrivateKey(byte[] source) {
        try {
            if (this.decryptSecretKey == null) {
                throw new RuntimeException("Secret key is not set.");
            }
            this.cipher.init(2, this.decryptSecretKey);
            return this.cipher.doFinal(source);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] encryptWithPublicKey(byte[] source) {
        try {
            if (this.encryptPublicKey == null) {
                throw new RuntimeException("Public key is not set.");
            }
            this.cipher.init(1, this.encryptPublicKey);
            return this.cipher.doFinal(source);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] decryptWithPublicKey(byte[] source) {
        try {
            if (this.decryptPublicKey == null) {
                throw new RuntimeException("Public key is not set.");
            }
            this.cipher.init(2, this.decryptPublicKey);
            return this.cipher.doFinal(source);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] loadBinaryFile(String fileName) throws Exception {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(new File(fileName)));
            StringBuilder sb = new StringBuilder();
            boolean isContents = false;
            while ((line = br.readLine()) != null) {
                if (line.matches("[-]+BEGIN[ A-Z]+[-]+")) {
                    isContents = true;
                    continue;
                }
                if (line.matches("[-]+END[ A-Z]+[-]+")) {
                    isContents = false;
                    continue;
                }
                if (!isContents) continue;
                sb.append(line);
                sb.append("\n");
            }
            return KeyCodec.getBase64Binary(sb.toString());
        }
        catch (FileNotFoundException e) {
            throw new Exception("File not found.", e);
        }
        catch (IOException e) {
            throw new Exception("can't read the PEM file.", e);
        }
    }

    public static byte[] getBase64Binary(String word) {
        return Base64.decodeBase64((byte[])word.getBytes());
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public String getCipherMode() {
        return this.cipherMode;
    }

    private RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        return keySpec;
    }
}

