/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.AvailableDevice;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class AttachStorageDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
    private Text availabilityZone;
    private Combo comboInstance;
    private Table tblVolume;
    private TableViewer tableViewer;
    private Combo device;
    private IStorage storage;
    private String instanceId;
    private String deviceName;

    public AttachStorageDialog(Shell parentShell, IStorage storage) {
        super(parentShell);
        this.storage = storage;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    protected Control createDialogArea(Composite parent) {
        this.storage.update();
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(5, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblAvailabilityZone = new Label(container, 0);
        lblAvailabilityZone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailabilityZone.setText(this.bundle_dialog_label.getString("dialog.attach_storage.availability_zone_title"));
        this.availabilityZone = new Text(container, 8);
        this.availabilityZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.availabilityZone.setText(this.storage.getAvailabilityZone());
        new Label(container, 0);
        new Label(container, 0);
        Label lblInstance = new Label(container, 0);
        lblInstance.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstance.setText(this.bundle_dialog_label.getString("dialog.attach_storage.instance_title"));
        this.comboInstance = new Combo(container, 8);
        this.comboInstance.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IInstance instance = (IInstance)AttachStorageDialog.this.comboInstance.getData(AttachStorageDialog.this.comboInstance.getText());
                AttachStorageDialog.this.instanceId = instance.getInstanceId();
                ArrayList<IStorage> storages = new ArrayList<IStorage>();
                for (IStorage s : AttachStorageDialog.this.storage.getStorageRoot().getStorages()) {
                    if (!AttachStorageDialog.this.instanceId.equals(s.getStorageAttachment() == null ? null : s.getStorageAttachment().getInstanceId())) continue;
                    storages.add(s);
                }
                AttachStorageDialog.this.updateSelection(storages);
            }
        });
        GridData gd_instance = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_instance.widthHint = 199;
        this.comboInstance.setLayoutData((Object)gd_instance);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblVolumeType = new Label(container, 0);
        lblVolumeType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeType.setText(this.bundle_dialog_label.getString("dialog.attach_storage.volume_type_title"));
        Combo volumeType = new Combo(container, 0);
        volumeType.setEnabled(false);
        GridData gd_volumeType = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_volumeType.widthHint = 226;
        volumeType.setLayoutData((Object)gd_volumeType);
        volumeType.setText(this.bundle_volume_type.getString(this.storage.getStorageKind().toString()));
        Label lblVolumeSize = new Label(container, 0);
        GridData gd_lblVolumeSize = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblVolumeSize.widthHint = 83;
        lblVolumeSize.setLayoutData((Object)gd_lblVolumeSize);
        lblVolumeSize.setText(this.bundle_dialog_label.getString("dialog.attach_storage.volume_size_title"));
        Spinner volumeSize = new Spinner(container, 2048);
        volumeSize.setEnabled(false);
        GridData gd_volumeSize = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_volumeSize.widthHint = 134;
        volumeSize.setLayoutData((Object)gd_volumeSize);
        volumeSize.setSelection(this.storage.getSize().intValue());
        Label lblGib = new Label(container, 0);
        GridData gd_lblGib = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblGib.widthHint = 55;
        lblGib.setLayoutData((Object)gd_lblGib);
        lblGib.setText("GiB");
        Label lblIops = new Label(container, 0);
        lblIops.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIops.setText(this.bundle_dialog_label.getString("dialog.attach_storage.iops_title"));
        Combo iops = new Combo(container, 0);
        iops.setEnabled(false);
        GridData gd_iops = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_iops.widthHint = 122;
        iops.setLayoutData((Object)gd_iops);
        if (this.storage.getIops() != null) {
            iops.setText(String.valueOf(this.storage.getIops()));
        }
        Label lblDeleteOnTermination = new Label(container, 0);
        lblDeleteOnTermination.setText(this.bundle_dialog_label.getString("dialog.attach_storage.delete_on_termination_title"));
        Button btnDeleteOnTermination = new Button(container, 32);
        btnDeleteOnTermination.setEnabled(false);
        btnDeleteOnTermination.setAlignment(0x1000000);
        new Label(container, 0);
        if (this.storage.getStorageAttachment() != null && this.storage.getStorageAttachment().isDeleteOnTerminate()) {
            btnDeleteOnTermination.setSelection(true);
        }
        Label lblSnapshot = new Label(container, 0);
        lblSnapshot.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSnapshot.setText(this.bundle_dialog_label.getString("dialog.attach_storage.snapshot_title"));
        Combo snapshot = new Combo(container, 0);
        snapshot.setEnabled(false);
        snapshot.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        snapshot.setText(this.storage.getSnapshotId());
        Label lblDevice = new Label(container, 0);
        lblDevice.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDevice.setText(this.bundle_dialog_label.getString("dialog.attach_storage.device_title"));
        this.device = new Combo(container, 8);
        GridData gd_device = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_device.widthHint = 242;
        this.device.setLayoutData((Object)gd_device);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.tblVolume = new Table(container, 0x10010800);
        this.tblVolume.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
            }
        });
        this.tblVolume.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttachStorageDialog.this.tblVolume.select(-1);
            }
        });
        this.tblVolume.setLayoutData((Object)new GridData(4, 4, true, true, 5, 1));
        this.tblVolume.setHeaderVisible(true);
        this.tblVolume.setLinesVisible(true);
        TableColumn tblclmnType = new TableColumn(this.tblVolume, 0);
        tblclmnType.setWidth(100);
        tblclmnType.setText(this.bundle_dialog_label.getString("dialog.attach_storage.column.storage_id"));
        TableColumn tblclmnDevice = new TableColumn(this.tblVolume, 0);
        tblclmnDevice.setWidth(100);
        tblclmnDevice.setText(this.bundle_dialog_label.getString("dialog.attach_storage.column.device"));
        TableColumn tblclmnSnapshotId = new TableColumn(this.tblVolume, 0);
        tblclmnSnapshotId.setWidth(100);
        tblclmnSnapshotId.setText(this.bundle_dialog_label.getString("dialog.attach_storage.column.snapshot_id"));
        TableColumn tblclmnSize = new TableColumn(this.tblVolume, 0);
        tblclmnSize.setWidth(100);
        tblclmnSize.setText(this.bundle_dialog_label.getString("dialog.attach_storage.column.size"));
        TableColumn tblclmnVolumeType = new TableColumn(this.tblVolume, 0);
        tblclmnVolumeType.setWidth(100);
        tblclmnVolumeType.setText(this.bundle_dialog_label.getString("dialog.attach_storage.column.volume_type"));
        TableColumn tblclmnIops = new TableColumn(this.tblVolume, 0);
        tblclmnIops.setWidth(100);
        tblclmnIops.setText(this.bundle_dialog_label.getString("dialog.attach_storage.column.iops"));
        TableColumn tblclmnDeleteOnTermination = new TableColumn(this.tblVolume, 0);
        tblclmnDeleteOnTermination.setWidth(142);
        tblclmnDeleteOnTermination.setText(this.bundle_dialog_label.getString("dialog.attach_storage.column.delete_on_termination"));
        this.tableViewer = new TableViewer(this.tblVolume);
        VolumeProvider vp = new VolumeProvider();
        this.tableViewer.setContentProvider((IContentProvider)vp.getVolumeContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)vp.getVolumeLabelProvider());
        this.storage.getRegion().getInstanceRoot().update();
        for (IInstance instance : this.storage.getRegion().getInstanceRoot().getInstances()) {
            if (!instance.getAvailabilityZone().equals(this.storage.getAvailabilityZone()) || instance.getRegistState() == IInstance.RegistStateType.deleted) continue;
            this.comboInstance.setData(instance.getInstanceId(), (Object)instance);
            this.comboInstance.add(instance.getInstanceId());
        }
        if (this.comboInstance.getItemCount() > 0) {
            this.comboInstance.select(0);
        }
        return area;
    }

    protected void updateSelection(Object o) {
        this.tableViewer.setInput(o);
        this.device.removeAll();
        for (AvailableDevice ad : AvailableDevice.values()) {
            Boolean b = true;
            for (IStorage storage : (List)o) {
                if (!ad.toString().equals(storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : null)) continue;
                b = false;
                break;
            }
            if (!b.booleanValue()) continue;
            this.device.add(ad.toString());
        }
        if (this.device.getItemCount() > 0) {
            this.device.select(0);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected void okPressed() {
        if (this.instanceId == null || "".equals(this.device.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        this.deviceName = this.device.getText();
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("attach_storage"));
    }

    public static class VolumeProvider {
        private VolumeContentProvider vcp = new VolumeContentProvider();
        private VolumeLabelProvider vlp = new VolumeLabelProvider();

        public VolumeContentProvider getVolumeContentProvider() {
            return this.vcp;
        }

        public VolumeLabelProvider getVolumeLabelProvider() {
            return this.vlp;
        }

        public class VolumeLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getColumnText(Object element, int columnIndex) {
                IStorage storage = (IStorage)element;
                Boolean b1 = false;
                Boolean b2 = false;
                if (storage.getStorageAttachment() != null) {
                    b1 = true;
                    Pattern p = Pattern.compile("/dev/sda.*");
                    Matcher m = p.matcher(storage.getStorageAttachment().getDevice());
                    if (m.find()) {
                        b2 = true;
                    }
                }
                switch (columnIndex) {
                    case 0: {
                        return storage.getStorageId();
                    }
                    case 1: {
                        return b1.booleanValue() ? (storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "") : "";
                    }
                    case 2: {
                        return storage.getSnapshotId() != null ? storage.getSnapshotId() : "";
                    }
                    case 3: {
                        return storage.getSize() != null ? String.valueOf(storage.getSize()) : "";
                    }
                    case 4: {
                        return b2 != false ? "Root" : "EBS";
                    }
                    case 5: {
                        return storage.getIops() != null ? String.valueOf(storage.getIops()) : "";
                    }
                    case 6: {
                        return storage.getStorageAttachment() != null ? Boolean.toString(storage.getStorageAttachment().isDeleteOnTerminate()) : "";
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        }

        public class VolumeContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

