/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateInstanceBackupDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private IInstance instance;
    private Text txtImageName;
    private Text txtImageDescription;
    private Text txtInstanceId;
    private Button btnNoReboot;
    private Button btnWithEBSVolume;
    private String imageName;
    private String imageDescription;
    private Boolean noReboot;
    private Boolean withEBSVolume;

    public CreateInstanceBackupDialog(Shell parentShell, IInstance instance) {
        super(parentShell);
        this.instance = instance;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(2, false);
        gl_container.horizontalSpacing = 16;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblInstanceId = new Label(container, 0);
        lblInstanceId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstanceId.setText(this.bundle_dialog_label.getString("dialog.create_instance_backup.instance_id_title"));
        this.txtInstanceId = new Text(container, 2056);
        this.txtInstanceId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        new Label(container, 0);
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(this.bundle_dialog_label.getString("dialog.create_instance_backup.image_name_title"));
        this.txtImageName = new Text(container, 2048);
        GridData gd_name = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_name.widthHint = 203;
        this.txtImageName.setLayoutData((Object)gd_name);
        new Label(container, 0);
        new Label(container, 0);
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.bundle_dialog_label.getString("dialog.create_instance_backup.description_title"));
        this.txtImageDescription = new Text(container, 2048);
        GridData gd_Description = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_Description.widthHint = 146;
        this.txtImageDescription.setLayoutData((Object)gd_Description);
        new Label(container, 0);
        new Label(container, 0);
        Label lblNoReboot = new Label(container, 0);
        lblNoReboot.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNoReboot.setText(this.bundle_dialog_label.getString("dialog.create_instance_backup.no_reboot_title"));
        this.btnNoReboot = new Button(container, 32);
        this.txtInstanceId.setText(this.instance.getInstanceId());
        new Label(container, 0);
        new Label(container, 0);
        Label lblWithEbsVolume = new Label(container, 0);
        lblWithEbsVolume.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblWithEbsVolume.setText(this.bundle_dialog_label.getString("dialog.create_instance_backup.with_ebs_volume_title"));
        this.btnWithEBSVolume = new Button(container, 32);
        ControlUtil.setRequired(new Control[]{this.txtImageName});
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if ("".equals(this.txtImageName.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        this.imageName = this.txtImageName.getText();
        this.imageDescription = this.txtImageDescription.getText();
        this.noReboot = this.btnNoReboot.getSelection();
        this.withEBSVolume = this.btnWithEBSVolume.getSelection();
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("backup_instance"));
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getDescription() {
        return this.imageDescription;
    }

    public Boolean getNoReboot() {
        return this.noReboot;
    }

    public Boolean getWithEBSVolume() {
        return this.withEBSVolume;
    }
}

