/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CreateInstanceRequest;
import com.clustercontrol.cloud.aws.presenter.ITemplate;
import com.clustercontrol.cloud.aws.presenter.ITemplateManagement;
import com.clustercontrol.cloud.aws.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.aws.resources.Subnet;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.EditTemplateJobArgumentDialog;
import com.clustercontrol.cloud.ui.dialogs.InstanceDetailDialog;
import com.clustercontrol.cloud.ui.dialogs.SelectAMIDialog2;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateInstanceDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Shell shell;
    private Text facilityId;
    private Button btnReplaceNode;
    private Text facilityName;
    private Text description;
    private Text nodeName;
    private Combo cmbRegion;
    private Combo cmbAvailabilityZone;
    private Combo cmbKeyPair;
    private Text txtAMI;
    private Combo cmbTemplate;
    private Button btnUseTemplate;
    private Button btnSelectAMI;
    private Button btnEditArgument;
    private ControlDecoration ctdcKeyPair;
    private CloudResourceProvider provider;
    private Model input;
    private Model output = new Model();
    private IDialogBehavior behavior = new DialogBehavior();
    private ITemplateManagement templateManagement = Activator.getDefault().getCloudManager().getInventory().getFolder(ITemplateManagement.class);
    private List<TemplateJobsArgument> arguments;
    private Label lblAvailabilityZone;
    private Label lblAMI;
    private Label lblUseTemplate;
    private Label lblLaunchInVPC;
    private Label lblTemplate;
    private Button btnLaunchInVPC;
    private Combo cmbSubnet;
    private Label lblSubnet;

    public CreateInstanceDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(1, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Group grpNodeInfo = new Group(container, 0);
        grpNodeInfo.setText(this.bundle_dialog_label.getString("dialog.create_instance.group.node_info_title"));
        GridLayout gl_grpNodeInfo = new GridLayout(2, false);
        gl_grpNodeInfo.verticalSpacing = 9;
        gl_grpNodeInfo.horizontalSpacing = 15;
        grpNodeInfo.setLayout((Layout)gl_grpNodeInfo);
        grpNodeInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        Label lblid = new Label((Composite)grpNodeInfo, 131072);
        lblid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblid.setText(this.bundle_dialog_label.getString("dialog.create_instance.facility_id_title"));
        this.facilityId = new Text((Composite)grpNodeInfo, 2048);
        this.facilityId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label((Composite)grpNodeInfo, 0);
        this.btnReplaceNode = new Button((Composite)grpNodeInfo, 32);
        this.btnReplaceNode.setText(this.bundle_dialog_label.getString("dialog.create_instance.node_replace_description"));
        Label lblFacilityName = new Label((Composite)grpNodeInfo, 131072);
        lblFacilityName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFacilityName.setText(this.bundle_dialog_label.getString("dialog.create_instance.facility_name_title"));
        this.facilityName = new Text((Composite)grpNodeInfo, 2048);
        this.facilityName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblDescription = new Label((Composite)grpNodeInfo, 131072);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.bundle_dialog_label.getString("dialog.create_instance.description_title"));
        this.description = new Text((Composite)grpNodeInfo, 2048);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNodeName = new Label((Composite)grpNodeInfo, 131072);
        lblNodeName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNodeName.setText(this.bundle_dialog_label.getString("dialog.create_instance.node_name_title"));
        this.nodeName = new Text((Composite)grpNodeInfo, 2048);
        GridData gd_nodeName = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_nodeName.widthHint = 66;
        this.nodeName.setLayoutData((Object)gd_nodeName);
        Group grpInstacneInfo = new Group(container, 0);
        grpInstacneInfo.setText(this.bundle_dialog_label.getString("dialog.create_instance.group.instance_info_title"));
        GridLayout gl_grpInstacneInfo = new GridLayout(3, false);
        gl_grpInstacneInfo.verticalSpacing = 9;
        gl_grpInstacneInfo.horizontalSpacing = 15;
        grpInstacneInfo.setLayout((Layout)gl_grpInstacneInfo);
        GridData gd_grpInstacneInfo = new GridData(4, 0x1000000, false, false, 5, 1);
        gd_grpInstacneInfo.heightHint = 350;
        grpInstacneInfo.setLayoutData((Object)gd_grpInstacneInfo);
        Label lblRegion = new Label((Composite)grpInstacneInfo, 131072);
        lblRegion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblRegion.setText(this.bundle_dialog_label.getString("dialog.create_instance.region_title"));
        this.cmbRegion = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbRegion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cmbRegion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateInstanceDialog.this.cmbKeyPair.removeAll();
                for (String keyName : CreateInstanceDialog.this.provider.getKeyNames((String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()))) {
                    CreateInstanceDialog.this.cmbKeyPair.add(keyName);
                }
                if (CreateInstanceDialog.this.cmbKeyPair.getItemCount() > 0) {
                    CreateInstanceDialog.this.cmbKeyPair.setEnabled(true);
                    CreateInstanceDialog.this.cmbKeyPair.select(0);
                } else {
                    CreateInstanceDialog.this.cmbKeyPair.setEnabled(false);
                }
                CreateInstanceDialog.this.checkKeyPair();
                String regionName = (String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText());
                CreateInstanceDialog.this.cmbAvailabilityZone.removeAll();
                List<AvailabilityZone> azs = CreateInstanceDialog.this.provider.getAvailabilityZones(regionName);
                for (AvailabilityZone az : azs) {
                    CreateInstanceDialog.this.cmbAvailabilityZone.add(az.getZoneName());
                }
                CreateInstanceDialog.this.cmbAvailabilityZone.select(0);
                CreateInstanceDialog.this.cmbSubnet.removeAll();
                CreateInstanceDialog.this.btnLaunchInVPC.setSelection(false);
                CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(true);
                CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(true);
                CreateInstanceDialog.this.lblSubnet.setEnabled(false);
                CreateInstanceDialog.this.cmbSubnet.setEnabled(false);
                CreateInstanceDialog.this.cmbTemplate.removeAll();
                CreateInstanceDialog.this.lblTemplate.setEnabled(false);
                CreateInstanceDialog.this.cmbTemplate.setEnabled(false);
                CreateInstanceDialog.this.btnEditArgument.setEnabled(false);
                CreateInstanceDialog.this.lblAMI.setEnabled(true);
                CreateInstanceDialog.this.txtAMI.setEnabled(true);
                CreateInstanceDialog.this.btnSelectAMI.setEnabled(true);
                CreateInstanceDialog.this.txtAMI.setText("");
                CreateInstanceDialog.this.txtAMI.setData(null);
            }
        });
        this.lblAvailabilityZone = new Label((Composite)grpInstacneInfo, 0);
        this.lblAvailabilityZone.setAlignment(131072);
        this.lblAvailabilityZone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblAvailabilityZone.setText(this.bundle_dialog_label.getString("dialog.create_instance.availability_zone_title"));
        this.cmbAvailabilityZone = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbAvailabilityZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.lblLaunchInVPC = new Label((Composite)grpInstacneInfo, 0);
        this.lblLaunchInVPC.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblLaunchInVPC.setAlignment(131072);
        this.lblLaunchInVPC.setText(this.bundle_dialog_label.getString("dialog.create_instance.vpc_enable_title"));
        this.btnLaunchInVPC = new Button((Composite)grpInstacneInfo, 32);
        this.btnLaunchInVPC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.btnLaunchInVPC.getSelection()) {
                    if (CreateInstanceDialog.this.cmbSubnet.getItemCount() == 0) {
                        List<Subnet> subnets = CreateInstanceDialog.this.provider.getSubnetsByRegion((String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()));
                        if (!subnets.isEmpty()) {
                            for (Subnet subnet : subnets) {
                                CreateInstanceDialog.this.cmbSubnet.add(subnet.getSubnetId());
                                CreateInstanceDialog.this.cmbSubnet.setData(subnet.getSubnetId(), (Object)subnet);
                            }
                            CreateInstanceDialog.this.cmbSubnet.select(0);
                            CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(false);
                            CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(false);
                            CreateInstanceDialog.this.lblSubnet.setEnabled(true);
                            CreateInstanceDialog.this.cmbSubnet.setEnabled(true);
                        } else {
                            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)CreateInstanceDialog.this.bundle_messages.getString("dialogs.subnet_does_not_exists"));
                            CreateInstanceDialog.this.btnLaunchInVPC.setSelection(false);
                        }
                    } else {
                        CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(false);
                        CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(false);
                        CreateInstanceDialog.this.lblSubnet.setEnabled(true);
                        CreateInstanceDialog.this.cmbSubnet.setEnabled(true);
                    }
                } else {
                    CreateInstanceDialog.this.lblAvailabilityZone.setEnabled(true);
                    CreateInstanceDialog.this.cmbAvailabilityZone.setEnabled(true);
                    CreateInstanceDialog.this.lblSubnet.setEnabled(false);
                    CreateInstanceDialog.this.cmbSubnet.setEnabled(false);
                }
            }
        });
        this.btnLaunchInVPC.setAlignment(131072);
        this.btnLaunchInVPC.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)grpInstacneInfo, 0);
        this.lblSubnet = new Label((Composite)grpInstacneInfo, 0);
        this.lblSubnet.setEnabled(false);
        this.lblSubnet.setAlignment(131072);
        this.lblSubnet.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblSubnet.setText(this.bundle_dialog_label.getString("dialog.create_instance.subnet_title"));
        this.cmbSubnet = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbSubnet.setEnabled(false);
        this.cmbSubnet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblKeyPair = new Label((Composite)grpInstacneInfo, 131072);
        lblKeyPair.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblKeyPair.setText(this.bundle_dialog_label.getString("dialog.create_instance.keypair_title"));
        this.cmbKeyPair = new Combo((Composite)grpInstacneInfo, 8);
        GridData gd_cmbKeyPair = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_cmbKeyPair.widthHint = 100;
        this.cmbKeyPair.setLayoutData((Object)gd_cmbKeyPair);
        this.ctdcKeyPair = new ControlDecoration((Control)this.cmbKeyPair, 16512);
        this.ctdcKeyPair.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
        this.lblAMI = new Label((Composite)grpInstacneInfo, 0);
        this.lblAMI.setAlignment(131072);
        this.lblAMI.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblAMI.setText(this.bundle_dialog_label.getString("dialog.create_instance.ami_title"));
        this.txtAMI = new Text((Composite)grpInstacneInfo, 2056);
        this.txtAMI.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSelectAMI = new Button((Composite)grpInstacneInfo, 0);
        this.btnSelectAMI.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSelectAMI.setText(this.bundle_dialog_label.getString("dialog.create_instance.button.select_ami_title"));
        this.btnSelectAMI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectAMIDialog2 dialog = new SelectAMIDialog2(CreateInstanceDialog.this.shell);
                dialog.setCloudInfoProvider(CreateInstanceDialog.this.provider);
                dialog.setRegion((String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()));
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    Image image = dialog.getOutput();
                    CreateInstanceDialog.this.txtAMI.setText("(" + image.getImageId() + ") " + image.getName());
                    CreateInstanceDialog.this.txtAMI.setData((Object)image);
                }
            }
        });
        this.lblUseTemplate = new Label((Composite)grpInstacneInfo, 0);
        this.lblUseTemplate.setAlignment(131072);
        this.lblUseTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblUseTemplate.setText(this.bundle_dialog_label.getString("dialog.create_instance.use_template_title"));
        this.btnUseTemplate = new Button((Composite)grpInstacneInfo, 32);
        this.btnUseTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnUseTemplate.setAlignment(131072);
        this.btnUseTemplate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.btnUseTemplate.getSelection()) {
                    if (CreateInstanceDialog.this.cmbTemplate.getItemCount() == 0) {
                        for (ITemplate tmpTemplate : CreateInstanceDialog.this.templateManagement.getTemplates()) {
                            if (!tmpTemplate.getRegion().equals(CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText()))) continue;
                            String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
                            CreateInstanceDialog.this.cmbTemplate.add(tmpLabel);
                            CreateInstanceDialog.this.cmbTemplate.setData(tmpLabel, (Object)tmpTemplate);
                        }
                    }
                    if (CreateInstanceDialog.this.cmbTemplate.getItemCount() > 0) {
                        CreateInstanceDialog.this.cmbTemplate.select(0);
                        CreateInstanceDialog.this.lblTemplate.setEnabled(true);
                        CreateInstanceDialog.this.cmbTemplate.setEnabled(true);
                        CreateInstanceDialog.this.btnEditArgument.setEnabled(true);
                        CreateInstanceDialog.this.lblAMI.setEnabled(false);
                        CreateInstanceDialog.this.txtAMI.setEnabled(false);
                        CreateInstanceDialog.this.btnSelectAMI.setEnabled(false);
                        CreateInstanceDialog.this.txtAMI.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)CreateInstanceDialog.this.bundle_messages.getString("dialogs.template_does_not_exists"));
                        CreateInstanceDialog.this.btnUseTemplate.setSelection(false);
                    }
                } else {
                    CreateInstanceDialog.this.lblTemplate.setEnabled(false);
                    CreateInstanceDialog.this.cmbTemplate.setEnabled(false);
                    CreateInstanceDialog.this.btnEditArgument.setEnabled(false);
                    CreateInstanceDialog.this.lblAMI.setEnabled(true);
                    CreateInstanceDialog.this.txtAMI.setEnabled(true);
                    CreateInstanceDialog.this.btnSelectAMI.setEnabled(true);
                    if (CreateInstanceDialog.this.txtAMI.getText().equals("")) {
                        CreateInstanceDialog.this.txtAMI.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                    }
                }
            }
        });
        new Label((Composite)grpInstacneInfo, 0);
        this.lblTemplate = new Label((Composite)grpInstacneInfo, 0);
        this.lblTemplate.setEnabled(false);
        this.lblTemplate.setAlignment(131072);
        this.lblTemplate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblTemplate.setText(this.bundle_dialog_label.getString("dialog.create_instance.template_title"));
        this.cmbTemplate = new Combo((Composite)grpInstacneInfo, 2056);
        this.cmbTemplate.setEnabled(false);
        GridData gd_cmbTemplate = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_cmbTemplate.widthHint = 100;
        this.cmbTemplate.setLayoutData((Object)gd_cmbTemplate);
        this.btnEditArgument = new Button((Composite)grpInstacneInfo, 0);
        this.btnEditArgument.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEditArgument.setText(this.bundle_dialog_label.getString("dialog.create_instance.button.edit_argument_title"));
        this.btnEditArgument.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateInstanceDialog.this.cmbTemplate.getText().equals("")) {
                    return;
                }
                ITemplate tmpTemplate = (ITemplate)CreateInstanceDialog.this.cmbTemplate.getData(CreateInstanceDialog.this.cmbTemplate.getText());
                if (tmpTemplate == null || tmpTemplate.getLaunchJobId() == null || tmpTemplate.getLaunchJobId().equals("")) {
                    return;
                }
                EditTemplateJobArgumentDialog dialog = new EditTemplateJobArgumentDialog(CreateInstanceDialog.this.shell, tmpTemplate.getTemplateId(), tmpTemplate.getLaunchJobId());
                if (dialog.open() == 0) {
                    CreateInstanceDialog.this.arguments = dialog.getArguments();
                }
            }
        });
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        Button btnDetailSettings = new Button((Composite)grpInstacneInfo, 0);
        btnDetailSettings.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnDetailSettings.setText(this.bundle_dialog_label.getString("dialog.create_instance.button.detail_settings_title"));
        btnDetailSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstanceDetailDialog dialog = new InstanceDetailDialog(CreateInstanceDialog.this.shell);
                dialog.setCloudInfoProvider(CreateInstanceDialog.this.provider);
                ((CreateInstanceDialog)CreateInstanceDialog.this).output.regionName = (String)CreateInstanceDialog.this.cmbRegion.getData(CreateInstanceDialog.this.cmbRegion.getText());
                ((CreateInstanceDialog)CreateInstanceDialog.this).output.facilityName = CreateInstanceDialog.this.facilityName.getText();
                ((CreateInstanceDialog)CreateInstanceDialog.this).output.subnet = CreateInstanceDialog.this.btnLaunchInVPC.getSelection() ? (Subnet)CreateInstanceDialog.this.cmbSubnet.getData(CreateInstanceDialog.this.cmbSubnet.getText()) : null;
                dialog.setInput(CreateInstanceDialog.this.output);
                if (dialog.open() == 0) {
                    CreateInstanceDialog.this.output = dialog.getOutput();
                }
            }
        });
        this.checkKeyPair();
        ControlUtil.setRequired(new Control[]{this.facilityId, this.facilityName, this.nodeName, this.txtAMI});
        this.behavior.setInput(this.input);
        this.behavior.setProvider(this.provider);
        this.behavior.setupFacilityId(this.facilityId);
        this.behavior.setupReplaceNode(this.btnReplaceNode);
        this.behavior.setupFacilityName(this.facilityName);
        this.behavior.setupDescription(this.description);
        this.behavior.setupNodeName(this.nodeName);
        this.behavior.setupRegion(this.cmbRegion);
        this.behavior.setupAvailabilityZone(this.cmbAvailabilityZone);
        this.behavior.setupDetailSettings(btnDetailSettings);
        this.behavior.setupAmi(this.txtAMI, this.btnSelectAMI);
        this.behavior.setupTemplate(this.btnUseTemplate, this.cmbTemplate, this.btnEditArgument);
        this.behavior.setupKeyPair(this.cmbKeyPair);
        container.layout();
        Control[] labels = new Control[]{lblid, lblFacilityName, lblDescription, lblNodeName, lblRegion, this.lblAvailabilityZone, this.lblLaunchInVPC, this.lblSubnet, lblKeyPair, this.lblAMI, this.lblUseTemplate, this.lblTemplate};
        int maxWidth = 0;
        for (Control l : labels) {
            Point p = l.getSize();
            maxWidth = Math.max(maxWidth, p.x);
        }
        for (Control l : labels) {
            ((GridData)l.getLayoutData()).widthHint = maxWidth;
        }
        grpNodeInfo.layout(true);
        grpInstacneInfo.layout(true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 690);
    }

    protected void okPressed() {
        if (this.facilityId.getText().equals("") || this.facilityName.getText().equals("") || this.nodeName.getText().equals("") || this.cmbRegion.getText().equals("") || this.cmbKeyPair.getText().equals("") || !this.btnLaunchInVPC.getSelection() && this.cmbAvailabilityZone.getText().equals("") || this.btnLaunchInVPC.getSelection() && this.cmbSubnet.getText().equals("") || !this.btnUseTemplate.getSelection() && this.txtAMI.getText().equals("") || this.btnUseTemplate.getSelection() && this.cmbTemplate.getText().equals("")) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        this.output.regionName = (String)this.cmbRegion.getData(this.cmbRegion.getText());
        this.output.facilityId = this.facilityId.getText();
        this.output.facilityName = this.facilityName.getText();
        this.output.description = this.description.getText();
        this.output.nodeName = this.nodeName.getText();
        this.output.keyName = this.cmbKeyPair.getText();
        this.output.image = (Image)this.txtAMI.getData();
        this.output.replaceNode = this.btnReplaceNode.getSelection();
        if (!this.btnLaunchInVPC.getSelection()) {
            this.output.availabilityZone = new AvailabilityZone();
            this.output.availabilityZone.setZoneName(this.cmbAvailabilityZone.getText());
            this.output.subnet = null;
        } else {
            this.output.availabilityZone = null;
            this.output.subnet = (Subnet)this.cmbSubnet.getData(this.cmbSubnet.getText());
        }
        if (!this.btnUseTemplate.getSelection()) {
            this.output.image = (Image)this.txtAMI.getData();
            this.output.templateId = null;
        } else {
            this.output.templateId = ((ITemplate)this.cmbTemplate.getData(this.cmbTemplate.getText())).getTemplateId();
            Image image = new Image();
            image.setImageId(((ITemplate)this.cmbTemplate.getData(this.cmbTemplate.getText())).getImageId());
            this.output.image = image;
            if (this.arguments != null && this.arguments.size() > 0) {
                this.output.arguments = this.arguments;
            }
            this.output.isTemplateUsed = true;
            this.output.image = null;
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("create_instance"));
    }

    public void setInput(Model input) {
        assert (input != null);
        this.input = input;
        this.output = input.deepCopy();
    }

    public Model getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public void checkKeyPair() {
        if (this.cmbKeyPair.getItemCount() > 0) {
            this.ctdcKeyPair.hide();
            this.ctdcKeyPair.setDescriptionText("");
            this.ctdcKeyPair.showHoverText("");
            this.ctdcKeyPair.setShowHover(false);
        } else {
            this.ctdcKeyPair.show();
            this.ctdcKeyPair.setShowHover(true);
            this.ctdcKeyPair.setDescriptionText(this.bundle_messages.getString("dialogs.that_region_has_no_keypair"));
            this.ctdcKeyPair.showHoverText(this.bundle_messages.getString("dialogs.that_region_has_no_keypair"));
        }
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        protected MessageManager bundle_region = MessageManager.getInstance("region");
        protected CloudResourceProvider provider;
        protected Model input;

        @Override
        public void setInput(Model input) {
            this.input = input;
        }

        @Override
        public void setProvider(CloudResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public void setupFacilityId(Text facilityId) {
        }

        @Override
        public void setupFacilityName(Text facilityName) {
        }

        @Override
        public void setupReplaceNode(Button btnReplaceNode) {
        }

        @Override
        public void setupDescription(Text description) {
        }

        @Override
        public void setupNodeName(Text nodeName) {
        }

        @Override
        public void setupRegion(Combo region) {
        }

        @Override
        public void setupAvailabilityZone(Combo availabilityZone) {
        }

        @Override
        public void setupKeyPair(Combo keyPair) {
        }

        @Override
        public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
        }

        @Override
        public void setupAmi(Text ami, Button selectAmi) {
        }

        @Override
        public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
        }

        @Override
        public void setupDetailSettings(Button detailSettings) {
        }
    }

    static interface IDialogBehavior {
        public void setInput(Model var1);

        public void setProvider(CloudResourceProvider var1);

        public void setupFacilityId(Text var1);

        public void setupFacilityName(Text var1);

        public void setupReplaceNode(Button var1);

        public void setupDescription(Text var1);

        public void setupNodeName(Text var1);

        public void setupRegion(Combo var1);

        public void setupAvailabilityZone(Combo var1);

        public void setupKeyPair(Combo var1);

        public void setupSelectImageFlg(Button var1, Button var2);

        public void setupAmi(Text var1, Button var2);

        public void setupTemplate(Button var1, Combo var2, Button var3);

        public void setupDetailSettings(Button var1);
    }

    public static class Model
    extends CreateInstanceRequest
    implements Serializable {
        private static final long serialVersionUID = -8364801407665470030L;
        public String regionName;
        public String templateId;
        public List<TemplateJobsArgument> arguments;
        public Boolean isTemplateUsed = false;

        @Override
        public Model deepCopy() {
            return ControlUtil.deepCopy(this);
        }
    }
}

