/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CreateStorageRequest;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateStorageDialog
extends Dialog {
    private static final int multiply = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.multiply"));
    private static final int minIops = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.miniops"));
    private static final int maxIops = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.maxiops"));
    private static final int skip = Integer.parseInt(MessageManager.getInstance("parameter").getString("aws.iops.skip"));
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
    private static final String IOPS_VALUE = "io1";
    private Text volumeName;
    private Text size;
    private Combo unitSize;
    private Combo comboAvailabilityZone;
    private Combo comboSnapshot;
    private Combo volumeType;
    private Combo comboIops;
    private ControlDecoration ctdcIops;
    private ControlDecoration ctdcSize;
    private Label lblRegion;
    private Combo comboRegion;
    private CloudResourceProvider provider;
    private Model input;
    private Model output = new Model();
    private IDialogBehavior behavior;
    private Decorator decorator;

    public CreateStorageDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(4, false);
        gl_container.horizontalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblVolumeName = new Label(container, 0);
        lblVolumeName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeName.setText(this.bundle_dialog_label.getString("dialog.create_storage.storage_name_title"));
        this.volumeName = new Text(container, 2048);
        this.volumeName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblSize = new Label(container, 0);
        lblSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSize.setText(this.bundle_dialog_label.getString("dialog.create_storage.storage_size_title"));
        this.size = new Text(container, 2048);
        GridData gd_size = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_size.widthHint = 146;
        this.size.setLayoutData((Object)gd_size);
        this.ctdcSize = new ControlDecoration((Control)this.size, 16512);
        this.ctdcSize.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
        this.ctdcSize.setDescriptionText("");
        this.ctdcSize.hide();
        this.unitSize = new Combo(container, 8);
        GridData gd_unitSize = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_unitSize.widthHint = 124;
        this.unitSize.setLayoutData((Object)gd_unitSize);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.lblRegion = new Label(container, 0);
        this.lblRegion.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblRegion.setText(this.bundle_dialog_label.getString("dialog.create_storage.region_title"));
        this.comboRegion = new Combo(container, 8);
        this.comboRegion.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblAvailabilityzone = new Label(container, 0);
        lblAvailabilityzone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAvailabilityzone.setText(this.bundle_dialog_label.getString("dialog.create_storage.availability_zone_title"));
        this.comboAvailabilityZone = new Combo(container, 8);
        this.comboAvailabilityZone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblSnapshot = new Label(container, 0);
        lblSnapshot.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSnapshot.setText(this.bundle_dialog_label.getString("dialog.create_storage.snapshot_title"));
        this.comboSnapshot = new Combo(container, 8);
        GridData gd_snapshot = new GridData(4, 0x1000000, true, false, 3, 1);
        gd_snapshot.widthHint = 570;
        this.comboSnapshot.setLayoutData((Object)gd_snapshot);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label lblVolumeType = new Label(container, 0);
        lblVolumeType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVolumeType.setText(this.bundle_dialog_label.getString("dialog.create_storage.volume_type_title"));
        this.volumeType = new Combo(container, 8);
        GridData gd_volumeType = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_volumeType.widthHint = 220;
        this.volumeType.setLayoutData((Object)gd_volumeType);
        Label lblIops = new Label(container, 0);
        lblIops.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIops.setText(this.bundle_dialog_label.getString("dialog.create_storage.iops_title"));
        this.comboIops = new Combo(container, 2048);
        GridData gd_iops = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_iops.widthHint = 208;
        this.comboIops.setLayoutData((Object)gd_iops);
        this.ctdcIops = new ControlDecoration((Control)this.comboIops, 16512);
        this.ctdcIops.setImage(ResourceManager.getPluginImage(Activator.ID, "icons/error.gif"));
        this.ctdcIops.hide();
        this.unitSize.add("GiB");
        this.unitSize.add("TiB");
        this.unitSize.select(0);
        this.comboIops.setEnabled(false);
        this.behavior.setInput(this.input);
        this.behavior.setProvider(this.provider);
        this.behavior.setupVolumeName(this.volumeName);
        this.behavior.setupSize(this.size, this.unitSize);
        this.behavior.setupRegion(this.comboRegion);
        this.behavior.setupAvailabilityZone(this.comboAvailabilityZone);
        this.behavior.setupSnapshot(this.comboSnapshot);
        this.behavior.setupVolumeType(this.volumeType);
        this.behavior.setupIops(this.comboIops);
        this.size.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!"".equals(CreateStorageDialog.this.size.getText())) {
                    String n = CreateStorageDialog.this.comboIops.getText();
                    CreateStorageDialog.this.comboIops.removeAll();
                    for (int iops = skip; iops <= maxIops; iops += skip) {
                        CreateStorageDialog.this.comboIops.add(Integer.toString(iops));
                    }
                    CreateStorageDialog.this.comboIops.setText(n);
                }
            }
        });
        this.size.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = CreateStorageDialog.this.size.getText().substring(0, e.start) + e.text + CreateStorageDialog.this.size.getText().substring(e.start);
                    if (t.length() != 0) {
                        Integer.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        this.size.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateStorageDialog.this.checkIops();
            }
        });
        this.volumeType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateStorageDialog.this.volumeType.getText().equals(CreateStorageDialog.this.bundle_volume_type.getString(CreateStorageDialog.IOPS_VALUE))) {
                    CreateStorageDialog.this.comboIops.setEnabled(true);
                    CreateStorageDialog.this.decorator.setEnabled(true);
                } else {
                    CreateStorageDialog.this.decorator.setEnabled(false);
                    CreateStorageDialog.this.comboIops.setEnabled(false);
                }
                CreateStorageDialog.this.checkIops();
            }
        });
        this.comboIops.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateStorageDialog.this.checkIops();
            }
        });
        this.comboIops.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    String t = CreateStorageDialog.this.comboIops.getText().substring(0, e.start) + e.text + CreateStorageDialog.this.comboIops.getText().substring(e.start);
                    if (t.length() != 0) {
                        Integer.valueOf(t);
                    }
                }
                catch (Exception e1) {
                    e.doit = false;
                }
            }
        });
        this.decorator = new Decorator(this.comboIops);
        ControlUtil.setRequired(new Control[]{this.volumeName, this.size});
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if ("".equals(this.volumeName.getText()) || "".equals(this.size.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_fully_input"));
            return;
        }
        this.output = new Model();
        this.output.setStorageName(this.volumeName.getText());
        this.output.setStorageSize(Integer.parseInt(this.size.getText()));
        this.output.region = (String)this.comboRegion.getData(this.comboRegion.getText());
        this.output.setAvailabilityZone(this.comboAvailabilityZone.getText());
        this.output.setSnapshotId((String)this.comboSnapshot.getData(this.comboSnapshot.getText()));
        this.output.setStorageKind((String)this.volumeType.getData(this.volumeType.getText()));
        if (this.bundle_volume_type.getString(IOPS_VALUE).equals(this.volumeType.getText())) {
            this.output.setIops("".equals(this.comboIops.getText()) || this.comboIops.getText() == null ? null : Integer.valueOf(Integer.parseInt(this.comboIops.getText())));
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("create_storage"));
    }

    public void checkIops() {
        if (this.bundle_volume_type.getString(IOPS_VALUE).equals(this.volumeType.getText()) && (this.comboIops.getText().isEmpty() || Integer.parseInt(this.comboIops.getText()) < minIops || Integer.parseInt(this.comboIops.getText()) > maxIops)) {
            this.ctdcIops.show();
            this.ctdcIops.setShowHover(true);
            this.ctdcIops.setDescriptionText(this.bundle_messages.getString("dialogs.iops_must_be_less_than_20_times_of_volume_size", new String[]{Integer.toString(minIops), Integer.toString(maxIops)}));
            this.ctdcIops.showHoverText(this.bundle_messages.getString("dialogs.iops_must_be_less_than_20_times_of_volume_size", new String[]{Integer.toString(minIops), Integer.toString(maxIops)}));
        } else {
            this.ctdcIops.hide();
            this.ctdcIops.setDescriptionText("");
            this.ctdcIops.showHoverText("");
            this.ctdcIops.setShowHover(false);
        }
        if (this.bundle_volume_type.getString(IOPS_VALUE).equals(this.volumeType.getText()) && (this.size.getText().isEmpty() && !this.comboIops.getText().isEmpty() || !this.size.getText().isEmpty() && !this.comboIops.getText().isEmpty() && Integer.parseInt(this.size.getText()) * multiply < Integer.parseInt(this.comboIops.getText()))) {
            this.ctdcSize.show();
            this.ctdcSize.setShowHover(true);
            this.ctdcSize.setDescriptionText(this.bundle_messages.getString("dialogs.must_grater_than_10", new String[]{Integer.toString(multiply)}));
            this.ctdcSize.showHoverText(this.bundle_messages.getString("dialogs.must_grater_than_10", new String[]{Integer.toString(multiply)}));
        } else {
            this.ctdcSize.hide();
            this.ctdcSize.setDescriptionText("");
            this.ctdcSize.showHoverText("");
            this.ctdcSize.setShowHover(false);
        }
    }

    public void setInput(Model input) {
        assert (input != null);
        this.input = input;
    }

    public Model getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    static interface IDialogBehavior {
        public void setInput(Model var1);

        public void setProvider(CloudResourceProvider var1);

        public void setupVolumeName(Text var1);

        public void setupSize(Text var1, Combo var2);

        public void setupRegion(Combo var1);

        public void setupAvailabilityZone(Combo var1);

        public void setupSnapshot(Combo var1);

        public void setupVolumeType(Combo var1);

        public void setupIops(Combo var1);
    }

    public static class Model
    extends CreateStorageRequest
    implements Serializable {
        private static final long serialVersionUID = -8364801407665470030L;
        public String region;

        @Override
        public Model deepCopy() {
            return (Model)super.deepCopy();
        }
    }

    public static class Decorator {
        private Combo control;
        private static ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Combo)e.getSource()).getText().equals("")) {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    ((Combo)e.getSource()).setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
            }
        };

        public Decorator(Combo control) {
            this.control = control;
            this.setEnabled(false);
        }

        public void setEnabled(boolean enable) {
            if (enable) {
                if (this.control.getText().equals("")) {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
                } else {
                    this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
                }
                this.control.addModifyListener(modifyListener);
            } else {
                this.control.removeModifyListener(modifyListener);
                this.control.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
            }
        }
    }
}

