/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.TemplateJobsArgument;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class EditTemplateJobArgumentDialog
extends Dialog {
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private Table table;
    private TableViewer tableViewer;
    private String jobId = "";
    private String templateId = "";
    private TemplateJobUtil.TemplateJobnet templateJob;
    private Text txtTemplateId;
    private Text txtJobnetId;
    private List<TemplateJobUtil.TemplateJob> jobInfos = new ArrayList<TemplateJobUtil.TemplateJob>();
    private List<TemplateJobsArgument> arguments = new ArrayList<TemplateJobsArgument>();

    public EditTemplateJobArgumentDialog(Shell parentShell, String templateId, String jobId) {
        super(parentShell);
        this.templateId = templateId;
        this.jobId = jobId;
        try {
            for (TemplateJobUtil.TemplateJobnet jobnet : TemplateJobUtil.getTemplateJobList(false)) {
                if (!jobnet.getJobnetId().equals(jobId)) continue;
                this.templateJob = jobnet;
            }
            if (this.templateJob == null) {
                throw new Exception("Target job doesn't exist.");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.jobInfos = this.templateJob.getJobs();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblTemplateId = new Label(container, 0);
        lblTemplateId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTemplateId.setText(this.bundle_dialog_label.getString("dialog.edit_template_job_argument.template_id_title"));
        this.txtTemplateId = new Text(container, 2056);
        this.txtTemplateId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtTemplateId.setText(this.templateId);
        Label lblJobnetId = new Label(container, 0);
        lblJobnetId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJobnetId.setText(this.bundle_dialog_label.getString("dialog.edit_template_job_argument.jobnet_id_title"));
        this.txtJobnetId = new Text(container, 2056);
        this.txtJobnetId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtJobnetId.setText(this.jobId);
        this.table = new Table(container, 67586);
        this.table.setBackground(SWTResourceManager.getColor(248, 248, 248));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn tblclmnJobId = new TableColumn(this.table, 0);
        tblclmnJobId.setWidth(100);
        tblclmnJobId.setText(this.bundle_dialog_label.getString("dialog.edit_template_job_argument.column.job_id"));
        TableColumn tblclmnJobName = new TableColumn(this.table, 0);
        tblclmnJobName.setWidth(141);
        tblclmnJobName.setText(this.bundle_dialog_label.getString("dialog.edit_template_job_argument.column.job_name"));
        TableColumn tblclmnCommand = new TableColumn(this.table, 0);
        tblclmnCommand.setWidth(141);
        tblclmnCommand.setText(this.bundle_dialog_label.getString("dialog.edit_template_job_argument.column.execute_command"));
        TableColumn tblclmnUser = new TableColumn(this.table, 0);
        tblclmnUser.setWidth(100);
        tblclmnUser.setText(this.bundle_dialog_label.getString("dialog.edit_template_job_argument.column.execute_user"));
        TableColumn tblclmnArgument = new TableColumn(this.table, 0);
        tblclmnArgument.setWidth(100);
        tblclmnArgument.setText(this.bundle_dialog_label.getString("dialog.edit_template_job_argument.column.argument"));
        this.tableViewer = new TableViewer(this.table);
        String[] columnProperties = new String[]{"jobId", "jobName", "executeCommnad", "executeUser", "argument"};
        this.tableViewer.setColumnProperties(columnProperties);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable()), new TextCellEditor((Composite)this.tableViewer.getTable())};
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals("argument")) {
                    Pattern pattern = Pattern.compile("\\#\\[aws_" + ((TemplateJobUtil.TemplateJob)element).getJobId() + "\\]");
                    Matcher matcher = pattern.matcher(((TemplateJobUtil.TemplateJob)element).getCommand());
                    return matcher.find();
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                return ((TemplateJobUtil.TemplateJob)element).getArgument();
            }

            public void modify(Object element, String property, Object value) {
                TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob)((TableItem)element).getData();
                jobInfo.setArgument((String)value);
                EditTemplateJobArgumentDialog.this.tableViewer.setInput((Object)EditTemplateJobArgumentDialog.this.jobInfos);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setInput(this.jobInfos);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        for (TableItem item : this.table.getItems()) {
            TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob)item.getData();
            Pattern pattern = Pattern.compile("\\#\\[aws_" + jobInfo.getJobId() + "\\]");
            Matcher matcher = pattern.matcher(jobInfo.getCommand());
            if (!matcher.find()) continue;
            item.setBackground(4, SWTResourceManager.getColor(255, 255, 255));
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        this.arguments.clear();
        for (TemplateJobUtil.TemplateJob jobInfo : this.jobInfos) {
            Pattern pattern = Pattern.compile("\\#\\[aws_" + jobInfo.getJobId() + "\\]");
            Matcher matcher = pattern.matcher(jobInfo.getCommand());
            if (!matcher.find()) continue;
            TemplateJobsArgument argument = new TemplateJobsArgument();
            argument.setJobId(jobInfo.getJobId());
            argument.setArg(jobInfo.getArgument());
            this.arguments.add(argument);
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("edit_template_job_argument"));
    }

    public List<TemplateJobsArgument> getArguments() {
        return this.arguments;
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob)element;
            switch (columnIndex) {
                case 0: {
                    return jobInfo.getJobId();
                }
                case 1: {
                    return jobInfo.getJobName();
                }
                case 2: {
                    return jobInfo.getCommand();
                }
                case 3: {
                    return jobInfo.getExecuteUser();
                }
                case 4: {
                    return jobInfo.getArgument();
                }
            }
            return null;
        }
    }
}

