/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.IStorageBackup;
import com.clustercontrol.cloud.aws.resources.AvailabilityZone;
import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.ui.dialogs.CreateStorageDialog;
import java.util.List;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class RestoreStorageBehavior
implements CreateStorageDialog.IDialogBehavior {
    private MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
    private MessageManager bundle_region = MessageManager.getInstance("region");
    private static final String TERA_BYTE = "TiB";
    private static final Boolean REGION_ENABLED = false;
    private static final Boolean SNAPSHOT_ENABLED = false;
    private IStorageBackup backup;
    private CreateStorageDialog.Model input;
    private CloudResourceProvider provider;

    public RestoreStorageBehavior(IStorageBackup backup) {
        this.backup = backup;
    }

    @Override
    public void setInput(CreateStorageDialog.Model input) {
        this.input = input;
    }

    @Override
    public void setProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    @Override
    public void setupVolumeName(Text volumeName) {
        if (this.input.getStorageName() != null) {
            volumeName.setText(this.input.getStorageName());
        }
    }

    @Override
    public void setupSize(Text size, Combo unit) {
        if (this.input.getStorageSize() % 1024 == 0 && this.input.getStorageSize() / 1024 > 0) {
            size.setText(String.valueOf(this.input.getStorageSize() / 1024));
            unit.select(unit.indexOf(TERA_BYTE));
        } else {
            size.setText(String.valueOf(this.input.getStorageSize()));
        }
    }

    @Override
    public void setupRegion(Combo region) {
        String regionLocaleName = this.bundle_region.getString(this.input.region);
        region.add(regionLocaleName);
        region.setData(regionLocaleName, (Object)this.input.region);
        region.select(0);
        region.setEnabled(REGION_ENABLED.booleanValue());
    }

    @Override
    public void setupAvailabilityZone(Combo availabilityZone) {
        List<AvailabilityZone> avs = this.provider.getAvailabilityZones(this.input.region);
        availabilityZone.removeAll();
        for (AvailabilityZone name : avs) {
            availabilityZone.add(name.getZoneName());
        }
        availabilityZone.select(availabilityZone.indexOf(this.input.getAvailabilityZone()));
    }

    @Override
    public void setupSnapshot(Combo snapshot) {
        String snapshotName = this.input.getSnapshotId() + " -- " + this.backup.getDescription();
        snapshot.add(snapshotName);
        snapshot.setData(snapshotName, (Object)this.input.getSnapshotId());
        snapshot.select(0);
        snapshot.setEnabled(SNAPSHOT_ENABLED.booleanValue());
    }

    @Override
    public void setupVolumeType(Combo volumeType) {
        for (String volumeTypeName : this.provider.getAllVolumeType()) {
            String volumeTypeLocaleName = this.bundle_volume_type.getString(volumeTypeName);
            volumeType.add(volumeTypeLocaleName);
            volumeType.setData(volumeTypeLocaleName, (Object)volumeTypeName);
        }
        volumeType.select(0);
    }

    @Override
    public void setupIops(Combo Iops) {
    }
}

