/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.resources.Filter;
import com.clustercontrol.cloud.aws.resources.Image;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectAMIDialog2
extends Dialog {
    private Text filter;
    private org.eclipse.swt.widgets.List ami;
    private Button btnSearch;
    private String region;
    private CloudResourceProvider provider;
    private Image output;
    private MessageManager bundle_dialog_name = MessageManager.getInstance("dialog_name");
    private MessageManager bundle_dialog_label = MessageManager.getInstance("dialog_label");
    private MessageManager bundle_messages = MessageManager.getInstance("messages");

    public SelectAMIDialog2(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblTestfilter = new Label(container, 0);
        lblTestfilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTestfilter.setText(this.bundle_dialog_label.getString("dialog.select_ami.filter_title"));
        this.filter = new Text(container, 2048);
        this.filter.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnSearch = new Button(container, 0);
        this.btnSearch.setText(this.bundle_dialog_label.getString("dialog.select_ami.button.search_ami_title"));
        this.btnSearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SelectAMIDialog2.this.filter.getText() == "") {
                    MessageDialog.openWarning(null, (String)Messages.getString((String)"failed"), (String)SelectAMIDialog2.this.bundle_messages.getString("dialogs.must_input_search_text"));
                    return;
                }
                SelectAMIDialog2.this.ami.removeAll();
                Filter f1 = new Filter();
                f1.setName("name");
                f1.setValues(Arrays.asList("*" + SelectAMIDialog2.this.filter.getText() + "*"));
                Filter f2 = new Filter();
                f2.setName("image-type");
                f2.setValues(Arrays.asList("machine"));
                ArrayList<Filter> filters = new ArrayList<Filter>(Arrays.asList(f1, f2));
                List<Image> imgs = SelectAMIDialog2.this.provider.getImages(SelectAMIDialog2.this.region, filters);
                for (Image img : imgs) {
                    String itemName = "(" + img.getImageId() + ") " + img.getName();
                    SelectAMIDialog2.this.ami.add(itemName);
                    SelectAMIDialog2.this.ami.setData(itemName, (Object)img);
                }
            }
        });
        Label lblAmiList = new Label(container, 0);
        lblAmiList.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblAmiList.setText(this.bundle_dialog_label.getString("dialog.select_ami.ami_list_title"));
        this.ami = new org.eclipse.swt.widgets.List(container, 2816);
        GridData gd_ami = new GridData(4, 4, false, false, 2, 1);
        gd_ami.heightHint = 303;
        gd_ami.widthHint = 469;
        this.ami.setLayoutData((Object)gd_ami);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if (this.ami.getSelection().length == 0) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.bundle_messages.getString("dialogs.must_select_ami"));
            return;
        }
        this.output = (Image)this.ami.getData(this.ami.getSelection()[0]);
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_dialog_name.getString("select_ami"));
    }

    public Image getOutput() {
        return this.output;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }
}

