/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.aws.presenter.IStorage;
import com.clustercontrol.cloud.commons.util.MessageManager;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class VolumeProvider {
    public static MessageManager bundle_volume_type = MessageManager.getInstance("volume_type");
    private VolumeContentProvider vcp = new VolumeContentProvider();
    private VolumeLabelProvider vlp = new VolumeLabelProvider();

    public VolumeContentProvider getVolumeContentProvider() {
        return this.vcp;
    }

    public VolumeLabelProvider getVolumeLabelProvider() {
        return this.vlp;
    }

    public class VolumeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object element, int columnIndex) {
            IStorage storage = (IStorage)element;
            Boolean b1 = false;
            Boolean b2 = false;
            if (storage.getStorageAttachment() != null) {
                b1 = true;
                Pattern p = Pattern.compile("/dev/sda.*");
                Matcher m = p.matcher(storage.getStorageAttachment().getDevice());
                if (m.find()) {
                    b2 = true;
                }
            }
            switch (columnIndex) {
                case 0: {
                    return storage.getStorageId();
                }
                case 1: {
                    return storage.getStorageName();
                }
                case 2: {
                    return b2 != false ? "Root" : "EBS";
                }
                case 3: {
                    return b1.booleanValue() ? (storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "") : "";
                }
                case 4: {
                    return storage.getSnapshotId() != null ? storage.getSnapshotId() : "";
                }
                case 5: {
                    return storage.getSize() != null ? String.valueOf(storage.getSize()) : null;
                }
                case 6: {
                    return storage.getStorageKind() != null ? bundle_volume_type.getString(storage.getStorageKind()) : null;
                }
                case 7: {
                    return storage.getIops() != null ? String.valueOf(storage.getIops()) : "";
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    public class VolumeContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

