/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import java.util.concurrent.ThreadPoolExecutor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.part.ViewPart;

public abstract class AsyncUpdateViewPart
extends ViewPart {
    protected <T, S> void update(final DataHolder<T, S> item, final boolean force) {
        Object targetState = null;
        try {
            if (!item.prepare()) {
                return;
            }
            targetState = item.getTargetState();
            if (targetState == null || !force && item.isInitialized(targetState)) {
                item.success();
                return;
            }
            item.startAsyncCall(targetState);
        }
        catch (Exception e) {
            item.failPrepareAsyncCall(e);
            return;
        }
        final Object fTargetState = targetState;
        this.getExecutor().getQueue().clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object data = null;
                Exception exception = null;
                if (!item.isInitialized(fTargetState) || force) {
                    try {
                        data = item.asyncGetData(fTargetState);
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
                final Object fData = data;
                final Exception fException = exception;
                AsyncUpdateViewPart.this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (fData != null) {
                            item.syncSetData(fTargetState, fData);
                        }
                        if (fException != null) {
                            item.failAsyncCall(fTargetState, fException);
                        }
                        if (item.getTargetState() == fTargetState) {
                            if (fException == null) {
                                item.success();
                            } else {
                                item.error(fException);
                            }
                        }
                    }
                });
            }
        };
        this.getExecutor().execute(runnable);
    }

    public abstract void update();

    protected abstract ThreadPoolExecutor getExecutor();

    protected abstract StructuredViewer getViewer();

    public void setFocus() {
        this.getViewer().getControl().setFocus();
    }

    static interface DataHolder<T, S> {
        public S getTargetState();

        public S getCurrentState();

        public T asyncGetData(S var1) throws Exception;

        public boolean isInitialized(S var1);

        public boolean prepare();

        public void startAsyncCall(S var1);

        public void failAsyncCall(S var1, Exception var2);

        public void failPrepareAsyncCall(Exception var1);

        public void syncSetData(S var1, T var2);

        public void success();

        public void error(Exception var1);
    }
}

