/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.aws.presenter.CacheService;
import com.clustercontrol.cloud.aws.presenter.IInstance;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;

public class InstanceMonitorService {
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null) {
                Logger logger = Logger.getLogger(InstanceMonitorService.class);
                logger.debug((Object)t.getMessage(), t);
            }
        }
    };
    private List<InstanceIdentity> stoppedStatusMap = new ArrayList<InstanceIdentity>();
    private ScheduledFuture<?> sf;
    private CloudEndpoint endpoint;
    private Display display = Display.getCurrent();
    private static final ThreadLocal<InstanceMonitorService> instanceMonitorService = new ThreadLocal<InstanceMonitorService>(){

        @Override
        protected InstanceMonitorService initialValue() {
            return new InstanceMonitorService();
        }
    };

    private InstanceMonitorService() {
        this.endpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitor(IInstance instance, IInstance.StateType ... stoppedStatus) {
        List<InstanceIdentity> list = this.stoppedStatusMap;
        synchronized (list) {
            this.stoppedStatusMap.add(new InstanceIdentity(instance.getRegion().getRegionName(), instance.getInstanceId(), instance, stoppedStatus));
            if (this.sf == null) {
                this.sf = this.scheduleAtFixedRate(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Logger logger = Logger.getLogger(InstanceMonitorService.class);
                        try {
                            ArrayList tempStoppedStatus = new ArrayList();
                            List list = InstanceMonitorService.this.stoppedStatusMap;
                            synchronized (list) {
                                tempStoppedStatus.addAll(InstanceMonitorService.this.stoppedStatusMap);
                            }
                            Iterator iter = tempStoppedStatus.iterator();
                            block7: while (iter.hasNext()) {
                                final InstanceIdentity instanceIdentity = (InstanceIdentity)iter.next();
                                if (instanceIdentity.stateTypes == null) continue;
                                logger.debug((Object)("region : " + instanceIdentity.regionName + ", instanceid : " + instanceIdentity.instanceId + ", condition : " + instanceIdentity.stateTypes.toString()));
                                CloudInstance cloudInstance = null;
                                try {
                                    cloudInstance = InstanceMonitorService.this.endpoint.getInstance(instanceIdentity.regionName, instanceIdentity.instanceId);
                                    CacheService.getSingleton().put(instanceIdentity.instance, CloudInstance.class, cloudInstance);
                                    InstanceMonitorService.this.display.asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            instanceIdentity.instance.update();
                                        }
                                    });
                                    for (IInstance.StateType state : instanceIdentity.stateTypes) {
                                        if (!state.label().equals(cloudInstance.getState().value())) continue;
                                        Collections.synchronizedList(InstanceMonitorService.this.stoppedStatusMap).remove(instanceIdentity);
                                        iter.remove();
                                        continue block7;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error((Object)e.getMessage(), (Throwable)e);
                                    Collections.synchronizedList(InstanceMonitorService.this.stoppedStatusMap).remove(instanceIdentity);
                                    iter.remove();
                                }
                            }
                            InstanceMonitorService.this.mustStop();
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }, 10L, 10L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor(String indtanecId) {
        List<InstanceIdentity> list = this.stoppedStatusMap;
        synchronized (list) {
            this.stoppedStatusMap.remove(indtanecId);
            this.mustStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mustStop() {
        List<InstanceIdentity> list = this.stoppedStatusMap;
        synchronized (list) {
            if (this.sf != null && this.stoppedStatusMap.isEmpty()) {
                this.sf.cancel(true);
                this.sf = null;
            }
        }
    }

    private ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public void shutdown() {
        this.executor.shutdown();
        this.stoppedStatusMap.clear();
    }

    public static InstanceMonitorService getInstanceMonitorService() {
        return instanceMonitorService.get();
    }

    private static class InstanceIdentity {
        public IInstance instance;
        public String regionName;
        public String instanceId;
        public IInstance.StateType[] stateTypes;

        public InstanceIdentity(String regionName, String instanceId, IInstance instance, IInstance.StateType[] stateTypes) {
            this.regionName = regionName;
            this.instanceId = instanceId;
            this.instance = instance;
            this.stateTypes = stateTypes;
        }
    }
}

